/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex;

import java.util.logging.Level;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexExecNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexSource;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexSyntaxException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.UnsupportedRegexException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.TRegexCompilationRequest;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFA;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.TRegexExecNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.nfa.TRegexBacktrackingNFAExecutorNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.DebugUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.Loggers;

public final class TRegexCompiler {
    @CompilerDirectives.TruffleBoundary
    public static RegexObject compile(RegexLanguage language, RegexSource source) throws RegexSyntaxException {
        DebugUtil.Timer timer;
        DebugUtil.Timer timer2 = timer = TRegexCompiler.shouldLogCompilationTime() ? new DebugUtil.Timer() : null;
        if (timer != null) {
            timer.start();
        }
        try {
            RegexObject regex = TRegexCompiler.doCompile(language, source);
            TRegexCompiler.logCompilationTime(source, timer, regex);
            Loggers.LOG_COMPILER_FALLBACK.finer(() -> "TRegex compiled: " + String.valueOf(source));
            return regex;
        }
        catch (UnsupportedRegexException bailout) {
            TRegexCompiler.logCompilationTime(source, timer, null);
            Loggers.LOG_BAILOUT_MESSAGES.fine(() -> bailout.getReason() + ": " + String.valueOf(source));
            throw bailout;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static RegexObject doCompile(RegexLanguage language, RegexSource source) throws RegexSyntaxException {
        TRegexCompilationRequest compReq = new TRegexCompilationRequest(language, source);
        RegexExecNode execNode = compReq.compile();
        return new RegexObject(execNode, source, compReq.getAst().getFlavorSpecificFlags(), compReq.getAst().getNumberOfCaptureGroups(), compReq.getNamedCaptureGroups());
    }

    @CompilerDirectives.TruffleBoundary
    public static TRegexDFAExecutorNode compileEagerDFAExecutor(RegexLanguage language, RegexSource source) {
        TRegexDFAExecutorNode executor = new TRegexCompilationRequest(language, source).compileEagerDFAExecutor();
        if (executor.getCGTrackingCost() > 3000) {
            throw new UnsupportedRegexException("Too much additional capture group tracking overhead");
        }
        return executor;
    }

    @CompilerDirectives.TruffleBoundary
    public static TRegexExecNode.LazyCaptureGroupRegexSearchNode compileLazyDFAExecutor(RegexLanguage language, NFA nfa, RegexProfile rootNodeProfile, boolean allowSimpleCG) {
        return new TRegexCompilationRequest(language, nfa).compileLazyDFAExecutor(rootNodeProfile, allowSimpleCG);
    }

    @CompilerDirectives.TruffleBoundary
    public static TRegexBacktrackingNFAExecutorNode compileBacktrackingExecutor(RegexLanguage language, NFA nfa) {
        return new TRegexCompilationRequest(language, nfa).compileBacktrackingExecutor();
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean shouldLogCompilationTime() {
        return Loggers.LOG_TOTAL_COMPILATION_TIME.isLoggable(Level.FINE);
    }

    @CompilerDirectives.TruffleBoundary
    private static void logCompilationTime(RegexSource regexSource, DebugUtil.Timer timer, RegexObject regex) {
        if (timer != null) {
            Loggers.LOG_TOTAL_COMPILATION_TIME.log(Level.FINE, "Total compilation time: {0}, matcher: {1}, regex: {2}", new Object[]{timer.elapsedToString(), regex == null ? "bailout" : regex.getLabel(), DebugUtil.jsStringEscape(regexSource.toString())});
        }
    }
}

