/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.flavor.java;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexOptions;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexSource;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.flavor.java.JavaFlags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.flavor.java.JavaRegexLexer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.flavor.java.JavaRegexParser;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.flavor.java.JavaRegexValidator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexFlavor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexLexer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexParser;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexValidator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexAST;

public final class JavaFlavor
extends RegexFlavor {
    public static final JavaFlavor INSTANCE = new JavaFlavor();

    private JavaFlavor() {
        super(781);
    }

    @Override
    public String getName() {
        return "JavaUtilPattern";
    }

    @Override
    public RegexLexer createLexer(RegexSource source, CompilationBuffer compilationBuffer) {
        return new JavaRegexLexer(source, JavaFlags.parseFlags(source.getFlags()), compilationBuffer);
    }

    @Override
    public RegexParser createParser(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) {
        return JavaRegexParser.createParser(language, source, compilationBuffer);
    }

    @Override
    public RegexValidator createValidator(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) {
        return JavaRegexValidator.createValidator(source, compilationBuffer);
    }

    @Override
    public RegexFlavor.EqualsIgnoreCasePredicate getEqualsIgnoreCasePredicate(RegexAST ast) {
        return (a, b, altMode) -> JavaFlavor.getCaseFoldingAlgorithm(ast.getOptions(), altMode).getEqualsPredicate().test(a, b);
    }

    public static CaseFoldData.CaseFoldUnfoldAlgorithm getCaseFoldingAlgorithm(RegexOptions options, boolean isUnicodeCase) {
        if (isUnicodeCase) {
            if (options.getJavaJDKVersion() <= 24) {
                return CaseFoldData.CaseFoldUnfoldAlgorithm.JavaUnicode15;
            }
            return CaseFoldData.CaseFoldUnfoldAlgorithm.JavaUnicode16;
        }
        return CaseFoldData.CaseFoldUnfoldAlgorithm.Ascii;
    }

    @Override
    public CaseFoldData.CaseFoldAlgorithm getCaseFoldAlgorithm(RegexAST ast) {
        throw CompilerDirectives.shouldNotReachHere();
    }
}

