/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.ClassSetContents;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.CodePointSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.UnicodeProperties;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.UnicodePropertyData;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicMap;

final class UnicodePropertyDataDiff
extends UnicodePropertyData {
    private final UnicodePropertyData parent;
    private final EconomicMap<String, CodePointSetDiff> properties;

    UnicodePropertyDataDiff(UnicodePropertyData parent, EconomicMap<String, CodePointSetDiff> properties, EconomicMap<String, ClassSetContents> emoji, EconomicMap<String, String> propAliases, EconomicMap<String, String> gcAliases, EconomicMap<String, String> scAliases, EconomicMap<String, String> blkAliases) {
        super(null, emoji, propAliases, gcAliases, scAliases, blkAliases);
        this.properties = properties;
        this.parent = parent;
    }

    @Override
    CodePointSet retrieveProperty(String propertySpec) {
        CodePointSet parentEntry = this.parent.retrieveProperty(propertySpec);
        CodePointSetDiff diff = (CodePointSetDiff)this.properties.get(propertySpec);
        if (diff == null) {
            return parentEntry;
        }
        if (parentEntry == null) {
            assert (diff.sub.isEmpty());
            return diff.add;
        }
        return parentEntry.union(diff.add).subtract(diff.sub);
    }

    @Override
    ClassSetContents retrievePropertyOfStrings(String propertySpec) {
        CodePointSet prop = this.retrieveProperty(propertySpec);
        if (prop != null) {
            assert (!this.emoji.containsKey(propertySpec) && this.parent.retrieveEmojiProperty(propertySpec) == null);
            return ClassSetContents.createCharacterClass(prop);
        }
        ClassSetContents parentEntry = this.parent.retrieveEmojiProperty(propertySpec);
        ClassSetContents diff = (ClassSetContents)this.emoji.get(propertySpec);
        if (diff == null) {
            if (parentEntry != null) {
                return parentEntry;
            }
            if ("RGI_Emoji".equals(propertySpec)) {
                return this.getRGIEmoji();
            }
            return null;
        }
        if (parentEntry == null) {
            return diff;
        }
        return parentEntry.unionUnicodePropertyOfStrings(diff);
    }

    @Override
    String lookupPropertyAlias(String alias, UnicodeProperties.NameMatchingMode nameMatchingMode) {
        String name = super.lookupPropertyAlias(alias, nameMatchingMode);
        if (name == null) {
            return this.parent.lookupPropertyAlias(alias, nameMatchingMode);
        }
        return name;
    }

    @Override
    String lookupGeneralCategoryAlias(String alias, UnicodeProperties.NameMatchingMode nameMatchingMode) {
        String name = super.lookupGeneralCategoryAlias(alias, nameMatchingMode);
        if (name == null) {
            return this.parent.lookupGeneralCategoryAlias(alias, nameMatchingMode);
        }
        return name;
    }

    @Override
    String lookupScriptAlias(String alias, UnicodeProperties.NameMatchingMode nameMatchingMode) {
        String name = super.lookupScriptAlias(alias, nameMatchingMode);
        if (name == null) {
            return this.parent.lookupScriptAlias(alias, nameMatchingMode);
        }
        return name;
    }

    @Override
    String lookupBlockAlias(String alias, UnicodeProperties.NameMatchingMode nameMatchingMode) {
        String name = super.lookupBlockAlias(alias, nameMatchingMode);
        if (name == null) {
            return this.parent.lookupBlockAlias(alias, nameMatchingMode);
        }
        return name;
    }

    static final class CodePointSetDiff {
        final CodePointSet add;
        final CodePointSet sub;

        private CodePointSetDiff(CodePointSet add, CodePointSet sub) {
            this.add = add;
            this.sub = sub;
        }

        static CodePointSetDiff create(CodePointSet add, CodePointSet sub) {
            return new CodePointSetDiff(add, sub);
        }
    }
}

