/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset;

import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.ClassSetContents;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.CodePointSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.UnicodePropertyData;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicSet;

public class UnicodeProperties {
    private static final String[] OTHER_PROPERTIES_NAMES = new String[]{"OAlpha", "OLower", "OUpper", "OIDC", "OIDS"};
    private static final EconomicSet<String> OTHER_PROPERTIES_NAMES_SET = EconomicSet.create(OTHER_PROPERTIES_NAMES.length);
    public static final int BLOCKS = 1;
    public static final int OTHER_PROPERTIES = 2;
    private final UnicodePropertyData data;
    private final int flags;
    private final NameMatchingMode nameMatchingMode;

    public UnicodeProperties(UnicodePropertyData data, int flags, NameMatchingMode nameMatchingMode) {
        this.data = data;
        this.flags = flags;
        this.nameMatchingMode = nameMatchingMode;
    }

    private boolean isFlagSet(int flag) {
        return (this.flags & flag) != 0;
    }

    private boolean withBlocks() {
        return this.isFlagSet(1);
    }

    private boolean withOtherProperties() {
        return this.isFlagSet(2);
    }

    public CodePointSet getProperty(String propertySpec) {
        return this.evaluatePropertySpec(this.normalizePropertySpec(propertySpec));
    }

    public ClassSetContents getPropertyOfStrings(String propertySpec) {
        return this.evaluatePropertySpecStrings(this.normalizePropertySpec(propertySpec));
    }

    private CodePointSet evaluatePropertySpec(String propertySpec) {
        CodePointSet prop = this.data.retrieveProperty(propertySpec);
        if (prop == null) {
            throw new IllegalArgumentException("Unsupported Unicode character property escape");
        }
        return prop;
    }

    private ClassSetContents evaluatePropertySpecStrings(String propertySpec) {
        ClassSetContents prop = this.data.retrievePropertyOfStrings(propertySpec);
        if (prop == null) {
            throw new IllegalArgumentException("Unsupported Unicode character property escape");
        }
        return prop;
    }

    private String normalizePropertySpec(String propertySpec) {
        int equals = propertySpec.indexOf(61);
        if (equals >= 0) {
            String propertyName = this.normalizePropertyName(propertySpec.substring(0, equals));
            String propertyValue = propertySpec.substring(equals + 1);
            switch (propertyName) {
                case "blk": {
                    propertyValue = this.normalizeBlockName(propertyValue);
                    break;
                }
                case "gc": {
                    propertyValue = this.normalizeGeneralCategoryName(propertyValue);
                    break;
                }
                case "sc": 
                case "scx": {
                    propertyValue = this.normalizeScriptName(propertyValue);
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new IllegalArgumentException(String.format("Binary property %s cannot appear to the left of '=' in a Unicode property escape", propertySpec.substring(0, equals)));
                }
            }
            return propertyName + "=" + propertyValue;
        }
        if (this.isSupportedGeneralCategory(propertySpec)) {
            return "gc=" + this.normalizeGeneralCategoryName(propertySpec);
        }
        return this.normalizePropertyName(propertySpec);
    }

    private String normalizePropertyName(String propertyName) {
        String name = UnicodeProperties.returnOrThrow(propertyName, "character property", this.data.lookupPropertyAlias(propertyName, this.nameMatchingMode));
        if (!this.withOtherProperties() && OTHER_PROPERTIES_NAMES_SET.contains(name)) {
            throw new IllegalArgumentException(String.format("Unsupported Unicode character property '%s'", propertyName));
        }
        return name;
    }

    private String normalizeGeneralCategoryName(String generalCategoryName) {
        return UnicodeProperties.returnOrThrow(generalCategoryName, "character general category", this.data.lookupGeneralCategoryAlias(generalCategoryName, this.nameMatchingMode));
    }

    private String normalizeScriptName(String scriptName) {
        return UnicodeProperties.returnOrThrow(scriptName, "script name", this.data.lookupScriptAlias(scriptName, this.nameMatchingMode));
    }

    private String normalizeBlockName(String blockName) {
        if (!this.withBlocks()) {
            throw new IllegalArgumentException("Unsupported Unicode character property escape");
        }
        return UnicodeProperties.returnOrThrow(blockName, "block name", this.data.lookupBlockAlias(blockName, this.nameMatchingMode));
    }

    public boolean isSupportedProperty(String propertyName) {
        return this.data.lookupPropertyAlias(propertyName, this.nameMatchingMode) != null;
    }

    public boolean isSupportedGeneralCategory(String generalCategoryName) {
        return this.data.lookupGeneralCategoryAlias(generalCategoryName, this.nameMatchingMode) != null;
    }

    public boolean isSupportedScript(String scriptName) {
        return this.data.lookupScriptAlias(scriptName, this.nameMatchingMode) != null;
    }

    public boolean isSupportedBlock(String blockName) {
        assert (this.withBlocks());
        return this.data.lookupBlockAlias(blockName, this.nameMatchingMode) != null;
    }

    private static String returnOrThrow(String propertyName, String errorName, String name) {
        if (name == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException(String.format("Unsupported Unicode %s '%s'", errorName, propertyName));
        }
        return name;
    }

    static {
        OTHER_PROPERTIES_NAMES_SET.addAll(List.of(OTHER_PROPERTIES_NAMES));
    }

    public static enum NameMatchingMode {
        exact,
        ignoreCase,
        ruby;


        public String normalize(String name) {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> name;
                case 1 -> name.toLowerCase();
                case 2 -> name.replaceAll("[-_ ]", "").toLowerCase();
            };
        }
    }
}

