/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.object;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.ImageInfo;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.Platform;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
abstract class LayoutImpl {
    private static final Method initializeDynamicObjectLayout;
    private static final Method resetNativeImageState;

    LayoutImpl() {
    }

    static void initializeDynamicObjectLayout(Class<?> dynamicObjectClass) throws InvocationTargetException, IllegalAccessException {
        assert (ImageInfo.inImageBuildtimeCode()) : "Only supported during image generation";
        initializeDynamicObjectLayout.invoke(null, dynamicObjectClass, null);
    }

    static void resetNativeImageState() throws InvocationTargetException, IllegalAccessException {
        assert (ImageInfo.inImageBuildtimeCode()) : "Only supported during image generation";
        resetNativeImageState.invoke(null, new Object[0]);
    }

    static {
        try {
            Class<?> layoutImplClass = Class.forName("org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.LayoutImpl");
            initializeDynamicObjectLayout = layoutImplClass.getDeclaredMethod("initializeDynamicObjectLayout", Class.class, MethodHandles.Lookup.class);
            initializeDynamicObjectLayout.setAccessible(true);
            resetNativeImageState = layoutImplClass.getDeclaredMethod("resetNativeImageState", new Class[0]);
            resetNativeImageState.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

