/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.StopIterationException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.lang.JavaScriptLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop.JSInteropGetIteratorNextNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.IteratorRecord;

@ExportLibrary(value=InteropLibrary.class, delegateTo="iterator")
public final class JSIteratorWrapper
implements TruffleObject {
    final Object iterator;
    private final IteratorRecord iteratorRecord;
    private Object next;
    private static final Object STOP = StopIterationException.create();

    private JSIteratorWrapper(IteratorRecord iterator) {
        this.iterator = iterator.getIterator();
        this.iteratorRecord = iterator;
    }

    public static JSIteratorWrapper create(IteratorRecord iterator) {
        return new JSIteratorWrapper(iterator);
    }

    @ExportMessage
    boolean isIterator() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object next(JavaScriptLanguage language, JSRealm realm, JSInteropGetIteratorNextNode iteratorNextNode) {
        language.interopBoundaryEnter(realm);
        try {
            Object object = iteratorNextNode.getIteratorNextElement(this.iteratorRecord, language, STOP);
            return object;
        }
        finally {
            language.interopBoundaryExit(realm);
        }
    }

    @ExportMessage
    boolean hasIteratorNextElement(@CachedLibrary(value="this") InteropLibrary self, @Cached @Cached.Shared JSInteropGetIteratorNextNode iteratorNextNode) {
        JavaScriptLanguage language = JavaScriptLanguage.get(self);
        JSRealm realm = JSRealm.get(self);
        if (this.next == null) {
            this.next = this.next(language, realm, iteratorNextNode);
        }
        return this.next != STOP;
    }

    @ExportMessage
    Object getIteratorNextElement(@CachedLibrary(value="this") InteropLibrary self, @Cached @Cached.Shared JSInteropGetIteratorNextNode iteratorNextNode) throws StopIterationException {
        if (this.hasIteratorNextElement(self, iteratorNextNode)) {
            Object result = this.next;
            this.next = null;
            return result;
        }
        throw StopIterationException.create();
    }
}

