/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop;

import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;

@ExportLibrary(value=InteropLibrary.class)
public final class InteropArray
implements TruffleObject {
    final Object[] array;

    private InteropArray(Object[] array) {
        this.array = array;
    }

    public static InteropArray create(Object[] array) {
        return new InteropArray(array);
    }

    @CompilerDirectives.TruffleBoundary
    public static InteropArray create(List<? extends Object> list) {
        return new InteropArray(list.toArray(ScriptArray.EMPTY_OBJECT_ARRAY));
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    Object readArrayElement(long index) throws InvalidArrayIndexException {
        if (!this.isArrayElementReadable(index)) {
            throw InvalidArrayIndexException.create(index);
        }
        return this.array[(int)index];
    }

    @ExportMessage
    long getArraySize() {
        return this.array.length;
    }

    @ExportMessage
    boolean isArrayElementReadable(long index) {
        return index >= 0L && index < (long)this.array.length;
    }
}

