/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSAgentWaiterList;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemoryObject;

@ExportLibrary(value=InteropLibrary.class)
public final class JSWebAssemblyMemoryNotifyCallback
implements TruffleObject {
    private static final int INT32_BYTES_PER_ELEMENT = 4;
    private final JSRealm realm;
    private final JSContext context;

    public JSWebAssemblyMemoryNotifyCallback(JSRealm realm, JSContext context) {
        this.realm = realm;
        this.context = context;
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    Object execute(Object[] arguments) {
        assert (arguments.length == 3);
        JSWebAssemblyMemoryObject memoryObject = JSWebAssemblyMemory.create(this.context, this.realm, arguments[0], true);
        long address = (Long)arguments[1];
        int count = (Integer)arguments[2];
        JSArrayBufferObject buffer = memoryObject.getBufferObject(this.context, this.realm);
        return JSWebAssemblyMemoryNotifyCallback.atomicsNotify(buffer, (int)address, count);
    }

    private static int atomicsNotify(JSArrayBufferObject buffer, int address, int count) {
        int convertedCount = Integer.max(count, 0);
        JSAgentWaiterList waiterList = JSSharedArrayBuffer.getWaiterList(buffer);
        JSAgentWaiterList.JSAgentWaiterListEntry wl = waiterList.getListForIndex(address * 4);
        return JSAgentWaiterList.JSAgentWaiterListEntry.notifyWaiters(wl, convertedCount);
    }
}

