/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.RootCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception.AbstractTruffleException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.ExceptionType;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.ExplodeLoop;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DynamicObjectLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.wasm.WebAssemblyInstancePrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.wasm.ToJSValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.wasm.ToJSValueNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.wasm.ToWebAssemblyValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.wasm.ToWebAssemblyValueNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.GraalJSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSFrameUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JavaScriptRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssembly;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyGlobal;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyGlobalObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyInstanceObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemoryObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTable;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTableObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.WasmFunctionTypeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.WebAssemblyHostFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.WebAssemblyValueType;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public final class JSWebAssemblyInstance
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("Instance");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("Instance.prototype");
    private static final TruffleString MUT = Strings.constant("mut");
    public static final TruffleString WEB_ASSEMBLY_INSTANCE = Strings.constant("WebAssembly.Instance");
    public static final JSWebAssemblyInstance INSTANCE = new JSWebAssemblyInstance();
    static final TruffleString FUNCTION_ADAPTER_NAME = Strings.constant("wasm-function-adapter");

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject constructor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(prototype, constructor);
        JSObjectUtil.putAccessorsFromContainer(realm, prototype, WebAssemblyInstancePrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, WEB_ASSEMBLY_INSTANCE);
        return prototype;
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getWebAssemblyInstancePrototype();
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    public static JSWebAssemblyInstanceObject create(JSContext context, JSRealm realm, Object wasmInstance, Object wasmModule) {
        return JSWebAssemblyInstance.create(context, realm, INSTANCE.getIntrinsicDefaultProto(realm), wasmInstance, wasmModule);
    }

    public static JSWebAssemblyInstanceObject create(JSContext context, JSRealm realm, JSDynamicObject proto, Object wasmInstance, Object wasmModule) {
        JSObjectFactory factory = context.getWebAssemblyInstanceFactory();
        JSObject exportsObject = JSWebAssemblyInstance.createExportsObject(context, realm, wasmInstance, wasmModule);
        Shape shape = factory.getShape(realm, proto);
        JSWebAssemblyInstanceObject newObj = factory.initProto(new JSWebAssemblyInstanceObject(shape, proto, wasmInstance, exportsObject), realm, proto);
        return factory.trackAllocation(newObj);
    }

    @CompilerDirectives.TruffleBoundary
    private static JSObject createExportsObject(JSContext context, JSRealm realm, Object wasmInstance, Object wasmModule) {
        JSObject exports = JSOrdinary.createWithNullPrototype(context);
        try {
            Object exportsFunction = realm.getWASMModuleExports();
            Object exportsInfo = InteropLibrary.getUncached(exportsFunction).execute(exportsFunction, wasmModule);
            Object instanceExport = realm.getWASMInstanceExport();
            InteropLibrary exportsInterop = InteropLibrary.getUncached(exportsInfo);
            long size = exportsInterop.getArraySize(exportsInfo);
            for (long i = 0L; i < size; ++i) {
                Object value;
                Object exportInfo = exportsInterop.readArrayElement(exportsInfo, i);
                InteropLibrary exportInterop = InteropLibrary.getUncached(exportInfo);
                TruffleString name = JSWebAssemblyInstance.asTString(exportInterop.readMember(exportInfo, "name"));
                TruffleString externtype = JSWebAssemblyInstance.asTString(exportInterop.readMember(exportInfo, "kind"));
                Object externval = InteropLibrary.getUncached().execute(instanceExport, wasmInstance, Strings.toJavaString(name));
                if (Strings.equals(Strings.FUNCTION, externtype)) {
                    TruffleString typeInfo = JSWebAssemblyInstance.asTString(exportInterop.readMember(exportInfo, "type"));
                    value = JSWebAssemblyInstance.exportFunction(context, realm, externval, typeInfo);
                } else if (Strings.equals(Strings.GLOBAL, externtype)) {
                    type = JSWebAssemblyInstance.asTString(exportInterop.readMember(exportInfo, "type"));
                    int sepIndex = Strings.indexOf(type, ' ');
                    TruffleString valueTypeStr = Strings.substring(context, type, 0, sepIndex);
                    WebAssemblyValueType valueType = WebAssemblyValueType.valueOf(valueTypeStr.toJavaStringUncached());
                    boolean mutable = Strings.regionEquals(type, sepIndex + 1, MUT, 0, 3);
                    value = JSWebAssemblyGlobal.create(context, realm, externval, valueType, mutable);
                } else if (Strings.MEMORY.equals(externtype)) {
                    type = JSWebAssemblyInstance.asTString(exportInterop.readMember(exportInfo, "type"));
                    boolean shared = Strings.regionEquals(type, 0, Strings.SHARED, 0, 6);
                    value = JSWebAssemblyMemory.create(context, realm, externval, shared);
                } else {
                    assert (Strings.TABLE.equals(externtype));
                    TruffleString typeStr = JSWebAssemblyInstance.asTString(exportInterop.readMember(exportInfo, "type"));
                    WebAssemblyValueType type = WebAssemblyValueType.valueOf(typeStr.toJavaStringUncached());
                    value = JSWebAssemblyTable.create(context, realm, externval, type);
                }
                JSObject.set((JSDynamicObject)exports, name, value);
            }
        }
        catch (InteropException ex) {
            throw Errors.shouldNotReachHere(ex);
        }
        exports.setIntegrityLevel(true, true);
        return exports;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object exportFunction(JSContext context, JSRealm realm, Object export, TruffleString typeInfo) {
        Object embedderData = JSWebAssembly.getEmbedderData(realm, export);
        if (embedderData instanceof JSFunctionObject) {
            return embedderData;
        }
        WasmFunctionTypeInfo typeInfoKey = JSWebAssemblyInstance.parseWasmFunctionTypeInfo(context, typeInfo);
        TruffleString name = Strings.substring(context, typeInfo, 0, Strings.indexOf(typeInfo, '('));
        JSFunctionData functionData = JSWebAssemblyInstance.getOrCreateExportedWasmFunctionAdapter(context, typeInfoKey);
        JSFunctionObject result = JSFunction.create(realm, functionData);
        JSFunction.setFunctionName(result, name);
        JSObjectUtil.putHiddenProperty(result, JSWebAssembly.FUNCTION_ADDRESS, export);
        JSWebAssembly.setEmbedderData(realm, export, result);
        return result;
    }

    private static WasmFunctionTypeInfo parseWasmFunctionTypeInfo(JSContext context, TruffleString typeInfo) {
        int idxOpen = Strings.indexOf(typeInfo, '(');
        int idxClose = Strings.indexOf(typeInfo, ')');
        TruffleString argTypes = Strings.lazySubstring(typeInfo, idxOpen + 1, idxClose - (idxOpen + 1));
        TruffleString returnTypes = Strings.lazySubstring(typeInfo, idxClose + 1);
        WebAssemblyValueType[] paramTypes = JSWebAssemblyInstance.parseTypeSequence(context, argTypes);
        WebAssemblyValueType[] resultTypes = JSWebAssemblyInstance.parseTypeSequence(context, returnTypes);
        boolean anyReturnTypeIsI64 = Arrays.asList(resultTypes).contains((Object)WebAssemblyValueType.i64);
        boolean anyArgTypeIsI64 = Arrays.asList(paramTypes).contains((Object)WebAssemblyValueType.i64);
        boolean anyReturnTypeIsV128 = Arrays.asList(resultTypes).contains((Object)WebAssemblyValueType.v128);
        boolean anyArgTypeIsV128 = Arrays.asList(paramTypes).contains((Object)WebAssemblyValueType.v128);
        return new WasmFunctionTypeInfo(paramTypes, resultTypes, anyReturnTypeIsI64 || anyArgTypeIsI64, anyReturnTypeIsV128 || anyArgTypeIsV128);
    }

    private static WebAssemblyValueType[] parseTypeSequence(JSContext context, TruffleString typeString) {
        TruffleString[] types = Strings.split(context, typeString, Strings.SPACE);
        WebAssemblyValueType[] result = new WebAssemblyValueType[types.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = WebAssemblyValueType.lookupType(types[i].toJavaStringUncached());
        }
        return result;
    }

    private static JSFunctionData getOrCreateExportedWasmFunctionAdapter(JSContext context, WasmFunctionTypeInfo funcType) {
        Map<WasmFunctionTypeInfo, JSFunctionData> cache = context.getWebAssemblyCache().wasmFunctionAdapterCache;
        JSFunctionData functionData = cache.get(funcType);
        if (functionData == null) {
            functionData = cache.computeIfAbsent(funcType, k -> {
                RootCallTarget callTarget = new WasmToJSFunctionAdapterRootNode(context, funcType).getCallTarget();
                return JSFunctionData.createCallOnly(context, callTarget, funcType.paramLength(), FUNCTION_ADAPTER_NAME);
            });
        }
        return functionData;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CompilerDirectives.TruffleBoundary
    public static Object transformImportObject(JSContext context, JSRealm realm, Object wasmModule, Object importObject) {
        try {
            JSObject transformedImportObject = JSOrdinary.createWithNullPrototype(context);
            Object importsFn = realm.getWASMModuleImports();
            Object imports = InteropLibrary.getUncached(importsFn).execute(importsFn, wasmModule);
            InteropLibrary importsInterop = InteropLibrary.getUncached(imports);
            long size = importsInterop.getArraySize(imports);
            for (long i = 0L; i < size; ++i) {
                void var21_20;
                Object wasmValue;
                Object descriptor = importsInterop.readArrayElement(imports, i);
                InteropLibrary descriptorInterop = InteropLibrary.getUncached(descriptor);
                TruffleString module = JSWebAssemblyInstance.asTString(descriptorInterop.readMember(descriptor, "module"));
                Object moduleImportObject = JSRuntime.get(importObject, module);
                InteropLibrary moduleImportObjectInterop = InteropLibrary.getUncached(moduleImportObject);
                if (!moduleImportObjectInterop.hasMembers(moduleImportObject)) {
                    throw Errors.createTypeError("Imported module \"" + String.valueOf(module) + "\" is not an object: " + String.valueOf(JSRuntime.safeToString(moduleImportObject)));
                }
                TruffleString name = JSWebAssemblyInstance.asTString(descriptorInterop.readMember(descriptor, "name"));
                Object value = JSRuntime.get(moduleImportObject, name);
                TruffleString externType = JSWebAssemblyInstance.asTString(descriptorInterop.readMember(descriptor, "kind"));
                if (Strings.equals(Strings.FUNCTION, externType)) {
                    if (!JSRuntime.isCallable(value)) {
                        throw JSWebAssemblyInstance.createLinkErrorImport(i, module, name, "Imported value is not callable");
                    }
                    if (JSWebAssembly.isExportedFunction(value)) {
                        wasmValue = JSWebAssembly.getExportedFunction((JSDynamicObject)value);
                    } else {
                        TruffleString truffleString = JSWebAssemblyInstance.asTString(descriptorInterop.readMember(descriptor, "type"));
                        wasmValue = JSWebAssemblyInstance.createHostFunction(value, JSWebAssemblyInstance.parseWasmFunctionTypeInfo(context, truffleString));
                    }
                } else if (Strings.equals(Strings.GLOBAL, externType)) {
                    boolean bl = JSRuntime.isNumber(value);
                    boolean isBigInt = JSRuntime.isBigInt(value);
                    if (bl || context.getLanguageOptions().wasmBigInt() && isBigInt) {
                        boolean isI64;
                        TruffleString valueTypeStr = JSWebAssemblyInstance.asTString(descriptorInterop.readMember(descriptor, "type"));
                        WebAssemblyValueType valueType = WebAssemblyValueType.lookupType(valueTypeStr.toJavaStringUncached());
                        boolean bl2 = isI64 = valueType == WebAssemblyValueType.i64;
                        if (!context.getLanguageOptions().wasmBigInt() && isI64) {
                            throw JSWebAssemblyInstance.createLinkErrorImport(i, module, name, "Can't import the value of i64 WebAssembly.Global");
                        }
                        if (isI64 && bl) {
                            throw JSWebAssemblyInstance.createLinkErrorImport(i, module, name, "Value of valtype i64 must be BigInt");
                        }
                        if (!isI64 && isBigInt) {
                            throw JSWebAssemblyInstance.createLinkErrorImport(i, module, name, "BigInt can only be stored in valtype i64");
                        }
                        if (valueType == WebAssemblyValueType.v128) {
                            throw JSWebAssemblyInstance.createLinkErrorImport(i, module, name, "Values of valtype v128 cannot be imported from JS");
                        }
                        Object webAssemblyValue = ToWebAssemblyValueNodeGen.getUncached().execute(value, valueType);
                        try {
                            Object createGlobal = realm.getWASMGlobalAlloc();
                            wasmValue = InteropLibrary.getUncached(createGlobal).execute(createGlobal, valueTypeStr, false, webAssemblyValue);
                        }
                        catch (InteropException ex) {
                            throw Errors.shouldNotReachHere(ex);
                        }
                    } else {
                        if (!JSWebAssemblyGlobal.isJSWebAssemblyGlobal(value)) throw JSWebAssemblyInstance.createLinkErrorImport(i, module, name, "Imported value is not a WebAssembly.Global object");
                        wasmValue = ((JSWebAssemblyGlobalObject)value).getWASMGlobal();
                    }
                } else if (Strings.equals(Strings.MEMORY, externType)) {
                    if (!JSWebAssemblyMemory.isJSWebAssemblyMemory(value)) throw JSWebAssemblyInstance.createLinkErrorImport(i, module, name, "Imported value is not a WebAssembly.Memory object");
                    wasmValue = ((JSWebAssemblyMemoryObject)value).getWASMMemory();
                } else {
                    assert (Strings.equals(Strings.TABLE, externType)) : externType;
                    if (!JSWebAssemblyTable.isJSWebAssemblyTable(value)) throw JSWebAssemblyInstance.createLinkErrorImport(i, module, name, "Imported value is not a WebAssembly.Table object");
                    wasmValue = ((JSWebAssemblyTableObject)value).getWASMTable();
                }
                if (JSObject.hasOwnProperty((JSDynamicObject)transformedImportObject, module)) {
                    JSDynamicObject jSDynamicObject = (JSDynamicObject)JSObject.get((JSDynamicObject)transformedImportObject, module);
                } else {
                    JSObject jSObject = JSOrdinary.create(context, realm);
                    JSObject.set((JSDynamicObject)transformedImportObject, module, (Object)jSObject);
                }
                JSObject.set((JSDynamicObject)var21_20, name, wasmValue);
            }
            return transformedImportObject;
        }
        catch (InteropException ex) {
            throw Errors.shouldNotReachHere(ex);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException createLinkErrorImport(long index, TruffleString module, TruffleString name, String message) {
        return Errors.createLinkError("Import #" + index + " \"" + String.valueOf(module) + "\" \"" + String.valueOf(name) + "\": " + message);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object createHostFunction(Object fn, WasmFunctionTypeInfo typeInfo) {
        return new WebAssemblyHostFunction(fn, typeInfo);
    }

    private static TruffleString asTString(Object string) {
        if (string instanceof String) {
            return Strings.fromJavaString((String)string);
        }
        return Strings.interopAsTruffleString(string);
    }

    public static final class Cache {
        final Map<WasmFunctionTypeInfo, JSFunctionData> wasmFunctionAdapterCache = new ConcurrentHashMap<WasmFunctionTypeInfo, JSFunctionData>();
    }

    private static class WasmToJSFunctionAdapterRootNode
    extends JavaScriptRootNode {
        private static final int MAX_UNROLL = 32;
        private final JSContext context;
        private final WasmFunctionTypeInfo type;
        @Node.Child
        ToWebAssemblyValueNode toWebAssemblyValueNode = ToWebAssemblyValueNodeGen.create();
        @Node.Child
        ToJSValueNode toJSValueNode = ToJSValueNodeGen.create();
        private final BranchProfile errorBranch = BranchProfile.create();
        @Node.Child
        InteropLibrary exportFunctionLib = InteropLibrary.getFactory().createDispatched(5);
        @Node.Child
        InteropLibrary readArrayElementLib = InteropLibrary.getFactory().createDispatched(5);
        @Node.Child
        DynamicObjectLibrary getExportedFunctionLib = JSObjectUtil.createDispatched(JSWebAssembly.FUNCTION_ADDRESS);

        WasmToJSFunctionAdapterRootNode(JSContext context, WasmFunctionTypeInfo type) {
            super(context.getLanguage(), null, null);
            this.context = context;
            this.type = type;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (!this.context.getLanguageOptions().wasmBigInt() && this.type.anyTypeIsI64() || this.type.anyTypeIsV128()) {
                this.errorBranch.enter();
                throw Errors.createTypeError("wasm function signature contains illegal type");
            }
            int argCount = this.type.paramLength();
            int returnLength = this.type.resultLength();
            Object[] frameArguments = frame.getArguments();
            Object[] wasmArgs = this.convertArgsToWasm(frameArguments, argCount);
            Object export = this.getExportedFunctionLib.getOrDefault(JSFrameUtil.getFunctionObject(frame), JSWebAssembly.FUNCTION_ADDRESS, null);
            try {
                Object wasmResult;
                try {
                    wasmResult = this.exportFunctionLib.execute(export, wasmArgs);
                }
                catch (GraalJSException jsex) {
                    this.errorBranch.enter();
                    throw jsex;
                }
                catch (AbstractTruffleException tex) {
                    this.errorBranch.enter();
                    ExceptionType exceptionType = InteropLibrary.getUncached(tex).getExceptionType(tex);
                    if (exceptionType == ExceptionType.INTERRUPT || exceptionType == ExceptionType.EXIT) {
                        throw tex;
                    }
                    throw Errors.createRuntimeError(tex, this);
                }
                if (returnLength == 0) {
                    return Undefined.instance;
                }
                if (returnLength == 1) {
                    return this.toJSValueNode.execute(wasmResult);
                }
                Object[] values = new Object[returnLength];
                for (int i = 0; i < returnLength; ++i) {
                    values[i] = this.toJSValueNode.execute(this.readArrayElementLib.readArrayElement(wasmResult, i));
                }
                return JSArray.createConstantObjectArray(this.context, this.getRealm(), values);
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
        }

        @ExplodeLoop
        private Object[] convertArgsToWasm(Object[] frameArguments, int paramCount) {
            CompilerAsserts.partialEvaluationConstant(paramCount);
            if (paramCount > 32) {
                return this.convertArgsToWasmNoUnroll(frameArguments, paramCount);
            }
            Object[] wasmArgs = new Object[paramCount];
            for (int i = 0; i < paramCount; ++i) {
                wasmArgs[i] = this.convertArgToWasm(frameArguments, i);
            }
            return wasmArgs;
        }

        private Object[] convertArgsToWasmNoUnroll(Object[] frameArguments, int paramCount) {
            Object[] wasmArgs = new Object[paramCount];
            for (int i = 0; i < paramCount; ++i) {
                wasmArgs[i] = this.convertArgToWasm(frameArguments, i);
            }
            return wasmArgs;
        }

        private Object convertArgToWasm(Object[] frameArguments, int i) {
            Object wasmArg = i < JSArguments.getUserArgumentCount(frameArguments) ? JSArguments.getUserArgument(frameArguments, i) : Undefined.instance;
            return this.toWebAssemblyValueNode.execute(wasmArg, this.type.paramTypes()[i]);
        }

        @Override
        public String toString() {
            return FUNCTION_ADAPTER_NAME.toJavaStringUncached() + ":" + this.type.toString();
        }
    }
}

