/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal.TemporalPlainDateFunctionBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal.TemporalPlainDatePrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public final class JSTemporalPlainDate
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final JSTemporalPlainDate INSTANCE = new JSTemporalPlainDate();
    public static final TruffleString CLASS_NAME = Strings.constant("PlainDate");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("PlainDate.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Temporal.PlainDate");

    private JSTemporalPlainDate() {
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject constructor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(prototype, constructor);
        JSObjectUtil.putAccessorsFromContainer(realm, prototype, TemporalPlainDatePrototypeBuiltins.BUILTINS);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, TemporalPlainDatePrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, TO_STRING_TAG);
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getTemporalPlainDatePrototype();
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, TemporalPlainDateFunctionBuiltins.BUILTINS);
    }

    public static boolean isJSTemporalPlainDate(Object obj) {
        return obj instanceof JSTemporalPlainDateObject;
    }

    public static JSTemporalPlainDateObject create(JSContext context, JSRealm realm, int year, int month, int day, TruffleString calendar, Node node, InlinedBranchProfile errorBranch) {
        return JSTemporalPlainDate.create(context, realm, INSTANCE.getIntrinsicDefaultProto(realm), year, month, day, calendar, node, errorBranch);
    }

    public static JSTemporalPlainDateObject create(JSContext context, JSRealm realm, JSDynamicObject proto, int year, int month, int day, TruffleString calendar, Node node, InlinedBranchProfile errorBranch) {
        if (!TemporalUtil.isValidISODate(year, month, day)) {
            errorBranch.enter(node);
            throw TemporalErrors.createRangeErrorDateTimeOutsideRange();
        }
        if (!TemporalUtil.isoDateTimeWithinLimits(year, month, day, 12, 0, 0, 0, 0, 0)) {
            errorBranch.enter(node);
            throw TemporalErrors.createRangeErrorDateOutsideRange();
        }
        return JSTemporalPlainDate.createIntl(context, realm, proto, year, month, day, calendar);
    }

    @HostCompilerDirectives.InliningCutoff
    private static JSTemporalPlainDateObject createIntl(JSContext context, JSRealm realm, JSDynamicObject proto, int year, int month, int day, TruffleString calendar) {
        JSObjectFactory factory = context.getTemporalPlainDateFactory();
        Shape shape = factory.getShape(realm, proto);
        JSTemporalPlainDateObject newObj = factory.initProto(new JSTemporalPlainDateObject(shape, proto, year, month, day, calendar), realm, proto);
        return factory.trackAllocation(newObj);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString temporalDateToString(JSTemporalPlainDateObject date, TemporalUtil.ShowCalendar showCalendar) {
        TruffleString yearString = TemporalUtil.padISOYear(date.getYear());
        TruffleString monthString = TemporalUtil.toZeroPaddedDecimalString(date.getMonth(), 2);
        TruffleString dayString = TemporalUtil.toZeroPaddedDecimalString(date.getDay(), 2);
        TruffleString calendar = TemporalUtil.maybeFormatCalendarAnnotation(date.getCalendar(), showCalendar);
        return Strings.format("%s-%s-%s%s", yearString, monthString, dayString, calendar);
    }
}

