/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl;

import java.text.Normalizer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.intl.CollatorFunctionBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.intl.CollatorPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSCollatorObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.Collator;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.RuleBasedCollator;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.ULocale;

public final class JSCollator
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("Collator");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("Collator.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Intl.Collator");
    public static final JSCollator INSTANCE = new JSCollator();

    private JSCollator() {
    }

    public static boolean isJSCollator(Object obj) {
        return obj instanceof JSCollatorObject;
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject collatorPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(collatorPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, collatorPrototype, CollatorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putAccessorsFromContainer(realm, collatorPrototype, CollatorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(collatorPrototype, TO_STRING_TAG);
        return collatorPrototype;
    }

    @CompilerDirectives.TruffleBoundary
    public static void initializeCollator(JSContext ctx, InternalState state, String[] locales, String usage, String localeMatcher, String optco, Boolean optkn, String optkf, String sensitivity, Boolean ignorePunctuation) {
        boolean resolvedIgnorePunctuation;
        boolean searchUsage;
        String coType;
        List<String> validCollations;
        state.initializedCollator = true;
        state.usage = usage;
        Locale selectedLocale = IntlUtil.selectedLocale(ctx, locales);
        Locale strippedLocale = selectedLocale.stripExtensions();
        Locale.Builder builder = new Locale.Builder().setLocale(strippedLocale);
        Boolean kn = optkn;
        String knTypeStr = selectedLocale.getUnicodeLocaleType("kn");
        Boolean knType = null;
        if ("".equals(knTypeStr) || "true".equals(knTypeStr)) {
            knType = true;
        } else if ("false".equals(knTypeStr)) {
            knType = false;
        }
        if (knType != null && (optkn == null || optkn.equals(knType))) {
            String value = knType != false ? "" : "false";
            kn = knType;
            builder.setUnicodeLocaleKeyword("kn", value);
        }
        if (kn != null) {
            state.numeric = kn;
        }
        String kf = optkf;
        String kfType = selectedLocale.getUnicodeLocaleType("kf");
        if (("upper".equals(kfType) || "lower".equals(kfType) || "false".equals(kfType)) && (optkf == null || optkf.equals(kfType))) {
            kf = kfType;
            builder.setUnicodeLocaleKeyword("kf", kfType);
        }
        if (kf != null) {
            state.caseFirst = kf;
        }
        if (!(validCollations = Arrays.asList(IntlUtil.availableCollations(ULocale.forLocale(strippedLocale), false))).contains(coType = selectedLocale.getUnicodeLocaleType("co"))) {
            coType = null;
        }
        String coOption = optco;
        if (!validCollations.contains(optco) || Objects.equals(coType, optco)) {
            coOption = null;
        }
        String collation = null;
        if (coOption == null && coType != null) {
            collation = coType;
            builder.setUnicodeLocaleKeyword("co", coType);
        }
        if (coOption != null) {
            collation = coOption;
        }
        if (!(searchUsage = "search".equals(usage)) && collation != null) {
            state.collation = collation;
        }
        if (sensitivity != null) {
            state.sensitivity = sensitivity;
        }
        state.locale = builder.build().toLanguageTag();
        if (kn != null) {
            builder.setUnicodeLocaleKeyword("kn", kn != false ? "" : "false");
        }
        if (kf != null) {
            builder.setUnicodeLocaleKeyword("kf", kf);
        }
        if (searchUsage) {
            builder.setUnicodeLocaleKeyword("co", "search");
        } else if (collation != null) {
            builder.setUnicodeLocaleKeyword("co", collation);
        }
        Locale collatorLocale = builder.build();
        state.collator = Collator.getInstance(collatorLocale);
        state.collator.setDecomposition(17);
        switch (state.sensitivity) {
            case "base": {
                state.collator.setStrength(0);
                break;
            }
            case "accent": {
                state.collator.setStrength(1);
                break;
            }
            case "case": {
                state.collator.setStrength(0);
                if (!(state.collator instanceof RuleBasedCollator)) break;
                ((RuleBasedCollator)state.collator).setCaseLevel(true);
                break;
            }
            case "variant": {
                state.collator.setStrength(2);
            }
        }
        Collator collator = state.collator;
        if (collator instanceof RuleBasedCollator) {
            RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)collator;
            if (ignorePunctuation == null) {
                resolvedIgnorePunctuation = ruleBasedCollator.isAlternateHandlingShifted();
            } else {
                ruleBasedCollator.setAlternateHandlingShifted(ignorePunctuation);
                resolvedIgnorePunctuation = ignorePunctuation;
            }
        } else {
            resolvedIgnorePunctuation = ignorePunctuation == null ? false : ignorePunctuation;
        }
        state.ignorePunctuation = resolvedIgnorePunctuation;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, CollatorFunctionBuiltins.BUILTINS);
    }

    public static JSCollatorObject create(JSContext context, JSRealm realm) {
        JSObjectFactory factory = context.getCollatorFactory();
        return JSCollator.create(factory, realm, factory.getPrototype(realm));
    }

    public static JSCollatorObject create(JSContext context, JSRealm realm, JSDynamicObject proto) {
        JSObjectFactory factory = context.getCollatorFactory();
        return JSCollator.create(factory, realm, proto);
    }

    private static JSCollatorObject create(JSObjectFactory factory, JSRealm realm, JSDynamicObject proto) {
        InternalState state = new InternalState();
        Shape shape = factory.getShape(realm, proto);
        JSCollatorObject newObj = factory.initProto(new JSCollatorObject(shape, proto, state), realm, proto);
        return factory.trackAllocation(newObj);
    }

    @CompilerDirectives.TruffleBoundary
    public static int compare(JSCollatorObject collatorObj, String one, String two) {
        Collator collator = collatorObj.getInternalState().collator;
        return collator.compare(JSCollator.normalize(one), JSCollator.normalize(two));
    }

    private static String normalize(String s) {
        CompilerAsserts.neverPartOfCompilation();
        return Normalizer.normalize(s, Normalizer.Form.NFD);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSDynamicObject resolvedOptions(JSContext context, JSRealm realm, JSCollatorObject collatorObj) {
        InternalState state = collatorObj.getInternalState();
        return state.toResolvedOptionsObject(context, realm);
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getCollatorPrototype();
    }

    public static class InternalState {
        private boolean initializedCollator = false;
        private Collator collator;
        private JSDynamicObject boundCompareFunction = null;
        private String locale;
        private String usage = "sort";
        private String sensitivity = "variant";
        private String collation = "default";
        private boolean ignorePunctuation = false;
        private boolean numeric = false;
        private String caseFirst = "false";

        JSObject toResolvedOptionsObject(JSContext context, JSRealm realm) {
            JSObject result = JSOrdinary.create(context, realm);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_LOCALE, Strings.fromJavaString(this.locale), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_USAGE, Strings.fromJavaString(this.usage), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_SENSITIVITY, Strings.fromJavaString(this.sensitivity), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_IGNORE_PUNCTUATION, this.ignorePunctuation, JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_COLLATION, Strings.fromJavaString(this.collation), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_NUMERIC, this.numeric, JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_CASE_FIRST, Strings.fromJavaString(this.caseFirst), JSAttributes.getDefault());
            return result;
        }

        public boolean isInitializedCollator() {
            return this.initializedCollator;
        }

        public JSDynamicObject getBoundCompareFunction() {
            return this.boundCompareFunction;
        }

        public void setBoundCompareFunction(JSDynamicObject boundCompareFunction) {
            this.boundCompareFunction = boundCompareFunction;
        }
    }
}

