/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl;

import java.util.Locale;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;

public abstract class AbstractInternalState {
    protected Locale javaLocale;
    protected String locale;
    protected String numberingSystem;

    @CompilerDirectives.TruffleBoundary
    public void resolveLocaleAndNumberingSystem(JSContext ctx, String[] locales, String numberingSystemOpt) {
        String nuOpt;
        Locale selectedLocale = IntlUtil.selectedLocale(ctx, locales);
        Locale strippedLocale = selectedLocale.stripExtensions();
        if (strippedLocale.toLanguageTag().equals("und")) {
            selectedLocale = ctx.getLocale();
            strippedLocale = selectedLocale.stripExtensions();
        }
        Locale.Builder builder = new Locale.Builder();
        builder.setLocale(strippedLocale);
        String nuType = selectedLocale.getUnicodeLocaleType("nu");
        if (!IntlUtil.isValidNumberingSystem(nuType)) {
            nuType = null;
        }
        if (!IntlUtil.isValidNumberingSystem(nuOpt = numberingSystemOpt) || Objects.equals(nuType, nuOpt)) {
            nuOpt = null;
        }
        if (nuOpt == null && nuType != null) {
            this.numberingSystem = nuType;
            builder.setUnicodeLocaleKeyword("nu", nuType);
        }
        this.locale = builder.build().toLanguageTag();
        if (nuOpt != null) {
            this.numberingSystem = nuOpt;
            builder.setUnicodeLocaleKeyword("nu", nuOpt);
        }
        this.javaLocale = builder.build();
        if (this.numberingSystem == null) {
            this.numberingSystem = IntlUtil.defaultNumberingSystemName(ctx, this.javaLocale);
        }
    }
}

