/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAbstractArgumentsArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSClass;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public final class JSSlowArgumentsArray
extends JSAbstractArgumentsArray {
    static final JSSlowArgumentsArray INSTANCE = new JSSlowArgumentsArray();

    private JSSlowArgumentsArray() {
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(JSDynamicObject thisObj, long index, boolean isStrict) {
        boolean wasDeleted;
        boolean isMappedArguments = JSSlowArgumentsArray.isMappedArguments(thisObj);
        boolean indexDisconnected = isMappedArguments && JSSlowArgumentsArray.wasIndexDisconnected(thisObj, index);
        Object oldValue = indexDisconnected ? null : this.get(thisObj, index);
        ScriptArray arrayType = JSSlowArgumentsArray.arrayGetArrayType(thisObj);
        if (arrayType.hasElement(thisObj, index)) {
            if (arrayType.isSealed()) {
                if (isStrict) {
                    throw Errors.createTypeErrorCannotDeletePropertyOfSealedArray(index);
                }
                return false;
            }
            JSSlowArgumentsArray.arraySetArrayType(thisObj, arrayType.deleteElement(thisObj, index, false));
            wasDeleted = true;
        } else {
            wasDeleted = JSOrdinary.INSTANCE.delete(thisObj, index, isStrict);
        }
        if (wasDeleted && isMappedArguments && !indexDisconnected) {
            JSSlowArgumentsArray.disconnectIndex(thisObj, index, oldValue);
        }
        return wasDeleted;
    }

    public static boolean isJSSlowArgumentsObject(JSDynamicObject obj) {
        return JSSlowArgumentsArray.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    protected JSDynamicObject makeSlowArray(JSDynamicObject thisObj) {
        assert (JSSlowArgumentsArray.isJSSlowArgumentsObject(thisObj));
        return thisObj;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(JSDynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        TruffleString indexAsString = Strings.fromLong(index);
        if (JSOrdinary.INSTANCE.hasOwnProperty(thisObj, indexAsString)) {
            return JSSlowArgumentsArray.ordinarySet(thisObj, indexAsString, value, receiver, isStrict, encapsulatingNode);
        }
        return super.set(thisObj, index, value, receiver, isStrict, encapsulatingNode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(JSDynamicObject store, Object thisObj, long index, Node encapsulatingNode) {
        TruffleString indexAsString = Strings.fromLong(index);
        if (JSOrdinary.INSTANCE.hasOwnProperty(store, indexAsString)) {
            return JSOrdinary.INSTANCE.getOwnHelper(store, thisObj, indexAsString, encapsulatingNode);
        }
        return super.getOwnHelper(store, thisObj, index, encapsulatingNode);
    }
}

