/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnknownIdentifierException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSBigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSBoolean;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNumber;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class JSPrimitive
extends JSNonProxy
implements PrototypeSupplier {
    protected JSPrimitive() {
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final Object getHelper(JSDynamicObject store, Object thisObj, Object key, Node encapsulatingNode) {
        assert (this == JSNumber.INSTANCE || this == JSString.INSTANCE || this == JSBoolean.INSTANCE || this == JSBigInt.INSTANCE);
        Object propertyValue = super.getHelper(store, thisObj, key, encapsulatingNode);
        if (key instanceof TruffleString) {
            JSRealm realm;
            JSContext context;
            TruffleString name = (TruffleString)key;
            if (JSPrimitive.allowJavaMembersFor(thisObj) && (context = JSObject.getJSContext(store)).isOptionNashornCompatibilityMode() && (realm = JSRealm.get(null)).isJavaInteropEnabled() && propertyValue == null) {
                return JSPrimitive.getJavaProperty(thisObj, Strings.toJavaString(name), realm);
            }
        }
        return propertyValue;
    }

    private static Object getJavaProperty(Object thisObj, String name, JSRealm realm) {
        String thisStr = Strings.toJavaString((TruffleString)thisObj);
        Object boxedString = realm.getEnv().asBoxedGuestValue(thisStr);
        try {
            return InteropLibrary.getUncached().readMember(boxedString, name);
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            return Undefined.instance;
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getMethodHelper(JSDynamicObject store, Object thisObj, Object key, Node encapsulatingNode) {
        if (key instanceof TruffleString) {
            Object method;
            JSRealm realm;
            JSContext context;
            TruffleString name = (TruffleString)key;
            if (JSPrimitive.allowJavaMembersFor(thisObj) && (context = JSObject.getJSContext(store)).isOptionNashornCompatibilityMode() && (realm = JSRealm.get(null)).isJavaInteropEnabled() && this.hasOwnProperty(store, key) && (method = JSPrimitive.getJavaMethod(thisObj, Strings.toJavaString(name), realm)) != null) {
                return method;
            }
        }
        return super.getMethodHelper(store, thisObj, key, encapsulatingNode);
    }

    private static Object getJavaMethod(Object thisObj, String name, JSRealm realm) {
        String thisStr = Strings.toJavaString((TruffleString)thisObj);
        Object boxedString = realm.getEnv().asBoxedGuestValue(thisStr);
        try {
            return InteropLibrary.getUncached().readMember(boxedString, name);
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            return null;
        }
    }

    private static boolean allowJavaMembersFor(Object thisObj) {
        return thisObj instanceof TruffleString;
    }
}

