/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSModuleNamespace;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.AbstractModuleRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.CyclicModuleRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.ExportResolution;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.UnmodifiableEconomicMap;

public final class JSModuleNamespaceObject
extends JSNonProxyObject {
    private final AbstractModuleRecord module;
    private final UnmodifiableEconomicMap<TruffleString, ExportResolution> exports;
    private final boolean deferred;

    protected JSModuleNamespaceObject(Shape shape, AbstractModuleRecord module, UnmodifiableEconomicMap<TruffleString, ExportResolution> exports, boolean deferred) {
        super(shape, Null.instance);
        this.module = module;
        this.exports = exports;
        this.deferred = deferred;
    }

    public AbstractModuleRecord getModule() {
        return this.module;
    }

    private UnmodifiableEconomicMap<TruffleString, ExportResolution> getExports() {
        return this.exports;
    }

    @CompilerDirectives.TruffleBoundary
    public UnmodifiableEconomicMap<TruffleString, ExportResolution> getModuleExportsList() {
        if (this.deferred) {
            CyclicModuleRecord cyclicModule;
            AbstractModuleRecord abstractModuleRecord = this.module;
            if (abstractModuleRecord instanceof CyclicModuleRecord && (cyclicModule = (CyclicModuleRecord)abstractModuleRecord).getStatus() != CyclicModuleRecord.Status.Evaluated && !cyclicModule.isReadyForSyncExecution()) {
                throw Errors.createTypeError("Deferred module not ready for sync execution");
            }
            this.module.evaluateSync(JSRealm.get(null));
        }
        return this.getExports();
    }

    public static JSModuleNamespaceObject create(JSRealm realm, JSObjectFactory factory, AbstractModuleRecord module, UnmodifiableEconomicMap<TruffleString, ExportResolution> exports, boolean deferred) {
        return factory.initProto(new JSModuleNamespaceObject(factory.getShape(realm), module, exports, deferred), realm);
    }

    @Override
    public TruffleString getClassName() {
        return JSModuleNamespace.TO_STRING_TAG;
    }

    @Override
    public boolean setPrototypeOf(JSDynamicObject newPrototype) {
        return newPrototype == Null.instance;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean testIntegrityLevel(boolean frozen) {
        return this.testIntegrityLevel(frozen, false);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean setIntegrityLevel(boolean freeze, boolean doThrow) {
        return this.testIntegrityLevel(freeze, true);
    }

    private boolean testIntegrityLevel(boolean frozen, boolean doThrow) {
        CompilerAsserts.neverPartOfCompilation();
        for (ExportResolution binding : this.getModuleExportsList().getValues()) {
            JSModuleNamespace.getBindingValue(binding);
            if (!frozen) continue;
            if (doThrow) {
                throw Errors.createTypeError("not allowed to freeze a namespace object");
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSymbolLikeNamespaceKey(Object key) {
        if (!(key instanceof TruffleString)) return true;
        TruffleString name = (TruffleString)key;
        if (!this.deferred) return false;
        if (!Strings.equals(name, Strings.THEN)) return false;
        return true;
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        return Strings.addBrackets(this.deferred ? JSModuleNamespace.DEFERRED_TO_STRING_TAG : JSModuleNamespace.TO_STRING_TAG);
    }
}

