/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn;

import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.helper.ListGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.DynamicArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.AbstractConstantLazyArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public class LazyArray
extends AbstractConstantLazyArray {
    private static final LazyArray LAZY_ARRAY = (LazyArray)new LazyArray(0, LazyArray.createCache()).maybePreinitializeCache();

    protected LazyArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    public static LazyArray createLazyArray() {
        return LAZY_ARRAY;
    }

    @Override
    protected DynamicArray withIntegrityLevel(int newIntegrityLevel) {
        return new LazyArray(newIntegrityLevel, this.cache);
    }

    private static List<?> arrayGetLazyList(JSDynamicObject object) {
        return (List)JSAbstractArray.arrayGetArray(object);
    }

    @Override
    public Object getElementInBounds(JSDynamicObject object, int index) {
        return Boundaries.listGet(LazyArray.arrayGetLazyList(object), index);
    }

    public Object getElementInBounds(JSDynamicObject object, int index, ListGetNode listGetNode) {
        return listGetNode.execute(JSAbstractArray.arrayGetArray(object), index);
    }

    @Override
    public AbstractWritableArray createWriteableObject(JSDynamicObject object, long index, Object value, Node node, ScriptArray.CreateWritableProfileAccess profile) {
        int len = this.lengthInt(object);
        Object[] array = new Object[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.getElementInBounds(object, i);
        }
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, array.length, array.length, array, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            LazyArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public Object cloneArray(JSDynamicObject object) {
        return LazyArray.arrayGetLazyList(object);
    }
}

