/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception.AbstractTruffleException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.ExceptionType;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.GlobalBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.lang.JavaScriptLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.IsCallableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSAgent;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSFrameUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JavaScriptRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SerializedData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicSet;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Context;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.PolyglotException;

public final class WorkerAgent
extends JSAgent {
    private static final TruffleString DATA = Strings.constant("data");
    private static final SerializedData WAKE_UP_MESSAGE = new SerializedData(Undefined.instance);
    private final TruffleContext workerContext;
    private final BlockingQueue<SerializedData> outMessages = new LinkedBlockingQueue<SerializedData>();
    private final BlockingQueue<SerializedData> inMessages = new LinkedBlockingQueue<SerializedData>();
    private volatile boolean finished;

    @CompilerDirectives.TruffleBoundary
    public WorkerAgent() {
        super(true);
        TruffleContext truffleContext;
        JSRealm realm = JavaScriptLanguage.getCurrentJSRealm();
        TruffleLanguage.Env parentEnv = realm.getEnv();
        this.workerContext = truffleContext = parentEnv.newInnerContextBuilder(new String[0]).inheritAllAccess(true).build();
    }

    public String toString() {
        return "WorkerAgent{signifier=" + this.getSignifier() + "}";
    }

    @CompilerDirectives.TruffleBoundary
    public void start(final String code) {
        this.workerContext.initializePublic(null, "js");
        JSRealm rlm = JavaScriptLanguage.getCurrentJSRealm();
        rlm.getAgent().registerChildAgent(this);
        Thread thread = rlm.getEnv().newTruffleThreadBuilder(new Runnable(){
            final /* synthetic */ WorkerAgent this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    JSRealm realm = JavaScriptLanguage.getCurrentJSRealm();
                    realm.setAgent(this.this$0);
                    if (realm.getContextOptions().isTestV8Mode()) {
                        1.findAndEvalV8Mockup();
                    }
                    JSObjectUtil.putFunctionsFromContainer(realm, realm.getGlobalObject(), GlobalBuiltins.GLOBAL_WORKER);
                    Source workerSource = Source.newBuilder("js", code, "worker").build();
                    CallTarget callTarget = realm.getEnv().parsePublic(workerSource, new String[0]);
                    callTarget.call(new Object[0]);
                    this.this$0.processAllPromises(true);
                    Object messageHandler = JSObject.get(realm.getGlobalObject(), Strings.ONMESSAGE);
                    if (JSRuntime.isCallable(messageHandler)) {
                        JSContext context = realm.getContext();
                        JSFunctionData functionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.WorkerProcessMessage, c -> WorkerAgent.createProcessMessage(c));
                        JSFunctionObject processMessage = JSFunction.create(realm, functionData);
                        while (true) {
                            SerializedData message;
                            if ((message = this.this$0.inMessages.take()) != WAKE_UP_MESSAGE) {
                                Object deserialized = message.deserialize(realm);
                                JSObject arg = JSOrdinary.create(context, realm);
                                JSObject.set((JSDynamicObject)arg, DATA, deserialized);
                                JSFunction.call(processMessage, Undefined.instance, new Object[]{arg});
                            }
                            this.this$0.processAllPromises(true);
                        }
                    }
                }
                catch (InterruptedException realm) {
                }
                catch (AbstractTruffleException e) {
                    try {
                        ExceptionType type = InteropLibrary.getUncached(e).getExceptionType(e);
                        if (type != ExceptionType.INTERRUPT && type != ExceptionType.EXIT) {
                            System.err.println("Uncaught error from " + String.valueOf(Thread.currentThread()) + ": " + e.getMessage());
                        }
                    }
                    catch (UnsupportedMessageException unsupportedMessageException) {
                        // empty catch block
                    }
                }
                finally {
                    this.this$0.markFinished();
                }
            }

            private static void findAndEvalV8Mockup() throws InterruptedException {
                Context context = Context.getCurrent();
                for (org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Source source : context.getEngine().getCachedSources()) {
                    if (!source.getName().startsWith("v8mockup")) continue;
                    try {
                        context.eval(source);
                        break;
                    }
                    catch (PolyglotException ex) {
                        if (ex.isCancelled() || ex.isInterrupted()) {
                            throw new InterruptedException();
                        }
                        throw Errors.shouldNotReachHere(ex);
                    }
                }
            }
        }).context(this.workerContext).build();
        thread.setName("Worker-Thread-" + this.getSignifier());
        thread.start();
    }

    private static JSFunctionData createProcessMessage(JSContext context) {
        class ProcessMessageNode
        extends JavaScriptRootNode {
            @Node.Child
            PropertyGetNode getOnMessage;
            @Node.Child
            IsCallableNode isCallable;
            @Node.Child
            JSFunctionCallNode call;
            final /* synthetic */ JSContext val$context;

            ProcessMessageNode(JSContext jSContext) {
                this.val$context = jSContext;
                this.getOnMessage = PropertyGetNode.create(Strings.ONMESSAGE, this.val$context);
                this.isCallable = IsCallableNode.create();
                this.call = JSFunctionCallNode.createCall();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object onMessage = this.getOnMessage.getValue(this.getRealm().getGlobalObject());
                if (this.isCallable.executeBoolean(onMessage)) {
                    Object message = JSFrameUtil.getArgumentsArray(frame)[0];
                    this.call.executeCall(JSArguments.create(Undefined.instance, onMessage, message));
                }
                return Undefined.instance;
            }
        }
        return JSFunctionData.createCallOnly(context, new ProcessMessageNode(context).getCallTarget(), 1, Strings.EMPTY_STRING);
    }

    @Override
    public void wake() {
        this.inMessages.add(WAKE_UP_MESSAGE);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void terminate() {
        this.markFinished();
        this.workerContext.closeCancelled(null, "worker terminated");
    }

    private void markFinished() {
        this.finished = true;
        this.outMessages.add(new SerializedData(Undefined.instance));
    }

    @CompilerDirectives.TruffleBoundary
    public void postInMessage(Object message, EconomicSet<JSArrayBufferObject> transferSet) {
        this.inMessages.add(new SerializedData(message, transferSet));
    }

    @CompilerDirectives.TruffleBoundary
    public void postOutMessage(Object message) {
        this.outMessages.add(new SerializedData(message));
    }

    @CompilerDirectives.TruffleBoundary
    public Object getOutMessage(JSRealm realm) {
        Object message = Undefined.instance;
        if (!this.finished || !this.outMessages.isEmpty()) {
            try {
                message = this.outMessages.take().deserialize(realm);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return message;
    }
}

