/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime;

import java.util.Objects;
import java.util.OptionalInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Truffle;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.Frame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.MaterializedFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JSFrameSlot;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.InternalSlotId;

public final class JSFrameUtil {
    public static final MaterializedFrame NULL_MATERIALIZED_FRAME = Truffle.getRuntime().createMaterializedFrame(JSArguments.createNullArguments());
    public static final Object DEFAULT_VALUE = Undefined.instance;
    public static final TruffleString THIS_SLOT_ID = Strings.constant("<this>");
    private static final Class<? extends MaterializedFrame> MATERIALIZED_FRAME_CLASS = NULL_MATERIALIZED_FRAME.getClass();
    private static final int IS_LET = 1;
    private static final int IS_CONST = 2;
    private static final int HAS_TDZ = 3;
    private static final int IS_HOISTABLE_DECLARATION = 256;
    private static final int IS_IMPORT_BINDING = 16384;
    private static final int IS_PRIVATE_NAME = 131072;
    private static final int IS_PRIVATE_NAME_STATIC = 262144;
    private static final int IS_PRIVATE_METHOD_OR_ACCESSOR = 0x180000;
    private static final int IS_PARAM = 16;
    private static final int IS_ARGUMENTS = 0x200000;
    private static final int IS_CLOSED_OVER = 0x800000;
    public static final int IS_HOISTED_FROM_BLOCK = Integer.MIN_VALUE;
    public static final int SYMBOL_FLAG_MASK = -2135015149;

    private JSFrameUtil() {
    }

    public static Object getThisObj(Frame frame) {
        return JSArguments.getThisObject(frame.getArguments());
    }

    public static JSFunctionObject getFunctionObject(Frame frame) {
        return (JSFunctionObject.Unbound)JSArguments.getFunctionObject(frame.getArguments());
    }

    public static Object getFunctionObjectNoCast(Frame frame) {
        return JSArguments.getFunctionObject(frame.getArguments());
    }

    public static Object[] getArgumentsArray(Frame frame) {
        return JSArguments.extractUserArguments(frame.getArguments());
    }

    public static int getFlags(JSFrameSlot frameSlot) {
        return frameSlot.getFlags();
    }

    public static int getFlags(FrameDescriptor desc, int index) {
        return JSFrameUtil.getFlagsFromInfo(desc.getSlotInfo(index));
    }

    public static int getFlagsFromInfo(Object info) {
        return info instanceof Integer ? (Integer)info : 0;
    }

    public static boolean hasTemporalDeadZone(JSFrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 3) != 0;
    }

    public static boolean hasTemporalDeadZone(FrameDescriptor desc, int index) {
        return (JSFrameUtil.getFlags(desc, index) & 3) != 0;
    }

    public static boolean needsTemporalDeadZoneCheck(JSFrameSlot frameSlot, int frameLevel) {
        return JSFrameUtil.hasTemporalDeadZone(frameSlot) && frameLevel != 0;
    }

    public static boolean isConst(JSFrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 2) != 0;
    }

    public static boolean isLet(JSFrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 1) != 0;
    }

    public static boolean isConst(FrameDescriptor desc, int index) {
        return (JSFrameUtil.getFlags(desc, index) & 2) != 0;
    }

    public static boolean isLet(FrameDescriptor desc, int index) {
        return (JSFrameUtil.getFlags(desc, index) & 1) != 0;
    }

    public static boolean isHoistable(FrameDescriptor desc, int index) {
        return (JSFrameUtil.getFlags(desc, index) & 0x100) != 0;
    }

    public static boolean isImportBinding(JSFrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 0x4000) != 0;
    }

    public static boolean isImportBinding(FrameDescriptor desc, int index) {
        return (JSFrameUtil.getFlags(desc, index) & 0x4000) != 0;
    }

    public static boolean isPrivateName(JSFrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 0x20000) != 0;
    }

    public static boolean needsPrivateBrandCheck(JSFrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 0x180000) != 0;
    }

    public static boolean isPrivateNameStatic(JSFrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 0x40000) != 0;
    }

    public static boolean isParam(JSFrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 0x10) != 0;
    }

    public static boolean isArguments(JSFrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 0x200000) != 0;
    }

    public static boolean isClosedOver(JSFrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 0x800000) != 0;
    }

    public static boolean isHoistedFromBlock(FrameDescriptor desc, int index) {
        return (JSFrameUtil.getFlags(desc, index) & Integer.MIN_VALUE) != 0;
    }

    public static MaterializedFrame getParentFrame(Frame frame) {
        return JSArguments.getEnclosingFrame(frame.getArguments());
    }

    public static MaterializedFrame castMaterializedFrame(Object frame) {
        return CompilerDirectives.castExact(Objects.requireNonNull(frame), MATERIALIZED_FRAME_CLASS);
    }

    public static boolean isInternal(FrameDescriptor desc, int index) {
        return JSFrameUtil.isInternalIdentifier(desc.getSlotName(index));
    }

    public static boolean isInternalIdentifier(Object identifier) {
        CompilerAsserts.neverPartOfCompilation();
        if (identifier instanceof TruffleString) {
            TruffleString name = (TruffleString)identifier;
            if (Strings.startsWith(name, Strings.COLON)) {
                return true;
            }
            return Strings.startsWith(name, Strings.ANGLE_BRACKET_OPEN) && Strings.endsWith(name, Strings.ANGLE_BRACKET_CLOSE);
        }
        if (identifier instanceof InternalSlotId) {
            return true;
        }
        return true;
    }

    public static TruffleString getPublicName(Object identifier) {
        CompilerAsserts.neverPartOfCompilation();
        if (identifier instanceof TruffleString) {
            TruffleString name = (TruffleString)identifier;
            if (Strings.startsWith(name, Strings.COLON)) {
                return Strings.lazySubstring(name, 1);
            }
            if (Strings.startsWith(name, Strings.ANGLE_BRACKET_OPEN) && Strings.endsWith(name, Strings.ANGLE_BRACKET_CLOSE)) {
                return Strings.lazySubstring(name, 1, Strings.length(name) - 2);
            }
            return name;
        }
        return Strings.fromObject(identifier);
    }

    public static boolean isThisSlot(FrameDescriptor desc, int index) {
        return JSFrameUtil.isThisSlotIdentifier(desc.getSlotName(index));
    }

    public static boolean isThisSlotIdentifier(Object identifier) {
        return THIS_SLOT_ID.equals(identifier);
    }

    private static int findFrameSlotIndex(FrameDescriptor frameDescriptor, Object identifier) {
        CompilerAsserts.neverPartOfCompilation();
        for (int i = 0; i < frameDescriptor.getNumberOfSlots(); ++i) {
            if (!identifier.equals(frameDescriptor.getSlotName(i))) continue;
            return i;
        }
        return -1;
    }

    public static int findRequiredFrameSlotIndex(FrameDescriptor frameDescriptor, Object identifier) {
        int index = JSFrameUtil.findFrameSlotIndex(frameDescriptor, identifier);
        assert (index >= 0) : String.valueOf(identifier) + " not found in " + String.valueOf(frameDescriptor);
        return index;
    }

    public static OptionalInt findOptionalFrameSlotIndex(FrameDescriptor frameDescriptor, Object identifier) {
        int index = JSFrameUtil.findFrameSlotIndex(frameDescriptor, identifier);
        return index >= 0 ? OptionalInt.of(index) : OptionalInt.empty();
    }
}

