/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.wasm;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateUncached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToBigIntNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssembly;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.WebAssemblyValueType;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;

@ImportStatic(value={WebAssemblyValueType.class})
@GenerateUncached
public abstract class ToWebAssemblyValueNode
extends JavaScriptBaseNode {
    protected ToWebAssemblyValueNode() {
    }

    public abstract Object execute(Object var1, WebAssemblyValueType var2);

    @Specialization(guards={"type == i32"})
    static int i32(Object value, WebAssemblyValueType type, @Cached JSToInt32Node toInt32Node) {
        return toInt32Node.executeInt(value);
    }

    @Specialization(guards={"type == i64"})
    static long i64(Object value, WebAssemblyValueType type, @Cached JSToBigIntNode toBigIntNode) {
        return toBigIntNode.executeBigInteger(value).longValue();
    }

    @Specialization(guards={"type == f32"})
    static float f32(Object value, WebAssemblyValueType type, @Cached @Cached.Shared JSToNumberNode toNumberNode) {
        Number numberValue = toNumberNode.executeNumber(value);
        double doubleValue = JSRuntime.toDouble(numberValue);
        return (float)doubleValue;
    }

    @Specialization(guards={"type == f64"})
    static double f64(Object value, WebAssemblyValueType type, @Cached @Cached.Shared JSToNumberNode toNumberNode) {
        Number numberValue = toNumberNode.executeNumber(value);
        return JSRuntime.toDouble(numberValue);
    }

    @Specialization(guards={"type == anyfunc"})
    final Object anyfunc(Object value, WebAssemblyValueType type, @Cached InlinedBranchProfile errorBranch) {
        if (value == Null.instance) {
            return this.getRealm().getWasmRefNull();
        }
        if (JSWebAssembly.isExportedFunction(value)) {
            return JSWebAssembly.getExportedFunction((JSDynamicObject)value);
        }
        errorBranch.enter(this);
        throw ToWebAssemblyValueNode.notAnExportedFunctionError();
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException notAnExportedFunctionError() {
        throw Errors.createTypeError("value is not an exported function");
    }

    @Specialization(guards={"type == externref"})
    final Object externref(Object value, WebAssemblyValueType type) {
        if (value == Null.instance) {
            return this.getRealm().getWasmRefNull();
        }
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    @Fallback
    final Object fallback(Object value, WebAssemblyValueType type) {
        throw Errors.createTypeError("Unknown type: " + String.valueOf((Object)type), (Node)this);
    }
}

