/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ReportPolymorphism;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.OperatorsBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.OperatorSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

@ImportStatic(value={OperatorSet.class})
public abstract class JSOverloadedUnaryNode
extends JavaScriptBaseNode {
    static final int LIMIT = 3;
    private final TruffleString overloadedOperatorName;

    protected JSOverloadedUnaryNode(TruffleString overloadedOperatorName) {
        this.overloadedOperatorName = overloadedOperatorName;
    }

    public abstract Object execute(Object var1);

    @Specialization(guards={"operand.matchesOperatorCounter(operatorCounter)"}, limit="LIMIT")
    protected Object doCached(JSOverloadedOperatorsObject operand, @Cached(value="operand.getOperatorCounter()") int operatorCounter, @Cached(value="getOperatorImplementation(operand, getOverloadedOperatorName())") Object operatorImplementation, @Cached(value="createCall()") @Cached.Exclusive JSFunctionCallNode callNode) {
        OperatorsBuiltins.checkOverloadedOperatorsAllowed(operand, this);
        return this.performOverloaded(callNode, operatorImplementation, operand);
    }

    @Specialization(replaces={"doCached"})
    @ReportPolymorphism.Megamorphic
    protected Object doGeneric(JSOverloadedOperatorsObject operand, @Cached(value="createCall()") @Cached.Exclusive JSFunctionCallNode callNode) {
        OperatorsBuiltins.checkOverloadedOperatorsAllowed(operand, this);
        Object operatorImplementation = OperatorSet.getOperatorImplementation(operand, this.getOverloadedOperatorName());
        return this.performOverloaded(callNode, operatorImplementation, operand);
    }

    private Object performOverloaded(JSFunctionCallNode callNode, Object operatorImplementation, Object operand) {
        if (operatorImplementation == null) {
            throw Errors.createTypeErrorNoOverloadFoundUnary(this.getOverloadedOperatorName(), operand, this);
        }
        return callNode.executeCall(JSArguments.create(Undefined.instance, operatorImplementation, operand));
    }

    protected TruffleString getOverloadedOperatorName() {
        return this.overloadedOperatorName;
    }
}

