/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetOptionsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarIdentifierWithISODefaultNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalDateNode
extends JavaScriptBaseNode {
    protected ToTemporalDateNode() {
    }

    public final JSTemporalPlainDateObject execute(Object value) {
        return this.execute(value, Undefined.instance);
    }

    public abstract JSTemporalPlainDateObject execute(Object var1, Object var2);

    @Specialization
    public JSTemporalPlainDateObject toTemporalDate(Object itemParam, Object options, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile isPlainDateTimeProfile, @Cached InlinedConditionProfile isZonedDateTimeProfile, @Cached InlinedConditionProfile isPlainDateProfile, @Cached IsObjectNode isObjectNode, @Cached(value="create(getJSContext())") GetOptionsObjectNode getOptionsObject, @Cached TemporalGetOptionNode getOptionNode, @Cached GetTemporalCalendarIdentifierWithISODefaultNode getCalendarWithISODefault, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached TruffleString.ToJavaStringNode toJavaString, @Cached TruffleString.FromJavaStringNode fromJavaString) {
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        if (isObjectProfile.profile(this, isObjectNode.executeBoolean(itemParam))) {
            JSDynamicObject item = (JSDynamicObject)itemParam;
            if (isPlainDateProfile.profile(this, JSTemporalPlainDate.isJSTemporalPlainDate(item))) {
                Object resolvedOptions = getOptionsObject.execute(options);
                TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
                JSTemporalPlainDateObject pd = (JSTemporalPlainDateObject)item;
                return JSTemporalPlainDate.create(ctx, realm, pd.getYear(), pd.getMonth(), pd.getDay(), pd.getCalendar(), this, errorBranch);
            }
            if (isZonedDateTimeProfile.profile(this, JSTemporalZonedDateTime.isJSTemporalZonedDateTime(item))) {
                JSTemporalZonedDateTimeObject zdt = (JSTemporalZonedDateTimeObject)item;
                JSTemporalInstantObject instant = JSTemporalInstant.create(ctx, realm, zdt.getNanoseconds());
                JSTemporalPlainDateTimeObject plainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, zdt.getTimeZone(), instant, zdt.getCalendar());
                Object resolvedOptions = getOptionsObject.execute(options);
                TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
                return JSTemporalPlainDate.create(ctx, realm, plainDateTime.getYear(), plainDateTime.getMonth(), plainDateTime.getDay(), plainDateTime.getCalendar(), this, errorBranch);
            }
            if (isPlainDateTimeProfile.profile(this, JSTemporalPlainDateTime.isJSTemporalPlainDateTime(item))) {
                Object resolvedOptions = getOptionsObject.execute(options);
                TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
                JSTemporalPlainDateTimeObject dt = (JSTemporalPlainDateTimeObject)item;
                return JSTemporalPlainDate.create(ctx, realm, dt.getYear(), dt.getMonth(), dt.getDay(), dt.getCalendar(), this, errorBranch);
            }
            TruffleString calendar = getCalendarWithISODefault.execute(item);
            JSObject fields = TemporalUtil.prepareCalendarFields(ctx, calendar, item, TemporalUtil.listDMMCY, TemporalUtil.listEmpty, TemporalUtil.listEmpty);
            Object resolvedOptions = getOptionsObject.execute(options);
            TemporalUtil.Overflow overflow = TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
            return dateFromFieldsNode.execute(calendar, fields, overflow);
        }
        if (itemParam instanceof TruffleString) {
            TruffleString item = (TruffleString)itemParam;
            JSTemporalDateTimeRecord result = TemporalUtil.parseTemporalDateString(item);
            assert (TemporalUtil.isValidISODate(result.getYear(), result.getMonth(), result.getDay()));
            TruffleString calendar = result.getCalendar();
            if (calendar == null) {
                calendar = TemporalConstants.ISO8601;
            } else {
                String calendarJLS = toJavaString.execute(calendar);
                calendar = Strings.fromJavaString(fromJavaString, IntlUtil.canonicalizeCalendar(calendarJLS));
            }
            TemporalUtil.toTemporalOverflow(options, getOptionNode);
            return JSTemporalPlainDate.create(ctx, realm, result.getYear(), result.getMonth(), result.getDay(), calendar, this, errorBranch);
        }
        errorBranch.enter(this);
        throw Errors.createTypeErrorNotAString(itemParam);
    }
}

