/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.ir.Module;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception.AbstractTruffleException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.HiddenKey;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.lang.JavaScriptLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertySetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToStringNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.TryCatchNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise.PerformPromiseAllNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise.PerformPromiseThenNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSFrameUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JavaScriptRealmBoundaryRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JavaScriptRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayIterator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayIteratorObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSModuleNamespaceObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSPromise;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.AbstractModuleRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.IteratorRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.UnmodifiableArrayList;

public class ImportCallNode
extends JavaScriptNode {
    private static final HiddenKey PROMISE_CAPABILITY_KEY = new HiddenKey("%promiseCapability");
    private static final HiddenKey LINK_AND_EVALUATE_KEY = new HiddenKey("%linkAndEvaluate");
    private static final TruffleString ASSERT = Strings.constant("assert");
    private final Module.ImportPhase phase;
    @Node.Child
    private JavaScriptNode argRefNode;
    private final ScriptOrModule activeScriptOrModule;
    @Node.Child
    private NewPromiseCapabilityNode newPromiseCapabilityNode;
    @Node.Child
    private JSToStringNode toStringNode;
    @Node.Child
    private JavaScriptNode optionsRefNode;
    @Node.Child
    private JSFunctionCallNode callRejectNode;
    @Node.Child
    private TryCatchNode.GetErrorObjectNode getErrorObjectNode;
    @Node.Child
    private EnumerableOwnPropertyNamesNode enumerableOwnPropertyNamesNode;
    @Node.Child
    private PropertyGetNode getWithNode;
    @Node.Child
    private PropertyGetNode getAssertNode;
    private final JSContext context;

    protected ImportCallNode(JSContext context, Module.ImportPhase phase, JavaScriptNode argRefNode, JavaScriptNode optionsRefNode, ScriptOrModule activeScriptOrModule) {
        this.context = context;
        this.phase = phase;
        this.argRefNode = argRefNode;
        this.activeScriptOrModule = activeScriptOrModule;
        this.optionsRefNode = optionsRefNode;
        this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context);
        this.toStringNode = JSToStringNode.create();
    }

    @NeverDefault
    public static ImportCallNode create(JSContext context, Module.ImportPhase phase, JavaScriptNode specifierRefNode, JavaScriptNode optionsRefNode, ScriptOrModule activeScriptOrModule) {
        return new ImportCallNode(context, phase, specifierRefNode, optionsRefNode, activeScriptOrModule);
    }

    @NeverDefault
    public static ImportCallNode create(JSContext context) {
        return ImportCallNode.create(context, Module.ImportPhase.Evaluation, null, null, null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        TruffleString specifierString;
        ScriptOrModule referencingScriptOrModule = this.activeScriptOrModule;
        Object specifier = this.argRefNode.execute(frame);
        Object options = Undefined.instance;
        if (this.optionsRefNode != null) {
            options = this.optionsRefNode.execute(frame);
        }
        PromiseCapabilityRecord promiseCapability = this.newPromiseCapability();
        try {
            specifierString = this.toStringNode.executeString(specifier);
        }
        catch (AbstractTruffleException ex) {
            return this.rejectPromise(promiseCapability, ex);
        }
        Map.Entry<TruffleString, TruffleString>[] attributes = null;
        if (options != Undefined.instance) {
            try {
                if (!(options instanceof JSObject)) {
                    throw Errors.createTypeError("The second argument to import() must be an object", (Node)this);
                }
                JSObject optionsObj = (JSObject)options;
                attributes = this.getAttributes(optionsObj);
            }
            catch (AbstractTruffleException ex) {
                return this.rejectPromise(promiseCapability, ex);
            }
        }
        Module.ModuleRequest moduleRequest = attributes == null ? Module.ModuleRequest.create(specifierString, this.phase) : ImportCallNode.createModuleRequestWithAttributes(specifierString, attributes, this.phase);
        return this.hostImportModuleDynamicallyWithSite(referencingScriptOrModule, moduleRequest, promiseCapability);
    }

    private Map.Entry<TruffleString, TruffleString>[] getAttributes(JSObject options) {
        Object attributesObj = Undefined.instance;
        if (this.context.getLanguageOptions().importAttributes()) {
            if (this.getWithNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getWithNode = this.insert(PropertyGetNode.create(Strings.WITH, this.context));
            }
            attributesObj = this.getWithNode.getValue(options);
        }
        if (attributesObj == Undefined.instance && this.context.getLanguageOptions().importAssertions()) {
            if (this.getAssertNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getAssertNode = this.insert(PropertyGetNode.create(ASSERT, this.context));
            }
            attributesObj = this.getAssertNode.getValue(options);
        }
        Map.Entry[] attributes = null;
        if (attributesObj != Undefined.instance) {
            if (!(attributesObj instanceof JSObject)) {
                throw Errors.createTypeError(this.context.getLanguageOptions().importAssertions() ? "The 'assert' option must be an object" : "The 'with' option must be an object", (Node)this);
            }
            JSObject obj = (JSObject)attributesObj;
            if (this.enumerableOwnPropertyNamesNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.enumerableOwnPropertyNamesNode = this.insert(EnumerableOwnPropertyNamesNode.createKeys(this.context));
            }
            UnmodifiableArrayList<? extends Object> keys = this.enumerableOwnPropertyNamesNode.execute(obj);
            attributes = new Map.Entry[keys.size()];
            boolean allStrings = true;
            for (int i = 0; i < keys.size(); ++i) {
                TruffleString key = (TruffleString)keys.get(i);
                Object value = JSObject.get((JSDynamicObject)obj, key);
                if (value instanceof TruffleString) {
                    TruffleString valueStr = (TruffleString)value;
                    attributes[i] = Boundaries.mapEntry(key, valueStr);
                    continue;
                }
                allStrings = false;
            }
            if (!allStrings) {
                throw Errors.createTypeError(this.context.getLanguageOptions().importAssertions() ? "Import assertion value must be a string" : "Import attribute value must be a string", (Node)this);
            }
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSDynamicObject hostImportModuleDynamicallyWithSite(ScriptOrModule referrer, Module.ModuleRequest moduleRequest, PromiseCapabilityRecord promiseCapability) {
        EncapsulatingNodeReference current = EncapsulatingNodeReference.getCurrent();
        Node prev = current.set(this);
        try {
            JSDynamicObject jSDynamicObject = this.hostImportModuleDynamically(referrer, moduleRequest, promiseCapability);
            return jSDynamicObject;
        }
        finally {
            current.set(prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static Module.ModuleRequest createModuleRequestWithAttributes(TruffleString specifierString, Map.Entry<TruffleString, TruffleString>[] attributes, Module.ImportPhase phase) {
        return Module.ModuleRequest.create(specifierString, attributes, phase);
    }

    public final JSDynamicObject hostImportModuleDynamically(ScriptOrModule referencingScriptOrModule, Module.ModuleRequest moduleRequest, PromiseCapabilityRecord promiseCapability) {
        JSRealm realm = this.getRealm();
        if (this.context.hasImportModuleDynamicallyCallbackBeenSet()) {
            JSDynamicObject promise = this.context.hostImportModuleDynamically(realm, referencingScriptOrModule, moduleRequest);
            if (promise == null) {
                return this.rejectPromise(promiseCapability, ImportCallNode.createTypeErrorCannotImport(moduleRequest.specifier()));
            }
            assert (JSPromise.isJSPromise(promise));
            return promise;
        }
        ContinueDynamicImportPayload payload = new ContinueDynamicImportPayload(promiseCapability, this.phase, this.createContinueDynamicImportHandler(realm));
        this.context.getEvaluator().hostLoadImportedModule(realm, referencingScriptOrModule, moduleRequest, Undefined.instance, payload);
        return promiseCapability.getPromise();
    }

    private PromiseCapabilityRecord newPromiseCapability() {
        if (this.newPromiseCapabilityNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.newPromiseCapabilityNode = this.insert(NewPromiseCapabilityNode.create(this.context));
        }
        return this.newPromiseCapabilityNode.executeDefault();
    }

    private JSDynamicObject rejectPromise(PromiseCapabilityRecord promiseCapability, AbstractTruffleException ex) {
        if (this.callRejectNode == null || this.getErrorObjectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callRejectNode = this.insert(JSFunctionCallNode.createCall());
            this.getErrorObjectNode = this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
        }
        Object error = this.getErrorObjectNode.execute(ex);
        this.callRejectNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getReject(), error));
        return promiseCapability.getPromise();
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException createTypeErrorCannotImport(TruffleString specifier) {
        return Errors.createError("Cannot dynamically import module: " + String.valueOf(specifier));
    }

    private JSFunctionObject createContinueDynamicImportHandler(JSRealm realm) {
        JSFunctionData functionData = this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ContinueDynamicImport, c -> ImportCallNode.createContinueDynamicImportHandlerImpl(c));
        return JSFunction.create(realm, functionData);
    }

    private static JSFunctionData createContinueDynamicImportHandlerImpl(JSContext context) {
        class ContinueDynamicImportRootNode
        extends JavaScriptRealmBoundaryRootNode {
            @Node.Child
            protected JavaScriptNode payloadArgument;
            @Node.Child
            protected JavaScriptNode moduleRecordArgument;
            @Node.Child
            private PerformPromiseThenNode promiseThenNode;
            @Node.Child
            private PropertySetNode setPromiseCapability;
            @Node.Child
            private PropertySetNode setLinkAndEvaluateCaptures;
            final /* synthetic */ JSContext val$context;

            protected ContinueDynamicImportRootNode(JavaScriptLanguage javaScriptLanguage) {
                this.val$context = javaScriptLanguage;
                super(lang);
                this.payloadArgument = AccessIndexedArgumentNode.create(0);
                this.moduleRecordArgument = AccessIndexedArgumentNode.create(1);
                this.promiseThenNode = PerformPromiseThenNode.create(this.val$context);
                this.setPromiseCapability = PropertySetNode.createSetHidden(PROMISE_CAPABILITY_KEY, this.val$context);
                this.setLinkAndEvaluateCaptures = PropertySetNode.createSetHidden(LINK_AND_EVALUATE_KEY, this.val$context);
            }

            @Override
            public Object executeInRealm(VirtualFrame frame) {
                ContinueDynamicImportPayload payload = (ContinueDynamicImportPayload)this.payloadArgument.execute(frame);
                AbstractModuleRecord module = (AbstractModuleRecord)this.moduleRecordArgument.execute(frame);
                JSRealm realm = this.getRealm();
                JSPromiseObject loadPromise = module.loadRequestedModules(realm, Undefined.instance);
                JSFunctionObject onRejected = this.createOnRejectedClosure(this.val$context, realm, payload.promiseCapability());
                JSFunctionObject linkAndEvaluate = this.createLinkAndEvaluateClosure(this.val$context, realm, module, payload, onRejected);
                this.promiseThenNode.execute(loadPromise, linkAndEvaluate, onRejected);
                return Undefined.instance;
            }

            private JSFunctionObject createOnRejectedClosure(JSContext cx, JSRealm realm, PromiseCapabilityRecord promiseCapability) {
                JSFunctionData functionData = cx.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ContinueDynamicImportRejectedClosure, c -> ImportCallNode.createOnRejectedImpl(c));
                JSFunctionObject rejectedClosure = JSFunction.create(realm, functionData);
                this.setPromiseCapability.setValue(rejectedClosure, promiseCapability);
                return rejectedClosure;
            }

            private JSFunctionObject createLinkAndEvaluateClosure(JSContext cx, JSRealm realm, AbstractModuleRecord module, ContinueDynamicImportPayload payload, JSFunctionObject onRejected) {
                JSFunctionData functionData = cx.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ContinueDynamicImportLinkAndEvaluateClosure, c -> ImportCallNode.createLinkAndEvaluateImpl(c));
                JSFunctionObject linkAndEvaluateClosure = JSFunction.create(realm, functionData);
                this.setLinkAndEvaluateCaptures.setValue(linkAndEvaluateClosure, new LinkAndEvaluateArgs(module, payload.promiseCapability(), payload.phase(), onRejected));
                return linkAndEvaluateClosure;
            }
        }
        ContinueDynamicImportRootNode root = new ContinueDynamicImportRootNode(context.getLanguage(), context);
        return JSFunctionData.createCallOnly(context, root.getCallTarget(), 0, Strings.EMPTY_STRING);
    }

    private static JSFunctionData createLinkAndEvaluateImpl(JSContext context) {
        class LinkAndEvaluateRootNode
        extends JavaScriptRealmBoundaryRootNode {
            @Node.Child
            private PropertyGetNode getCaptures;
            @Node.Child
            private PropertySetNode setCaptures;
            @Node.Child
            private PerformPromiseThenNode promiseThenNode;
            @Node.Child
            private JSFunctionCallNode callPromiseReject;
            @Node.Child
            private TryCatchNode.GetErrorObjectNode getErrorObjectNode;
            @Node.Child
            private JSFunctionCallNode callOnFulfilled;
            @Node.Child
            private NewPromiseCapabilityNode newPromiseCapabilityNode;
            @Node.Child
            private PerformPromiseAllNode performPromiseAllNode;
            @Node.Child
            private PropertyGetNode getNext;
            final /* synthetic */ JSContext val$context;

            protected LinkAndEvaluateRootNode(JavaScriptLanguage javaScriptLanguage) {
                this.val$context = javaScriptLanguage;
                super(lang);
                this.getCaptures = PropertyGetNode.createGetHidden(LINK_AND_EVALUATE_KEY, this.val$context);
                this.setCaptures = PropertySetNode.createSetHidden(LINK_AND_EVALUATE_KEY, this.val$context);
                this.promiseThenNode = PerformPromiseThenNode.create(this.val$context);
            }

            @Override
            protected Object executeInRealm(VirtualFrame frame) {
                JSFunctionObject thisFunction = JSFrameUtil.getFunctionObject(frame);
                LinkAndEvaluateArgs captures = (LinkAndEvaluateArgs)this.getCaptures.getValue(thisFunction);
                AbstractModuleRecord moduleRecord = captures.moduleRecord;
                PromiseCapabilityRecord importPromiseCapability = captures.promiseCapability;
                JSFunctionObject onRejected = captures.onRejected;
                JSRealm realm = this.getRealm();
                assert (realm == JSFunction.getRealm(thisFunction));
                try {
                    JSPromiseObject evaluatePromise;
                    moduleRecord.link(realm);
                    JSFunctionObject onFulfilled = this.createFulfilledClosure(this.val$context, realm, captures);
                    if (captures.phase() == Module.ImportPhase.Defer) {
                        List<AbstractModuleRecord> evaluationList;
                        if (this.callOnFulfilled == null) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.callOnFulfilled = this.insert(JSFunctionCallNode.createCall());
                        }
                        if (Boundaries.listSize(evaluationList = moduleRecord.gatherAsynchronousTransitiveDependencies()) == 0) {
                            return this.callOnFulfilled.executeCall(JSArguments.createZeroArg(Undefined.instance, onFulfilled));
                        }
                        evaluatePromise = this.evaluateDeferred(realm, evaluationList);
                    } else {
                        assert (captures.phase() == Module.ImportPhase.Evaluation);
                        evaluatePromise = moduleRecord.evaluate(realm);
                    }
                    this.promiseThenNode.execute(evaluatePromise, onFulfilled, onRejected);
                }
                catch (AbstractTruffleException ex) {
                    this.rejectPromise(importPromiseCapability, ex);
                }
                return Undefined.instance;
            }

            private JSFunctionObject createFulfilledClosure(JSContext cx, JSRealm realm, LinkAndEvaluateArgs captures) {
                JSFunctionData functionData = cx.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ContinueDynamicImportFulfilledClosure, c -> ImportCallNode.createOnFulfilledImpl(c));
                JSFunctionObject closure = JSFunction.create(realm, functionData);
                this.setCaptures.setValue(closure, captures);
                return closure;
            }

            private JSPromiseObject evaluateDeferred(JSRealm realm, List<AbstractModuleRecord> evaluationList) {
                if (this.newPromiseCapabilityNode == null || this.performPromiseAllNode == null || this.getNext == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.newPromiseCapabilityNode = this.insert(NewPromiseCapabilityNode.create(this.val$context));
                    this.performPromiseAllNode = this.insert(PerformPromiseAllNode.create(this.val$context));
                    this.getNext = this.insert(PropertyGetNode.create(Strings.NEXT, this.val$context));
                }
                Object[] asyncDepsEvaluationPromises = new JSPromiseObject[Boundaries.listSize(evaluationList)];
                for (int i = 0; i < asyncDepsEvaluationPromises.length; ++i) {
                    asyncDepsEvaluationPromises[i] = Boundaries.listGet(evaluationList, i).evaluate(realm);
                }
                JSArrayObject arrayObj = JSArray.createConstant(this.val$context, realm, asyncDepsEvaluationPromises);
                JSArrayIteratorObject iteratorObj = JSArrayIterator.create(this.val$context, realm, arrayObj, 0L, 2);
                IteratorRecord iterator = IteratorRecord.create(iteratorObj, this.getNext.getValue(iteratorObj), false);
                PromiseCapabilityRecord pc = this.newPromiseCapabilityNode.executeDefault();
                return (JSPromiseObject)this.performPromiseAllNode.execute(iterator, realm.getPromiseConstructor(), pc, realm.getPromiseResolveFunctionObject());
            }

            private void rejectPromise(PromiseCapabilityRecord moduleLoadedCapability, AbstractTruffleException ex) {
                if (this.getErrorObjectNode == null || this.callPromiseReject == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.getErrorObjectNode = this.insert(TryCatchNode.GetErrorObjectNode.create(this.val$context));
                    this.callPromiseReject = this.insert(JSFunctionCallNode.createCall());
                }
                Object errorObject = this.getErrorObjectNode.execute(ex);
                this.callPromiseReject.executeCall(JSArguments.createOneArg(Undefined.instance, moduleLoadedCapability.getReject(), errorObject));
            }
        }
        return JSFunctionData.createCallOnly(context, new LinkAndEvaluateRootNode(context.getLanguage(), context).getCallTarget(), 0, Strings.EMPTY_STRING);
    }

    private static JSFunctionData createOnFulfilledImpl(JSContext cx) {
        class FinishDynamicImportNormalRootNode
        extends JavaScriptRootNode {
            @Node.Child
            private PropertyGetNode getCaptures;
            @Node.Child
            private JSFunctionCallNode callPromiseResolve;
            final /* synthetic */ JSContext val$cx;

            FinishDynamicImportNormalRootNode(JSContext jSContext) {
                this.val$cx = jSContext;
                this.getCaptures = PropertyGetNode.createGetHidden(LINK_AND_EVALUATE_KEY, this.val$cx);
                this.callPromiseResolve = JSFunctionCallNode.createCall();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                JSFunctionObject thisFunction = JSFrameUtil.getFunctionObject(frame);
                LinkAndEvaluateArgs captures = (LinkAndEvaluateArgs)this.getCaptures.getValue(thisFunction);
                PromiseCapabilityRecord promiseCapability = captures.promiseCapability;
                AbstractModuleRecord moduleRecord = captures.moduleRecord;
                JSModuleNamespaceObject namespace = moduleRecord.getModuleNamespace(captures.phase());
                this.callPromiseResolve.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getResolve(), namespace));
                return Undefined.instance;
            }
        }
        return JSFunctionData.createCallOnly(cx, new FinishDynamicImportNormalRootNode(cx).getCallTarget(), 0, Strings.EMPTY_STRING);
    }

    private static JSFunctionData createOnRejectedImpl(JSContext cx) {
        class RejectDynamicImportRootNode
        extends JavaScriptRootNode {
            @Node.Child
            protected JavaScriptNode reasonArgument = AccessIndexedArgumentNode.create(0);
            @Node.Child
            private PropertyGetNode getPromiseCapability = PropertyGetNode.createGetHidden(PROMISE_CAPABILITY_KEY, this.val$cx);
            @Node.Child
            private JSFunctionCallNode callPromiseReject = JSFunctionCallNode.createCall();
            final /* synthetic */ JSContext val$cx;

            RejectDynamicImportRootNode(JSContext jSContext) {
                this.val$cx = jSContext;
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object reason = this.reasonArgument.execute(frame);
                JSFunctionObject thisFunction = (JSFunctionObject)JSArguments.getFunctionObject(frame.getArguments());
                PromiseCapabilityRecord promiseCapability = (PromiseCapabilityRecord)this.getPromiseCapability.getValue(thisFunction);
                this.callPromiseReject.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getReject(), reason));
                return Undefined.instance;
            }
        }
        return JSFunctionData.createCallOnly(cx, new RejectDynamicImportRootNode(cx).getCallTarget(), 1, Strings.EMPTY_STRING);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return ImportCallNode.create(this.context, this.phase, ImportCallNode.cloneUninitialized(this.argRefNode, materializedTags), ImportCallNode.cloneUninitialized(this.optionsRefNode, materializedTags), this.activeScriptOrModule);
    }

    public record ContinueDynamicImportPayload(PromiseCapabilityRecord promiseCapability, Module.ImportPhase phase, JSFunctionObject continueDynamicImportCallback) {
    }

    private record LinkAndEvaluateArgs(AbstractModuleRecord moduleRecord, PromiseCapabilityRecord promiseCapability, Module.ImportPhase phase, JSFunctionObject onRejected) {
    }
}

