/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl;

import java.util.List;
import java.util.MissingResourceException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToStringNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.CoerceOptionsToObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.CoerceOptionsToObjectNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetBooleanOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetNumberOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetStringOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.InitializeDateTimeFormatNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSDateTimeFormat;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSDateTimeFormatObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.Pair;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.TimeZone;

public abstract class InitializeDateTimeFormatNode
extends JavaScriptBaseNode {
    public static final List<String> FORMAT_MATCHER_OPTION_VALUES = List.of("basic", "best fit");
    public static final List<String> TWO_DIGIT_NUMERIC_OPTION_VALUES = List.of("2-digit", "numeric");
    public static final List<String> DAY_OPTION_VALUES = List.of("2-digit", "numeric", "narrow", "short", "long");
    public static final List<String> DATE_TIME_STYLE_OPTION_VALUES = List.of("full", "long", "medium", "short");
    public static final List<String> TIME_ZONE_NAME_OPTION_VALUES = List.of("short", "long");
    public static final List<String> TIME_ZONE_NAME_OPTION_VALUES_ES2022 = List.of("short", "long", "shortOffset", "longOffset", "shortGeneric", "longGeneric");
    private final Required required;
    private final Defaults defaults;
    @Node.Child
    JSToCanonicalizedLocaleListNode toCanonicalizedLocaleListNode;
    @Node.Child
    CoerceOptionsToObjectNode coerceOptionsToObjectNode;
    @Node.Child
    PropertyGetNode getTimeZoneNode;
    @Node.Child
    GetStringOptionNode getLocaleMatcherOption;
    @Node.Child
    GetStringOptionNode getFormatMatcherOption;
    @Node.Child
    GetStringOptionNode getHourCycleOption;
    @Node.Child
    GetStringOptionNode getCalendarOption;
    @Node.Child
    GetStringOptionNode getNumberingSystemOption;
    @Node.Child
    GetBooleanOptionNode getHour12Option;
    @Node.Child
    GetStringOptionNode getWeekdayOption;
    @Node.Child
    GetStringOptionNode getEraOption;
    @Node.Child
    GetStringOptionNode getYearOption;
    @Node.Child
    GetStringOptionNode getMonthOption;
    @Node.Child
    GetStringOptionNode getDayOption;
    @Node.Child
    GetStringOptionNode getDayPeriodOption;
    @Node.Child
    GetStringOptionNode getHourOption;
    @Node.Child
    GetStringOptionNode getMinuteOption;
    @Node.Child
    GetStringOptionNode getSecondOption;
    @Node.Child
    GetNumberOptionNode getFractionalSecondDigitsOption;
    @Node.Child
    GetStringOptionNode getTimeZoneNameOption;
    @Node.Child
    GetStringOptionNode getDateStyleOption;
    @Node.Child
    GetStringOptionNode getTimeStyleOption;
    @Node.Child
    JSToStringNode toStringNode;
    @Node.Child
    TruffleString.ToJavaStringNode toJavaStringNode;
    private final BranchProfile errorBranch = BranchProfile.create();
    private final JSContext context;

    protected InitializeDateTimeFormatNode(JSContext context, Required required, Defaults defaults) {
        this.context = context;
        this.required = required;
        this.defaults = defaults;
        this.toCanonicalizedLocaleListNode = JSToCanonicalizedLocaleListNode.create(context);
        this.coerceOptionsToObjectNode = CoerceOptionsToObjectNodeGen.create(context);
        this.getTimeZoneNode = PropertyGetNode.create(IntlUtil.KEY_TIME_ZONE, context);
        this.getLocaleMatcherOption = GetStringOptionNode.create(context, IntlUtil.KEY_LOCALE_MATCHER, GetStringOptionNode.LOCALE_MATCHER_OPTION_VALUES, "best fit");
        this.getFormatMatcherOption = GetStringOptionNode.create(context, IntlUtil.KEY_FORMAT_MATCHER, FORMAT_MATCHER_OPTION_VALUES, "best fit");
        this.getHourCycleOption = GetStringOptionNode.create(context, IntlUtil.KEY_HOUR_CYCLE, GetStringOptionNode.HOUR_CYCLE_OPTION_VALUES, null);
        this.getCalendarOption = GetStringOptionNode.create(context, IntlUtil.KEY_CALENDAR, null, null);
        this.getNumberingSystemOption = GetStringOptionNode.create(context, IntlUtil.KEY_NUMBERING_SYSTEM, null, null);
        this.getHour12Option = GetBooleanOptionNode.create(context, IntlUtil.KEY_HOUR12, null);
        this.getWeekdayOption = GetStringOptionNode.create(context, IntlUtil.KEY_WEEKDAY, GetStringOptionNode.NARROW_SHORT_LONG_OPTION_VALUES, null);
        this.getEraOption = GetStringOptionNode.create(context, IntlUtil.KEY_ERA, GetStringOptionNode.NARROW_SHORT_LONG_OPTION_VALUES, null);
        this.getYearOption = GetStringOptionNode.create(context, IntlUtil.KEY_YEAR, TWO_DIGIT_NUMERIC_OPTION_VALUES, null);
        this.getMonthOption = GetStringOptionNode.create(context, IntlUtil.KEY_MONTH, DAY_OPTION_VALUES, null);
        this.getDayOption = GetStringOptionNode.create(context, IntlUtil.KEY_DAY, TWO_DIGIT_NUMERIC_OPTION_VALUES, null);
        this.getDayPeriodOption = GetStringOptionNode.create(context, IntlUtil.KEY_DAY_PERIOD, GetStringOptionNode.NARROW_SHORT_LONG_OPTION_VALUES, null);
        this.getHourOption = GetStringOptionNode.create(context, IntlUtil.KEY_HOUR, TWO_DIGIT_NUMERIC_OPTION_VALUES, null);
        this.getMinuteOption = GetStringOptionNode.create(context, IntlUtil.KEY_MINUTE, TWO_DIGIT_NUMERIC_OPTION_VALUES, null);
        this.getSecondOption = GetStringOptionNode.create(context, IntlUtil.KEY_SECOND, TWO_DIGIT_NUMERIC_OPTION_VALUES, null);
        this.getFractionalSecondDigitsOption = GetNumberOptionNode.create(context, IntlUtil.KEY_FRACTIONAL_SECOND_DIGITS);
        this.getTimeZoneNameOption = GetStringOptionNode.create(context, IntlUtil.KEY_TIME_ZONE_NAME, InitializeDateTimeFormatNode.timeZoneNameOptions(context), null);
        this.getDateStyleOption = GetStringOptionNode.create(context, IntlUtil.KEY_DATE_STYLE, DATE_TIME_STYLE_OPTION_VALUES, null);
        this.getTimeStyleOption = GetStringOptionNode.create(context, IntlUtil.KEY_TIME_STYLE, DATE_TIME_STYLE_OPTION_VALUES, null);
        this.toStringNode = JSToStringNode.create();
        this.toJavaStringNode = TruffleString.ToJavaStringNode.create();
    }

    public abstract JSDateTimeFormatObject executeInit(JSDateTimeFormatObject var1, Object var2, Object var3);

    public static InitializeDateTimeFormatNode createInitalizeDateTimeFormatNode(JSContext context, Required required, Defaults defaults) {
        return InitializeDateTimeFormatNodeGen.create(context, required, defaults);
    }

    @Specialization
    public JSDateTimeFormatObject initializeDateTimeFormat(JSDateTimeFormatObject dateTimeFormatObj, Object localesArg, Object optionsArg) {
        try {
            String numberingSystemOpt;
            JSDateTimeFormat.InternalState state = dateTimeFormatObj.getInternalState();
            String[] locales = this.toCanonicalizedLocaleListNode.executeLanguageTags(localesArg);
            Object options = this.coerceOptionsToObjectNode.execute(optionsArg);
            this.getLocaleMatcherOption.executeValue(options);
            String calendarOpt = this.getCalendarOption.executeValue(options);
            if (calendarOpt != null) {
                IntlUtil.validateUnicodeLocaleIdentifierType(calendarOpt, this.errorBranch);
                calendarOpt = IntlUtil.normalizeUnicodeLocaleIdentifierType(calendarOpt);
            }
            if ((numberingSystemOpt = this.getNumberingSystemOption.executeValue(options)) != null) {
                IntlUtil.validateUnicodeLocaleIdentifierType(numberingSystemOpt, this.errorBranch);
                numberingSystemOpt = IntlUtil.normalizeUnicodeLocaleIdentifierType(numberingSystemOpt);
            }
            Boolean hour12Opt = this.getHour12Option.executeValue(options);
            String hcOpt = this.getHourCycleOption.executeValue(options);
            Object timeZoneValue = this.getTimeZoneNode.getValue(options);
            Pair<TimeZone, String> timeZone = this.toTimeZone(timeZoneValue);
            String weekdayOpt = this.getWeekdayOption.executeValue(options);
            String eraOpt = this.getEraOption.executeValue(options);
            String yearOpt = this.getYearOption.executeValue(options);
            String monthOpt = this.getMonthOption.executeValue(options);
            String dayOpt = this.getDayOption.executeValue(options);
            String dayPeriodOpt = this.getDayPeriodOption.executeValue(options);
            String hourOpt = this.getHourOption.executeValue(options);
            String minuteOpt = this.getMinuteOption.executeValue(options);
            String secondOpt = this.getSecondOption.executeValue(options);
            int fractionalSecondDigitsOpt = this.getFractionalSecondDigitsOption.executeInt(options, 1, 3, 0);
            String tzNameOpt = this.getTimeZoneNameOption.executeValue(options);
            boolean hasExplicitFormatComponents = weekdayOpt != null || eraOpt != null || yearOpt != null || monthOpt != null || dayOpt != null || dayPeriodOpt != null || hourOpt != null || minuteOpt != null || secondOpt != null || fractionalSecondDigitsOpt != 0 || tzNameOpt != null;
            this.getFormatMatcherOption.executeValue(options);
            String dateStyleOpt = this.getDateStyleOption.executeValue(options);
            String timeStyleOpt = this.getTimeStyleOption.executeValue(options);
            if (dateStyleOpt != null || timeStyleOpt != null) {
                if (hasExplicitFormatComponents || this.required == Required.DATE && timeStyleOpt != null || this.required == Required.TIME && dateStyleOpt != null) {
                    this.errorBranch.enter();
                    throw Errors.createTypeError("dateStyle and timeStyle options cannot be mixed with other date/time options");
                }
            } else {
                boolean needDefaults = true;
                if (!(this.required != Required.DATE && this.required != Required.ANY || weekdayOpt == null && yearOpt == null && monthOpt == null && dayOpt == null)) {
                    needDefaults = false;
                }
                if (!(this.required != Required.TIME && this.required != Required.ANY || dayPeriodOpt == null && hourOpt == null && minuteOpt == null && secondOpt == null && fractionalSecondDigitsOpt == 0)) {
                    needDefaults = false;
                }
                if (needDefaults && (this.defaults == Defaults.DATE || this.defaults == Defaults.ALL)) {
                    yearOpt = "numeric";
                    monthOpt = "numeric";
                    dayOpt = "numeric";
                }
                if (needDefaults && (this.defaults == Defaults.TIME || this.defaults == Defaults.ALL)) {
                    hourOpt = "numeric";
                    minuteOpt = "numeric";
                    secondOpt = "numeric";
                }
            }
            JSDateTimeFormat.setupInternalDateTimeFormat(this.context, state, locales, weekdayOpt, eraOpt, yearOpt, monthOpt, dayOpt, dayPeriodOpt, hourOpt, hcOpt, hour12Opt, minuteOpt, secondOpt, fractionalSecondDigitsOpt, tzNameOpt, timeZone.getFirst(), timeZone.getSecond(), calendarOpt, numberingSystemOpt, dateStyleOpt, timeStyleOpt);
        }
        catch (MissingResourceException e) {
            this.errorBranch.enter();
            throw Errors.createICU4JDataError(e);
        }
        return dateTimeFormatObj;
    }

    private Pair<TimeZone, String> toTimeZone(Object timeZoneValue) {
        if (timeZoneValue != Undefined.instance) {
            TruffleString nameTS = this.toStringNode.executeString(timeZoneValue);
            String name = this.toJavaStringNode.execute(nameTS);
            return this.parseAndGetICUTimeZone(name);
        }
        TimeZone timeZone = this.getRealm().getLocalTimeZone();
        String tzId = timeZone.getID();
        return new Pair<TimeZone, String>(timeZone, tzId);
    }

    @CompilerDirectives.TruffleBoundary
    private Pair<TimeZone, String> parseAndGetICUTimeZone(String name) {
        TimeZone timeZone;
        String tzId = InitializeDateTimeFormatNode.maybeParseAndFormatTimeZoneOffset(name);
        if (tzId == null) {
            Pair<String, String> pair = JSDateTimeFormat.getAvailableNamedTimeZoneIdentifier(name);
            if (pair == null) {
                throw Errors.createRangeErrorInvalidTimeZone(name);
            }
            tzId = pair.getFirst();
            timeZone = IntlUtil.getICUTimeZone(pair.getSecond(), this.context);
        } else {
            timeZone = IntlUtil.getICUTimeZoneForOffset(tzId);
        }
        return new Pair<TimeZone, String>(timeZone, tzId);
    }

    private static String maybeParseAndFormatTimeZoneOffset(String name) {
        int minutes;
        boolean reformatNeeded = false;
        int length = name.length();
        if (length < 3) {
            return null;
        }
        int sign = name.charAt(0);
        if (sign != 43 && sign != 45) {
            return null;
        }
        int hourTens = name.charAt(1) - 48;
        int hourOnes = name.charAt(2) - 48;
        int hours = 10 * hourTens + hourOnes;
        if (hourOnes < 0 || 9 < hourOnes || hours < 0 || 23 < hours) {
            return null;
        }
        if (length > 3) {
            int pos = 3;
            if (name.charAt(pos) == ':') {
                ++pos;
            } else {
                reformatNeeded = true;
            }
            if (length != pos + 2) {
                return null;
            }
            int minuteTens = name.charAt(pos) - 48;
            int minuteOnes = name.charAt(pos + 1) - 48;
            minutes = 10 * minuteTens + minuteOnes;
            if (minuteOnes < 0 || 9 < minuteOnes || minutes < 0 || 59 < minutes) {
                return null;
            }
        } else {
            reformatNeeded = true;
            minutes = 0;
        }
        if (sign == 45 && hours == 0 && minutes == 0) {
            reformatNeeded = true;
            sign = 43;
        }
        if (reformatNeeded) {
            return InitializeDateTimeFormatNode.formatOffsetTimeZoneIdentifier((char)sign, hours, minutes);
        }
        return name;
    }

    @CompilerDirectives.TruffleBoundary
    private static String formatOffsetTimeZoneIdentifier(char sign, int hours, int minutes) {
        return sign + InitializeDateTimeFormatNode.formatUsing2Digits(hours) + ":" + InitializeDateTimeFormatNode.formatUsing2Digits(minutes);
    }

    @CompilerDirectives.TruffleBoundary
    private static String formatUsing2Digits(int value) {
        String valueStr = Integer.toString(value);
        return valueStr.length() == 1 ? "0" + valueStr : valueStr;
    }

    private static List<String> timeZoneNameOptions(JSContext context) {
        if (context.getEcmaScriptVersion() >= 13) {
            return TIME_ZONE_NAME_OPTION_VALUES_ES2022;
        }
        return TIME_ZONE_NAME_OPTION_VALUES;
    }

    public static enum Required {
        DATE,
        TIME,
        ANY;

    }

    public static enum Defaults {
        DATE,
        TIME,
        ALL;

    }
}

