/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl;

import java.util.List;
import java.util.MissingResourceException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.CoerceOptionsToObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.CoerceOptionsToObjectNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetBooleanOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetStringOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.InitializeCollatorNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSCollator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSCollatorObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;

public abstract class InitializeCollatorNode
extends JavaScriptBaseNode {
    private static final List<String> USAGE_OPTION_VALUES = List.of("sort", "search");
    private static final List<String> SENSITIVITY_OPTION_VALUES = List.of("base", "accent", "case", "variant");
    private final JSContext context;
    @Node.Child
    JSToCanonicalizedLocaleListNode toCanonicalizedLocaleListNode;
    @Node.Child
    CoerceOptionsToObjectNode coerceOptionsToObjectNode;
    @Node.Child
    GetStringOptionNode getUsageOption;
    @Node.Child
    GetStringOptionNode getLocaleMatcherOption;
    @Node.Child
    GetStringOptionNode getCollationOption;
    @Node.Child
    GetBooleanOptionNode getNumericOption;
    @Node.Child
    GetStringOptionNode getCaseFirstOption;
    @Node.Child
    GetStringOptionNode getSensitivityOption;
    @Node.Child
    GetBooleanOptionNode getIgnorePunctuationOption;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected InitializeCollatorNode(JSContext context) {
        this.context = context;
        this.toCanonicalizedLocaleListNode = JSToCanonicalizedLocaleListNode.create(context);
        this.coerceOptionsToObjectNode = CoerceOptionsToObjectNodeGen.create(context);
        this.getUsageOption = GetStringOptionNode.create(context, IntlUtil.KEY_USAGE, USAGE_OPTION_VALUES, "sort");
        this.getLocaleMatcherOption = GetStringOptionNode.create(context, IntlUtil.KEY_LOCALE_MATCHER, GetStringOptionNode.LOCALE_MATCHER_OPTION_VALUES, "best fit");
        this.getCollationOption = GetStringOptionNode.create(context, IntlUtil.KEY_COLLATION, null, null);
        this.getNumericOption = GetBooleanOptionNode.create(context, IntlUtil.KEY_NUMERIC, null);
        this.getCaseFirstOption = GetStringOptionNode.create(context, IntlUtil.KEY_CASE_FIRST, GetStringOptionNode.CASE_FIRST_OPTION_VALUES, null);
        this.getSensitivityOption = GetStringOptionNode.create(context, IntlUtil.KEY_SENSITIVITY, SENSITIVITY_OPTION_VALUES, null);
        this.getIgnorePunctuationOption = GetBooleanOptionNode.create(context, IntlUtil.KEY_IGNORE_PUNCTUATION, null);
    }

    public abstract JSCollatorObject executeInit(JSCollatorObject var1, Object var2, Object var3);

    public static InitializeCollatorNode createInitalizeCollatorNode(JSContext context) {
        return InitializeCollatorNodeGen.create(context);
    }

    @Specialization
    public JSCollatorObject initializeCollator(JSCollatorObject collatorObj, Object localesArg, Object optionsArg) {
        try {
            JSCollator.InternalState state = collatorObj.getInternalState();
            String[] locales = this.toCanonicalizedLocaleListNode.executeLanguageTags(localesArg);
            Object options = this.coerceOptionsToObjectNode.execute(optionsArg);
            String usage = this.getUsageOption.executeValue(options);
            String optLocaleMatcher = this.getLocaleMatcherOption.executeValue(options);
            String optco = this.getCollationOption.executeValue(options);
            if (optco != null) {
                IntlUtil.validateUnicodeLocaleIdentifierType(optco, this.errorBranch);
            }
            Boolean optkn = this.getNumericOption.executeValue(options);
            String optkf = this.getCaseFirstOption.executeValue(options);
            String sensitivity = this.getSensitivityOption.executeValue(options);
            Boolean ignorePunctuation = this.getIgnorePunctuationOption.executeValue(options);
            JSCollator.initializeCollator(this.context, state, locales, usage, optLocaleMatcher, optco, optkn, optkf, sensitivity, ignorePunctuation);
        }
        catch (MissingResourceException e) {
            this.errorBranch.enter();
            throw Errors.createICU4JDataError(e);
        }
        return collatorObj;
    }
}

