/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.RootCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.DirectCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.ConstructorRootNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.SpecializedNewObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JavaScriptRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class ConstructorRootNode
extends JavaScriptRootNode {
    protected final JSFunctionData functionData;
    protected final CallTarget callTarget;
    protected final boolean newTarget;
    protected final JSOrdinary instanceLayout;

    protected ConstructorRootNode(JSFunctionData functionData, CallTarget callTarget, boolean newTarget, JSOrdinary instanceLayout) {
        super(functionData.getContext().getLanguage(), ((RootCallTarget)callTarget).getRootNode().getSourceSection(), null);
        this.functionData = functionData;
        this.callTarget = callTarget;
        this.newTarget = newTarget;
        this.instanceLayout = instanceLayout;
    }

    public static ConstructorRootNode create(JSFunctionData functionData, CallTarget callTarget, boolean newTarget, JSOrdinary instanceLayout) {
        return ConstructorRootNodeGen.create(functionData, callTarget, newTarget, instanceLayout);
    }

    public static ConstructorRootNode create(JSFunctionData functionData, CallTarget callTarget, boolean newTarget) {
        return ConstructorRootNode.create(functionData, callTarget, newTarget, JSOrdinary.INSTANCE);
    }

    private Object allocateThisObject(VirtualFrame frame, Object[] arguments, SpecializedNewObjectNode newObjectNode) {
        JSDynamicObject thisObject;
        if (!this.getFunctionData().isDerived()) {
            Object functionObject = this.newTarget ? arguments[2] : arguments[1];
            thisObject = newObjectNode.execute(frame, (JSDynamicObject)functionObject);
        } else {
            thisObject = JSFunction.CONSTRUCT;
        }
        arguments[0] = thisObject;
        return thisObject;
    }

    private Object filterConstructorResult(Object thisObject, Object result, IsObjectNode isObjectNode, InlinedConditionProfile isObject) {
        if (isObject.profile(this, isObjectNode.executeBoolean(result))) {
            return result;
        }
        if (this.getFunctionData().isDerived()) {
            if (result != Undefined.instance) {
                throw Errors.createTypeErrorDerivedConstructorReturnedIllegalType(this);
            }
            throw Errors.createReferenceErrorDerivedConstructorThisNotInitialized(this);
        }
        assert (thisObject != JSFunction.CONSTRUCT);
        return thisObject;
    }

    @Specialization
    protected final Object construct(VirtualFrame frame, @Cached(value="create(callTarget)") DirectCallNode callNode, @Cached(value="create(functionData, instanceLayout)") SpecializedNewObjectNode newObjectNode, @Cached IsObjectNode isObjectNode, @Cached InlinedConditionProfile isObjectProfile) {
        Object[] arguments = frame.getArguments();
        Object thisObject = this.allocateThisObject(frame, arguments, newObjectNode);
        Object result = callNode.call(arguments);
        return this.filterConstructorResult(thisObject, result, isObjectNode, isObjectProfile);
    }

    private JSFunctionData getFunctionData() {
        return this.functionData;
    }

    @Override
    public boolean isCloningAllowed() {
        return true;
    }

    @Override
    protected boolean isCloneUninitializedSupported() {
        return true;
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    protected JavaScriptRootNode cloneUninitialized() {
        return ConstructorRootNodeGen.create(this.functionData, this.callTarget, this.newTarget, this.instanceLayout);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toString() {
        String callTargetName = ((RootCallTarget)this.callTarget).getRootNode().toString();
        return JSConfig.DetailedCallTargetNames ? "[Construct]".concat(callTargetName) : callTargetName;
    }
}

