/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.UnexpectedResultException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JSGuards;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.ToArrayIndexNoToPropertyKeyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.ToArrayIndexNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

@ImportStatic(value={JSConfig.class, JSRuntime.class})
public abstract class ToArrayIndexNode
extends JavaScriptBaseNode {
    protected final boolean convertStringToIndex;

    public abstract Object execute(Object var1);

    public abstract long executeLong(Object var1) throws UnexpectedResultException;

    protected ToArrayIndexNode(boolean convertStringToIndex) {
        this.convertStringToIndex = convertStringToIndex;
    }

    @NeverDefault
    public static ToArrayIndexNode create() {
        return ToArrayIndexNodeGen.create(true);
    }

    @NeverDefault
    public static ToArrayIndexNode createNoStringToIndex() {
        return ToArrayIndexNodeGen.create(false);
    }

    @Specialization(guards={"isIntArrayIndex(value)"})
    protected static long doInteger(int value) {
        return value;
    }

    @Specialization(guards={"isLongArrayIndex(value)"})
    protected static long doLong(long value) {
        return JSRuntime.castArrayIndex(value);
    }

    protected static boolean doubleIsIntIndex(double d) {
        return JSRuntime.doubleIsRepresentableAsInt(d) && d >= 0.0;
    }

    @Specialization(guards={"doubleIsIntIndex(value)"})
    protected static long doDoubleAsIntIndex(double value) {
        return (long)value;
    }

    protected static boolean doubleIsUintIndex(double d) {
        return JSRuntime.doubleIsRepresentableAsUnsignedInt(d, true) && d >= 0.0 && d < 4.294967295E9;
    }

    @Specialization(guards={"doubleIsUintIndex(value)"}, replaces={"doDoubleAsIntIndex"})
    protected static long doDoubleAsUintIndex(double value) {
        return JSRuntime.castArrayIndex(value);
    }

    @Specialization
    protected static Symbol doSymbol(Symbol value) {
        return value;
    }

    @Specialization(guards={"isBigIntArrayIndex(value)"})
    protected static long doBigInt(BigInt value) {
        return value.longValue();
    }

    @Specialization(guards={"convertStringToIndex", "arrayIndexLengthInRange(index)"})
    protected final Object convertFromString(TruffleString index, @Cached InlinedConditionProfile startsWithDigitBranch, @Cached InlinedBranchProfile isArrayIndexBranch, @Cached TruffleString.ReadCharUTF16Node stringReadNode) {
        long longValue;
        if (startsWithDigitBranch.profile(this, JSRuntime.isAsciiDigit(Strings.charAt(stringReadNode, index, 0))) && JSRuntime.isArrayIndex(longValue = JSRuntime.parseArrayIndexRaw(index, stringReadNode))) {
            isArrayIndexBranch.enter(this);
            return JSRuntime.castArrayIndex(longValue);
        }
        return index;
    }

    @Specialization(guards={"!convertStringToIndex || !arrayIndexLengthInRange(index)"})
    protected static TruffleString convertFromStringNotInRange(TruffleString index) {
        return index;
    }

    protected static boolean notArrayIndex(Object o) {
        return !(o instanceof Integer && JSGuards.isIntArrayIndex((Integer)o) || o instanceof Double && ToArrayIndexNode.doubleIsUintIndex((Double)o) || o instanceof Long && JSGuards.isLongArrayIndex((Long)o) || o instanceof BigInt && JSGuards.isBigIntArrayIndex((BigInt)o) || o instanceof TruffleString || o instanceof Symbol);
    }

    @Specialization(guards={"notArrayIndex(value)", "index >= 0"}, limit="InteropLibraryLimit")
    protected static long doInteropArrayIndex(Object value, @CachedLibrary(value="value") InteropLibrary interop, @Bind(value="toArrayIndex(value, interop)") long index) {
        return index;
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"notArrayIndex(value)", "toArrayIndex(value, interop) < 0"}, limit="InteropLibraryLimit")
    protected final Object doNonArrayIndex(Object value, @Bind Node node, @CachedLibrary(value="value") InteropLibrary interop, @Cached JSToPropertyKeyNode toPropertyKey, @Cached ToArrayIndexNoToPropertyKeyNode propertyKeyToArrayIndex) {
        long arrayIndex;
        Object propertyKey = toPropertyKey.execute(value);
        if (this.convertStringToIndex && JSRuntime.isArrayIndex(arrayIndex = propertyKeyToArrayIndex.executeLong(node, propertyKey))) {
            return arrayIndex;
        }
        return propertyKey;
    }

    static long toArrayIndex(Object value, InteropLibrary interop) {
        if (!(value instanceof JSDynamicObject) && interop.fitsInLong(value)) {
            try {
                long index = interop.asLong(value);
                if (JSRuntime.isArrayIndex(index)) {
                    return JSRuntime.castArrayIndex(index);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
        }
        return -1L;
    }
}

