/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateUncached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToDoubleNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;

@GenerateUncached
public abstract class JSToDoubleNode
extends JavaScriptBaseNode {
    public final double execute(Object value) {
        return this.executeDouble(value);
    }

    public abstract double executeDouble(Object var1);

    @NeverDefault
    public static JSToDoubleNode create() {
        return JSToDoubleNodeGen.create();
    }

    @Specialization
    protected static double doInteger(int value) {
        return value;
    }

    @Specialization
    protected static double doBoolean(boolean value) {
        return JSRuntime.booleanToNumber(value);
    }

    @Specialization
    protected static double doDouble(double value) {
        return value;
    }

    @Specialization
    protected static double doLong(long value) {
        return value;
    }

    @Specialization
    protected final double doBigInt(BigInt value) {
        throw Errors.createTypeErrorCannotConvertBigIntToNumber(this);
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static double doNull(Object value) {
        return 0.0;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static double doUndefined(Object value) {
        return Double.NaN;
    }

    @Specialization
    protected static double doStringDouble(TruffleString value, @Cached JSStringToNumberNode stringToNumberNode) {
        return stringToNumberNode.execute(value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected double doJSObject(JSObject value, @Cached.Shared @Cached JSToDoubleNode recursiveToDouble, @Cached.Shared @Cached JSToPrimitiveNode toPrimitiveNode) {
        return recursiveToDouble.executeDouble(toPrimitiveNode.executeHintNumber(value));
    }

    @Specialization
    protected final double doSymbol(Symbol value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a Symbol value", this);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isJSObject(object) || isForeignObjectOrNumber(object)"}, replaces={"doJSObject"})
    protected double doForeignObject(Object object, @Cached.Shared @Cached JSToDoubleNode recursiveToDouble, @Cached.Shared @Cached JSToPrimitiveNode toPrimitiveNode) {
        return recursiveToDouble.executeDouble(toPrimitiveNode.executeHintNumber(object));
    }
}

