/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSMultiplyNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;

@NodeInfo(shortName="*")
public abstract class JSMultiplyNode
extends JSBinaryNode {
    protected JSMultiplyNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        if (left instanceof JSConstantNode.JSConstantIntegerNode && right instanceof JSConstantNode.JSConstantIntegerNode) {
            int rightValue;
            int leftValue = ((JSConstantNode.JSConstantIntegerNode)left).executeInt(null);
            long result = (long)leftValue * (long)(rightValue = ((JSConstantNode.JSConstantIntegerNode)right).executeInt(null));
            if (result == 0L && (leftValue < 0 || rightValue < 0)) {
                return JSConstantNode.createDouble(-0.0);
            }
            if (JSRuntime.longIsRepresentableAsInt(result)) {
                return JSConstantNode.createInt((int)result);
            }
            return JSConstantNode.createDouble(result);
        }
        return JSMultiplyNodeGen.create(left, right);
    }

    public static JSMultiplyNode create() {
        return (JSMultiplyNode)JSMultiplyNode.create(null, null);
    }

    public abstract Object execute(Object var1, Object var2);

    @Specialization(guards={"b > 0"}, rewriteOn={ArithmeticException.class})
    protected int doIntBLargerZero(int a, int b) {
        return Math.multiplyExact(a, b);
    }

    @Specialization(guards={"a > 0"}, rewriteOn={ArithmeticException.class})
    protected int doIntALargerZero(int a, int b) {
        return Math.multiplyExact(a, b);
    }

    @Specialization(rewriteOn={ArithmeticException.class})
    protected int doInt(int a, int b, @Cached @Cached.Exclusive InlinedBranchProfile resultZeroBranch) {
        int result = Math.multiplyExact(a, b);
        if (result == 0) {
            resultZeroBranch.enter(this);
            if (a < 0 || b < 0) {
                throw new ArithmeticException("could be -0");
            }
        }
        return result;
    }

    @Specialization
    protected double doDouble(double a, double b) {
        return a * b;
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected BigInt doBigInts(BigInt a, BigInt b) {
        try {
            return a.multiply(b);
        }
        catch (ArithmeticException ae) {
            throw Errors.createRangeErrorBigIntMaxSizeExceeded();
        }
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected Object doOverloaded(Object a, Object b, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a, b);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.SYMBOL_STAR;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "!hasOverloadedOperators(b)"}, replaces={"doDouble"})
    protected static Object doGeneric(Object a, Object b, @Bind Node node, @Cached JSMultiplyNode nestedMultiplyNode, @Cached JSToNumericNode toNumeric1Node, @Cached JSToNumericNode toNumeric2Node, @Cached @Cached.Exclusive InlinedBranchProfile mixedNumericTypes) {
        Object operandA = toNumeric1Node.execute(a);
        Object operandB = toNumeric2Node.execute(b);
        JSMultiplyNode.ensureBothSameNumericType(operandA, operandB, node, mixedNumericTypes);
        return nestedMultiplyNode.execute(operandA, operandB);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSMultiplyNodeGen.create(JSMultiplyNode.cloneUninitialized(this.getLeft(), materializedTags), JSMultiplyNode.cloneUninitialized(this.getRight(), materializedTags));
    }
}

