/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary;

import java.util.Objects;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.InstrumentableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JSGuards;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.Truncatable;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSAddConstantRightNumberNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSAddNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSConcatStringsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.JSTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SafeInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;

@NodeInfo(shortName="+")
public abstract class JSAddConstantRightNumberNode
extends JSUnaryNode
implements Truncatable {
    @CompilerDirectives.CompilationFinal
    boolean truncate;
    private final double rightDouble;
    private final int rightInt;
    protected final boolean isInt;

    protected JSAddConstantRightNumberNode(JavaScriptNode left, Number rightValue, boolean truncate) {
        super(left);
        this.truncate = truncate;
        this.rightDouble = rightValue.doubleValue();
        if (rightValue instanceof Integer || JSRuntime.doubleIsRepresentableAsInt(this.rightDouble)) {
            this.isInt = true;
            this.rightInt = rightValue.intValue();
        } else {
            this.isInt = false;
            this.rightInt = 0;
        }
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.BinaryOperationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("operator", this.getClass().getAnnotation(NodeInfo.class).shortName());
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.BinaryOperationTag.class)) {
            JSConstantNode constantNode = this.isInt ? JSConstantNode.createInt(this.rightInt) : JSConstantNode.createDouble(this.rightDouble);
            JavaScriptNode node = JSAddNode.createUnoptimized(JSAddConstantRightNumberNode.cloneUninitialized(this.getOperand(), materializedTags), constantNode, this.truncate);
            JSAddConstantRightNumberNode.transferSourceSectionAddExpressionTag(this, constantNode);
            JSAddConstantRightNumberNode.transferSourceSectionAndTags(this, node);
            return node;
        }
        return this;
    }

    public Number getRightValue() {
        return this.isInt ? (double)this.rightInt : this.rightDouble;
    }

    @Specialization(guards={"truncate", "isInt"})
    protected int doIntTruncate(int left) {
        return left + this.rightInt;
    }

    @Specialization(guards={"!truncate", "isInt"}, rewriteOn={ArithmeticException.class})
    protected int doInt(int left) {
        return Math.addExact(left, this.rightInt);
    }

    @Specialization(guards={"!truncate", "isInt"}, rewriteOn={ArithmeticException.class})
    protected Object doIntOverflow(int left) {
        long result = (long)left + (long)this.rightInt;
        return JSAddNode.doIntOverflowStaticLong(result);
    }

    @Specialization(guards={"isInt"}, rewriteOn={ArithmeticException.class})
    protected SafeInteger doSafeInteger(SafeInteger left) {
        return left.addExact(SafeInteger.valueOf(this.rightInt));
    }

    @Specialization
    protected double doDouble(double left) {
        return left + this.rightDouble;
    }

    @Specialization
    protected TruffleString doStringNumber(TruffleString a, @Cached(value="rightValueToString()") @Cached.Shared TruffleString rightString, @Cached @Cached.Shared JSConcatStringsNode createLazyString) {
        return createLazyString.executeTString(a, rightString);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected Object doOverloaded(JSOverloadedOperatorsObject a, @Cached(value="createHintDefault(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a, this.getRightValue());
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.SYMBOL_PLUS;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)"}, replaces={"doInt", "doDouble", "doStringNumber"})
    protected Object doPrimitiveConversion(Object a, @Bind Node node, @Cached JSToPrimitiveNode toPrimitiveA, @Cached JSToNumberNode toNumberA, @Cached(value="rightValueToString()") @Cached.Shared TruffleString rightString, @Cached @Cached.Shared JSConcatStringsNode createLazyString, @Cached InlinedConditionProfile profileA) {
        Object primitiveA = toPrimitiveA.executeHintDefault(a);
        if (profileA.profile(node, JSGuards.isString(primitiveA))) {
            return createLazyString.executeTString((TruffleString)primitiveA, rightString);
        }
        return JSRuntime.doubleValue(toNumberA.executeNumber(primitiveA)) + this.rightDouble;
    }

    @NeverDefault
    protected TruffleString rightValueToString() {
        return JSRuntime.toString(this.getRightValue());
    }

    @Override
    public void setTruncate() {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.truncate) {
            this.truncate = true;
            if (this.isInt) {
                Truncatable.truncate(this.getOperand());
            }
        }
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSAddConstantRightNumberNodeGen.create(JSAddConstantRightNumberNode.cloneUninitialized(this.getOperand(), materializedTags), this.getRightValue(), this.truncate);
    }

    @Override
    public String expressionToString() {
        if (this.getOperand() != null) {
            return "(" + Objects.toString(this.getOperand().expressionToString(), "(intermediate value)") + " + " + String.valueOf(JSRuntime.numberToString(this.getRightValue())) + ")";
        }
        return null;
    }
}

