/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary;

import java.util.Objects;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.InstrumentableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JSGuards;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.Truncatable;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSAddConstantLeftNumberNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSAddNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSConcatStringsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.JSTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SafeInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;

@NodeInfo(shortName="+")
public abstract class JSAddConstantLeftNumberNode
extends JSUnaryNode
implements Truncatable {
    @CompilerDirectives.CompilationFinal
    boolean truncate;
    private final double leftDouble;
    private final int leftInt;
    protected final boolean isInt;
    protected final boolean isSafeLong;

    protected JSAddConstantLeftNumberNode(Number leftValue, JavaScriptNode right, boolean truncate) {
        super(right);
        this.truncate = truncate;
        this.leftDouble = leftValue.doubleValue();
        this.leftInt = (int)leftValue.longValue();
        this.isSafeLong = JSRuntime.doubleIsRepresentableAsLong(this.leftDouble) && JSRuntime.isSafeInteger(this.leftDouble);
        this.isInt = leftValue instanceof Integer || JSRuntime.doubleIsRepresentableAsInt(this.leftDouble);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.BinaryOperationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.BinaryOperationTag.class)) {
            JSConstantNode constantNode = this.isInt ? JSConstantNode.createInt(this.leftInt) : JSConstantNode.createDouble(this.leftDouble);
            JavaScriptNode node = JSAddNode.createUnoptimized(constantNode, JSAddConstantLeftNumberNode.cloneUninitialized(this.getOperand(), materializedTags), this.truncate);
            JSAddConstantLeftNumberNode.transferSourceSectionAddExpressionTag(this, constantNode);
            JSAddConstantLeftNumberNode.transferSourceSectionAndTags(this, node);
            return node;
        }
        return this;
    }

    public Number getLeftValue() {
        return this.isInt ? (double)this.leftInt : this.leftDouble;
    }

    @Specialization(guards={"truncate", "isInt"})
    protected int doIntTruncate(int right) {
        return this.leftInt + right;
    }

    @Specialization(guards={"!truncate", "isInt"}, rewriteOn={ArithmeticException.class})
    protected int doInt(int right) {
        return Math.addExact(this.leftInt, right);
    }

    @Specialization(guards={"!truncate", "isSafeLong"}, rewriteOn={ArithmeticException.class})
    protected Object doIntOverflow(int right) {
        long result = (long)this.leftDouble + (long)right;
        return JSAddNode.doIntOverflowStaticLong(result);
    }

    @Specialization(guards={"isInt"}, rewriteOn={ArithmeticException.class})
    protected SafeInteger doSafeInteger(SafeInteger right) {
        return SafeInteger.valueOf(this.leftInt).addExact(right);
    }

    @Specialization
    protected double doDouble(double right) {
        return this.leftDouble + right;
    }

    @Specialization
    protected Object doNumberString(TruffleString right, @Cached(value="leftValueToString()") @Cached.Shared TruffleString leftString, @Cached @Cached.Shared JSConcatStringsNode createLazyString) {
        return createLazyString.executeTString(leftString, right);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected Object doOverloaded(JSOverloadedOperatorsObject right, @Cached(value="createHintDefault(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(this.getLeftValue(), right);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.SYMBOL_PLUS;
    }

    @Specialization(guards={"!hasOverloadedOperators(right)"}, replaces={"doInt", "doDouble", "doNumberString"})
    protected Object doPrimitiveConversion(Object right, @Bind Node node, @Cached JSToPrimitiveNode toPrimitiveB, @Cached JSToNumberNode toNumberB, @Cached(value="leftValueToString()") @Cached.Shared TruffleString leftString, @Cached @Cached.Shared JSConcatStringsNode createLazyString, @Cached InlinedConditionProfile profileB) {
        Object primitiveRight = toPrimitiveB.executeHintDefault(right);
        if (profileB.profile(node, JSGuards.isString(primitiveRight))) {
            return createLazyString.executeTString(leftString, (TruffleString)primitiveRight);
        }
        return this.leftDouble + JSRuntime.doubleValue(toNumberB.executeNumber(primitiveRight));
    }

    @NeverDefault
    protected TruffleString leftValueToString() {
        return JSRuntime.toString(this.getLeftValue());
    }

    @Override
    public void setTruncate() {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.truncate) {
            this.truncate = true;
            if (this.isInt) {
                Truncatable.truncate(this.getOperand());
            }
        }
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSAddConstantLeftNumberNodeGen.create(this.getLeftValue(), JSAddConstantLeftNumberNode.cloneUninitialized(this.getOperand(), materializedTags), this.truncate);
    }

    @Override
    public String expressionToString() {
        if (this.getOperand() != null) {
            return "(" + String.valueOf(JSRuntime.numberToString(this.getLeftValue())) + " + " + Objects.toString(this.getOperand().expressionToString(), "(intermediate value)") + ")";
        }
        return null;
    }
}

