/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array;

import java.util.Comparator;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.LoopNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SafeInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.TypedArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;

@ImportStatic(value={JSConfig.class})
public abstract class JSTypedArraySortNode
extends JavaScriptBaseNode {
    static final int CACHE_LIMIT = 6;

    protected JSTypedArraySortNode() {
    }

    public abstract void execute(JSTypedArrayObject var1, JSTypedArrayObject var2, int var3, Comparator<Object> var4);

    @Specialization(guards={"cachedFromType.isInstance(fromType)", "cachedToType.isInstance(toType)", "cachedComparatorIsNull == comparatorIsNull"}, limit="CACHE_LIMIT")
    protected final void doCached(JSTypedArrayObject fromArray, JSTypedArrayObject toArray, int length, Comparator<Object> comparator, @Bind(value="fromArray.getArrayType()") TypedArray fromType, @Bind(value="toArray.getArrayType()") TypedArray toType, @Bind(value="comparator == null") boolean comparatorIsNull, @Cached(value="fromType") TypedArray cachedFromType, @Cached(value="toType") TypedArray cachedToType, @Cached(value="comparatorIsNull") boolean cachedComparatorIsNull, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary interop) {
        this.doUncached(fromArray, toArray, length, comparator, cachedFromType, cachedToType, cachedComparatorIsNull, interop);
    }

    @Specialization(replaces={"doCached"})
    protected final void doUncached(JSTypedArrayObject fromArray, JSTypedArrayObject toArray, int length, Comparator<Object> comparator, @Bind(value="fromArray.getArrayType()") TypedArray fromType, @Bind(value="toArray.getArrayType()") TypedArray toType, @Bind(value="comparator == null") boolean comparatorIsNull, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary interop) {
        Comparator<Object> useComparator;
        assert (fromType.getElementType() == toType.getElementType() && fromArray.getArrayType() == fromType && toArray.getArrayType() == toType);
        assert (fromArray.getLength() == length && toArray.getLength() == length);
        Comparator<Object> comparator2 = useComparator = comparatorIsNull ? null : Objects.requireNonNull(comparator);
        if (fromType instanceof TypedArray.TypedIntArray) {
            this.sortIntArray(fromArray, toArray, length, useComparator, (TypedArray.TypedIntArray)fromType, (TypedArray.TypedIntArray)toType, interop);
        } else if (fromType instanceof TypedArray.TypedFloatArray) {
            this.sortFloatArray(fromArray, toArray, length, useComparator, (TypedArray.TypedFloatArray)fromType, (TypedArray.TypedFloatArray)toType, interop);
        } else if (fromType instanceof TypedArray.TypedBigIntArray) {
            this.sortBigInt64Array(fromArray, toArray, length, useComparator, (TypedArray.TypedBigIntArray)fromType, (TypedArray.TypedBigIntArray)toType, interop);
        } else {
            throw Errors.shouldNotReachHereUnexpectedValue(fromType);
        }
        LoopNode.reportLoopCount(this, length);
    }

    private void sortIntArray(JSTypedArrayObject fromArray, JSTypedArrayObject toArray, int length, Comparator<Object> comparator, TypedArray.TypedIntArray fromType, TypedArray.TypedIntArray toType, InteropLibrary interop) {
        if (comparator == null) {
            if (fromType instanceof TypedArray.AbstractUint32Array) {
                int i;
                long[] arr = new long[length];
                for (i = 0; i < length; ++i) {
                    arr[i] = Integer.toUnsignedLong(fromType.getInt(fromArray, i, interop));
                }
                Boundaries.arraySort(arr);
                for (i = 0; i < length; ++i) {
                    toType.setInt(toArray, i, (int)arr[i], interop);
                }
            } else {
                int i;
                int[] arr = new int[length];
                for (i = 0; i < length; ++i) {
                    arr[i] = fromType.getInt(fromArray, i, interop);
                }
                Boundaries.arraySort(arr);
                for (i = 0; i < length; ++i) {
                    toType.setInt(toArray, i, arr[i], interop);
                }
            }
        } else {
            int i;
            boolean zeroExtend = fromType instanceof TypedArray.AbstractUint32Array;
            Object[] arr = new Object[length];
            for (i = 0; i < length; ++i) {
                int intValue = fromType.getInt(fromArray, i, interop);
                arr[i] = zeroExtend ? SafeInteger.valueOf(Integer.toUnsignedLong(intValue)) : Integer.valueOf(intValue);
            }
            Boundaries.arraySort(arr, comparator);
            if (this.isTypedArrayOutOfBounds(toArray)) {
                return;
            }
            for (i = 0; i < length; ++i) {
                Object value = arr[i];
                int intValue = zeroExtend ? ((SafeInteger)value).intValue() : ((Integer)value).intValue();
                toType.setInt(toArray, i, intValue, interop);
            }
        }
    }

    private void sortFloatArray(JSTypedArrayObject fromArray, JSTypedArrayObject toArray, int length, Comparator<Object> comparator, TypedArray.TypedFloatArray fromType, TypedArray.TypedFloatArray toType, InteropLibrary interop) {
        if (comparator == null) {
            int i;
            double[] arr = new double[length];
            for (i = 0; i < length; ++i) {
                arr[i] = fromType.getDouble(fromArray, i, interop);
            }
            Boundaries.arraySort(arr);
            for (i = 0; i < length; ++i) {
                toType.setDouble(toArray, i, arr[i], interop);
            }
        } else {
            int i;
            Double[] arr = new Double[length];
            for (i = 0; i < length; ++i) {
                arr[i] = fromType.getDouble(fromArray, i, interop);
            }
            Boundaries.arraySort(arr, comparator);
            if (this.isTypedArrayOutOfBounds(toArray)) {
                return;
            }
            for (i = 0; i < length; ++i) {
                toType.setDouble(toArray, i, arr[i], interop);
            }
        }
    }

    private void sortBigInt64Array(JSTypedArrayObject fromArray, JSTypedArrayObject toArray, int length, Comparator<Object> comparator, TypedArray.TypedBigIntArray fromType, TypedArray.TypedBigIntArray toType, InteropLibrary interop) {
        if (comparator == null && (fromType instanceof TypedArray.BigInt64Array || fromType instanceof TypedArray.DirectBigInt64Array || fromType instanceof TypedArray.InteropBigInt64Array)) {
            int i;
            long[] arr = new long[length];
            for (i = 0; i < length; ++i) {
                arr[i] = fromType.getLong(fromArray, i, interop);
            }
            Boundaries.arraySort(arr);
            for (i = 0; i < length; ++i) {
                toType.setLong(toArray, i, arr[i], interop);
            }
        } else {
            int i;
            BigInt[] arr = new BigInt[length];
            for (i = 0; i < length; ++i) {
                arr[i] = fromType.getBigInt(fromArray, i, interop);
            }
            Boundaries.arraySort(arr, comparator);
            if (this.isTypedArrayOutOfBounds(toArray)) {
                return;
            }
            for (i = 0; i < length; ++i) {
                toType.setBigInt(toArray, i, arr[i], interop);
            }
        }
    }

    private boolean isTypedArrayOutOfBounds(JSTypedArrayObject toArray) {
        return JSArrayBufferView.isOutOfBounds(toArray, this.getJSContext());
    }
}

