/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateCached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateInline;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PropertyDescriptor;

@ImportStatic(value={JSArray.class})
@GenerateInline
@GenerateCached(value=false)
public abstract class JSArrayGetOwnPropertyNode
extends JavaScriptBaseNode {
    protected static final int MAX_TYPE_COUNT = 4;

    protected JSArrayGetOwnPropertyNode() {
    }

    public abstract PropertyDescriptor execute(Node var1, JSArrayObject var2, long var3, boolean var5, boolean var6, boolean var7, boolean var8);

    @Specialization(guards={"arrayType.isInstance(arrayGetArrayType(arrayObject))"}, limit="MAX_TYPE_COUNT")
    protected static PropertyDescriptor doCached(JSArrayObject arrayObject, long index, boolean needValue, boolean needEnumerability, boolean needConfigurability, boolean needWritability, @Cached(value="arrayGetArrayType(arrayObject)") ScriptArray arrayType) {
        if (arrayType.hasElement(arrayObject, index)) {
            PropertyDescriptor desc = PropertyDescriptor.createEmpty();
            if (needEnumerability) {
                desc.setEnumerable(true);
            }
            if (needConfigurability) {
                desc.setConfigurable(!arrayType.isSealed());
            }
            if (needWritability) {
                desc.setWritable(!arrayType.isFrozen());
            }
            if (needValue) {
                desc.setValue(arrayType.getElement(arrayObject, index));
            }
            return desc;
        }
        return null;
    }

    @Specialization(replaces={"doCached"})
    protected static PropertyDescriptor doUncached(JSArrayObject target, long index, boolean needValue, boolean needEnumerability, boolean needConfigurability, boolean needWritability) {
        ScriptArray arrayType = JSArray.arrayGetArrayType(target);
        return JSArrayGetOwnPropertyNode.doCached(target, index, needValue, needEnumerability, needConfigurability, needWritability, arrayType);
    }
}

