/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Executed;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.Frame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameSlotKind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSWriteCurrentFrameSlotNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SafeInteger;

abstract class JSWriteCurrentFrameSlotNode
extends JSWriteFrameSlotNode {
    @Node.Child
    @Executed
    JavaScriptNode rhsNode;

    protected JSWriteCurrentFrameSlotNode(int slot, Object identifier, JavaScriptNode rhsNode) {
        super(slot, identifier);
        this.rhsNode = rhsNode;
    }

    @Specialization(guards={"isBooleanKind(frame)"})
    protected final boolean doBoolean(VirtualFrame frame, boolean value) {
        frame.setBoolean(this.slot, value);
        return value;
    }

    @Specialization(guards={"(isIntegerKind(frame, kind) || isLongKind(frame, kind)) || isDoubleKind(frame, kind)"})
    protected final int doInteger(VirtualFrame frame, int value, @Bind(value="getFrameDescriptor(frame).getSlotKind(slot)") FrameSlotKind kind) {
        if (this.isIntegerKind(frame, kind)) {
            frame.setInt(this.slot, value);
        } else if (this.isLongKind(frame, kind)) {
            frame.setLong(this.slot, value);
        } else if (this.isDoubleKind(frame, kind)) {
            frame.setDouble(this.slot, value);
        }
        return value;
    }

    @Specialization(guards={"isLongKind(frame)"})
    protected final SafeInteger doSafeInteger(VirtualFrame frame, SafeInteger value) {
        frame.setLong(this.slot, value.longValue());
        return value;
    }

    @Specialization
    protected final long doLong(VirtualFrame frame, long value) {
        this.ensureObjectKind(frame);
        frame.setObject(this.slot, value);
        return value;
    }

    @Specialization(guards={"isDoubleKind(frame)"}, replaces={"doInteger", "doSafeInteger"})
    protected final double doDouble(VirtualFrame frame, double value) {
        frame.setDouble(this.slot, value);
        return value;
    }

    @Specialization(replaces={"doBoolean", "doInteger", "doDouble", "doSafeInteger", "doLong"})
    protected final Object doObject(VirtualFrame frame, Object value) {
        this.ensureObjectKind(frame);
        frame.setObject(this.slot, value);
        return value;
    }

    @Override
    public final void executeWithFrame(Frame frame, Object value) {
        this.executeEvaluated((VirtualFrame)frame, value);
    }

    abstract void executeEvaluated(VirtualFrame var1, Object var2);

    @Override
    public final void executeWrite(VirtualFrame frame, Object value) {
        this.executeEvaluated(frame, value);
    }

    @Override
    public JavaScriptNode getRhs() {
        return this.rhsNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSWriteCurrentFrameSlotNodeGen.create(this.getSlotIndex(), this.getIdentifier(), JSWriteCurrentFrameSlotNode.cloneUninitialized(this.getRhs(), materializedTags));
    }

    @Override
    public ScopeFrameNode getLevelFrameNode() {
        return ScopeFrameNode.createCurrent();
    }
}

