/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.UnexpectedResultException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Property;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.ConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.JSArrayGetOwnPropertyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.ToArrayIndexNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSStringObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Accessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSProperty;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSShape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PropertyProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.JSClassProfile;

@ImportStatic(value={JSRuntime.class, JSShape.class})
public abstract class JSGetOwnPropertyNode
extends JavaScriptBaseNode {
    private final boolean needValue;
    private final boolean needEnumerability;
    private final boolean needConfigurability;
    private final boolean needWritability;
    final boolean allowCaching;
    @CompilerDirectives.CompilationFinal
    private boolean seenNonArrayIndex;
    private final ConditionProfile hasPropertyBranch = ConditionProfile.create();
    private final ConditionProfile isDataPropertyBranch = ConditionProfile.create();
    private final ConditionProfile isAccessorPropertyBranch = ConditionProfile.create();
    @Node.Child
    private GetPropertyProxyValueNode getPropertyProxyValueNode;

    protected JSGetOwnPropertyNode(boolean needValue, boolean needEnumerability, boolean needConfigurability, boolean needWritability, boolean allowCaching) {
        this.needValue = needValue;
        this.needEnumerability = needEnumerability;
        this.needConfigurability = needConfigurability;
        this.needWritability = needWritability;
        this.allowCaching = allowCaching;
    }

    @NeverDefault
    public static JSGetOwnPropertyNode create() {
        return JSGetOwnPropertyNode.create(true);
    }

    @NeverDefault
    public static JSGetOwnPropertyNode create(boolean needValue) {
        return JSGetOwnPropertyNode.create(needValue, true, true, true, true);
    }

    @NeverDefault
    public static JSGetOwnPropertyNode create(boolean needValue, boolean needEnumerability, boolean needConfigurability, boolean needWritability, boolean allowCaching) {
        return JSGetOwnPropertyNodeGen.create(needValue, needEnumerability, needConfigurability, needWritability, allowCaching);
    }

    public abstract PropertyDescriptor execute(JSDynamicObject var1, Object var2);

    @Specialization
    final PropertyDescriptor array(JSArrayObject thisObj, Object propertyKey, @Bind Node node, @Cached ToArrayIndexNode toArrayIndexNode, @Cached JSArrayGetOwnPropertyNode arrayGetOwnProperty, @Cached InlinedBranchProfile noSuchElementBranch) {
        PropertyDescriptor desc;
        assert (JSRuntime.isPropertyKey(propertyKey));
        long idx = this.toArrayIndex(propertyKey, toArrayIndexNode);
        if (JSRuntime.isArrayIndex(idx) && (desc = arrayGetOwnProperty.execute(node, thisObj, idx, this.needValue, this.needEnumerability, this.needConfigurability, this.needWritability)) != null) {
            return desc;
        }
        noSuchElementBranch.enter(node);
        Property prop = thisObj.getShape().getProperty(propertyKey);
        return this.ordinaryGetOwnProperty(thisObj, prop);
    }

    @Specialization
    protected PropertyDescriptor getOwnPropertyString(JSStringObject thisObj, Object key, @Cached InlinedConditionProfile stringCaseProfile) {
        assert (JSRuntime.isPropertyKey(key));
        Property prop = thisObj.getShape().getProperty(key);
        PropertyDescriptor desc = this.ordinaryGetOwnProperty(thisObj, prop);
        if (stringCaseProfile.profile(this, desc == null)) {
            return JSString.stringGetIndexProperty(thisObj, key);
        }
        return desc;
    }

    @Specialization(guards={"allowCaching", "cachedShape == thisObj.getShape()", "usesOrdinaryGetOwnProperty(cachedShape)", "propertyKeyEquals(equalsNode, cachedPropertyKey, propertyKey)"}, assumptions={"cachedShape.getValidAssumption()"}, limit="3")
    PropertyDescriptor cachedOrdinary(JSDynamicObject thisObj, Object propertyKey, @Cached(value="thisObj.getShape()") Shape cachedShape, @Cached(value="propertyKey") Object cachedPropertyKey, @Cached(value="cachedShape.getProperty(propertyKey)") Property cachedProperty, @Cached TruffleString.EqualNode equalsNode) {
        assert (JSRuntime.isPropertyKey(propertyKey) && JSObject.getJSClass(thisObj).usesOrdinaryGetOwnProperty());
        return this.ordinaryGetOwnProperty(thisObj, cachedProperty);
    }

    @Specialization(guards={"usesOrdinaryGetOwnProperty(thisObj.getShape())"}, replaces={"cachedOrdinary"})
    PropertyDescriptor uncachedOrdinary(JSDynamicObject thisObj, Object propertyKey) {
        assert (JSRuntime.isPropertyKey(propertyKey) && JSObject.getJSClass(thisObj).usesOrdinaryGetOwnProperty());
        Property prop = thisObj.getShape().getProperty(propertyKey);
        return this.ordinaryGetOwnProperty(thisObj, prop);
    }

    private PropertyDescriptor ordinaryGetOwnProperty(JSDynamicObject thisObj, Property prop) {
        assert (!JSProxy.isJSProxy(thisObj));
        if (this.hasPropertyBranch.profile(prop == null)) {
            return null;
        }
        PropertyDescriptor d = PropertyDescriptor.createEmpty();
        if (this.isDataPropertyBranch.profile(JSProperty.isData(prop))) {
            if (this.needWritability) {
                d.setWritable(JSProperty.isWritable(prop));
            }
            if (this.needValue) {
                d.setValue(this.getDataPropertyValue(thisObj, prop));
            }
        } else if (this.isAccessorPropertyBranch.profile(JSProperty.isAccessor(prop)) && this.needValue) {
            d.setAccessor((Accessor)prop.getLocation().get(thisObj));
        }
        if (this.needEnumerability) {
            d.setEnumerable(JSProperty.isEnumerable(prop));
        }
        if (this.needConfigurability) {
            d.setConfigurable(JSProperty.isConfigurable(prop));
        }
        return d;
    }

    private Object getDataPropertyValue(JSDynamicObject thisObj, Property prop) {
        assert (JSProperty.isData(prop));
        Object value = prop.getLocation().get(thisObj);
        if (JSProperty.isProxy(prop)) {
            return this.getPropertyProxyValue(thisObj, value);
        }
        assert (!JSProperty.isDataSpecial(prop)) : prop;
        return value;
    }

    private Object getPropertyProxyValue(JSDynamicObject obj, Object propertyProxy) {
        if (this.getPropertyProxyValueNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getPropertyProxyValueNode = this.insert(JSGetOwnPropertyNodeGen.GetPropertyProxyValueNodeGen.create());
        }
        return this.getPropertyProxyValueNode.execute(obj, propertyProxy);
    }

    @Specialization(guards={"!usesOrdinaryGetOwnProperty(thisObj.getShape())", "!isJSArray(thisObj)", "!isJSString(thisObj)"})
    static PropertyDescriptor generic(JSDynamicObject thisObj, Object key, @Cached JSClassProfile jsclassProfile) {
        assert (!(JSObject.getJSClass(thisObj).usesOrdinaryGetOwnProperty() || JSArray.isJSArray(thisObj) || JSString.isJSString(thisObj))) : thisObj;
        return JSObject.getOwnProperty(thisObj, key, jsclassProfile);
    }

    private long toArrayIndex(Object propertyKey, ToArrayIndexNode toArrayIndexNode) {
        if (this.seenNonArrayIndex) {
            Object result = toArrayIndexNode.execute(propertyKey);
            return result instanceof Long ? (Long)result : -1L;
        }
        try {
            return toArrayIndexNode.executeLong(propertyKey);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.seenNonArrayIndex = true;
            return -1L;
        }
    }

    public static abstract class GetPropertyProxyValueNode
    extends JavaScriptBaseNode {
        protected GetPropertyProxyValueNode() {
        }

        public abstract Object execute(JSDynamicObject var1, Object var2);

        @Specialization(guards={"propertyProxy.getClass() == cachedClass"}, limit="5")
        static Object doCached(JSDynamicObject obj, Object propertyProxy, @Cached(value="propertyProxy.getClass()") Class<?> cachedClass) {
            return ((PropertyProxy)cachedClass.cast(propertyProxy)).get(obj);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(replaces={"doCached"})
        static Object doUncached(JSDynamicObject obj, Object propertyProxy) {
            return ((PropertyProxy)propertyProxy).get(obj);
        }
    }
}

