/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Executed;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Property;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GlobalScopeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GlobalScopeTDZCheckNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Dead;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

abstract class GlobalScopeTDZCheckNode
extends GlobalScopeNode {
    final TruffleString varName;
    @Node.Child
    @Executed
    JavaScriptNode scopeNode;

    GlobalScopeTDZCheckNode(JSContext context, TruffleString varName) {
        super(context);
        this.varName = varName;
        this.scopeNode = GlobalScopeNode.create(context);
    }

    @Specialization(guards={"scope.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="context.getPropertyCacheLimit()")
    final Object doCached(JSDynamicObject scope, @Cached(value="scope.getShape()") Shape cachedShape, @Cached(value="isDead(cachedShape)") boolean dead) {
        assert (dead == (JSDynamicObject.getOrNull(scope, this.varName) == Dead.instance()));
        if (dead) {
            throw Errors.createReferenceErrorNotDefined(this.varName, this);
        }
        return scope;
    }

    @Specialization(replaces={"doCached"})
    final Object doUncached(Object scope, @Cached(value="create(varName, context)") PropertyGetNode getNode, @Cached InlinedBranchProfile deadBranch) {
        if (getNode.getValue(scope) == Dead.instance()) {
            deadBranch.enter(this);
            throw Errors.createReferenceErrorNotDefined(this.varName, this);
        }
        return scope;
    }

    final boolean isDead(Shape shape) {
        Property property = shape.getProperty(this.varName);
        return property != null && property.getLocation().isConstant() && property.getLocation().getConstantValue() == Dead.instance();
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return GlobalScopeTDZCheckNodeGen.create(this.context, this.varName);
    }
}

