/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal;

import java.util.EnumSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal.TemporalPlainDateTimePrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal.UnsupportedValueOfNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.DifferencePlainDateTimeWithRoundingNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.GetDifferenceSettingsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.GetRoundingIncrementOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.GetTemporalUnitNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.IsPartialTemporalObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalAddDateTimeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToFractionalSecondDigitsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarIdentifierNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalDateTimeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalTimeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneIdentifierNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSDate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPrecisionRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.TemporalDurationWithTotalRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.Calendar;

public class TemporalPlainDateTimePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalPlainDateTimePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalPlainDateTimePrototypeBuiltins();

    protected TemporalPlainDateTimePrototypeBuiltins() {
        super(JSTemporalPlainDateTime.PROTOTYPE_NAME, TemporalPlainDateTimePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalPlainDateTimePrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return TemporalPlainDateTimePrototypeBuiltinsFactory.JSTemporalPlainDateTimeCalendarGetterNodeGen.create(context, builtin, TemporalPlainDateTimePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return TemporalPlainDateTimePrototypeBuiltinsFactory.JSTemporalPlainDateTimeGetterNodeGen.create(context, builtin, builtinEnum, TemporalPlainDateTimePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 25: {
                return TemporalPlainDateTimePrototypeBuiltinsFactory.JSTemporalPlainDateTimeAddSubNodeGen.create(context, builtin, 1, TemporalPlainDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 26: {
                return TemporalPlainDateTimePrototypeBuiltinsFactory.JSTemporalPlainDateTimeAddSubNodeGen.create(context, builtin, -1, TemporalPlainDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 22: {
                return TemporalPlainDateTimePrototypeBuiltinsFactory.JSTemporalPlainDateTimeWithNodeGen.create(context, builtin, TemporalPlainDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 23: {
                return TemporalPlainDateTimePrototypeBuiltinsFactory.JSTemporalPlainDateTimeWithPlainTimeNodeGen.create(context, builtin, TemporalPlainDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 24: {
                return TemporalPlainDateTimePrototypeBuiltinsFactory.JSTemporalPlainDateTimeWithCalendarNodeGen.create(context, builtin, TemporalPlainDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 27: {
                return TemporalPlainDateTimePrototypeBuiltinsFactory.JSTemporalPlainDateTimeUntilSinceNodeGen.create(context, builtin, 1, TemporalPlainDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 28: {
                return TemporalPlainDateTimePrototypeBuiltinsFactory.JSTemporalPlainDateTimeUntilSinceNodeGen.create(context, builtin, -1, TemporalPlainDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 29: {
                return TemporalPlainDateTimePrototypeBuiltinsFactory.JSTemporalPlainDateTimeRoundNodeGen.create(context, builtin, TemporalPlainDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 30: {
                return TemporalPlainDateTimePrototypeBuiltinsFactory.JSTemporalPlainDateTimeEqualsNodeGen.create(context, builtin, TemporalPlainDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 36: {
                return TemporalPlainDateTimePrototypeBuiltinsFactory.JSTemporalPlainDateTimeToPlainTimeNodeGen.create(context, builtin, TemporalPlainDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 35: {
                return TemporalPlainDateTimePrototypeBuiltinsFactory.JSTemporalPlainDateTimeToPlainDateNodeGen.create(context, builtin, TemporalPlainDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 37: {
                return TemporalPlainDateTimePrototypeBuiltinsFactory.JSTemporalPlainDateTimeToZonedDateTimeNodeGen.create(context, builtin, TemporalPlainDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 31: {
                return TemporalPlainDateTimePrototypeBuiltinsFactory.JSTemporalPlainDateTimeToStringNodeGen.create(context, builtin, TemporalPlainDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 32: 
            case 33: {
                return TemporalPlainDateTimePrototypeBuiltinsFactory.JSTemporalPlainDateTimeToLocaleStringNodeGen.create(context, builtin, TemporalPlainDateTimePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 34: {
                return UnsupportedValueOfNodeGen.create(context, builtin, TemporalPlainDateTimePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalPlainDateTimePrototype implements BuiltinEnum<TemporalPlainDateTimePrototype>
    {
        calendarId(0),
        era(0),
        eraYear(0),
        year(0),
        month(0),
        monthCode(0),
        day(0),
        dayOfYear(0),
        dayOfWeek(0),
        weekOfYear(0),
        yearOfWeek(0),
        daysInWeek(0),
        daysInMonth(0),
        daysInYear(0),
        monthsInYear(0),
        inLeapYear(0),
        hour(0),
        minute(0),
        second(0),
        millisecond(0),
        microsecond(0),
        nanosecond(0),
        with(1),
        withPlainTime(0),
        withCalendar(1),
        add(1),
        subtract(1),
        until(1),
        since(1),
        round(1),
        equals(1),
        toString(0),
        toLocaleString(0),
        toJSON(0),
        valueOf(0),
        toPlainDate(0),
        toPlainTime(0),
        toZonedDateTime(1);

        private final int length;

        private TemporalPlainDateTimePrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(calendarId, new TemporalPlainDateTimePrototype[]{era, eraYear, hour, minute, second, millisecond, microsecond, nanosecond, year, month, monthCode, day, dayOfYear, dayOfWeek, weekOfYear, yearOfWeek, daysInWeek, daysInMonth, daysInYear, monthsInYear, inLeapYear}).contains(this);
        }
    }

    public static abstract class JSTemporalPlainDateTimeCalendarGetterNode
    extends JSBuiltinNode {
        public JSTemporalPlainDateTimeCalendarGetterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString calendarId(JSTemporalPlainDateTimeObject dateTime, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier) {
            return toCalendarIdentifier.executeString(dateTime.getCalendar());
        }

        @Specialization(guards={"!isJSTemporalPlainDateTime(dateTime)"})
        protected static TruffleString invalidReceiver(Object dateTime) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainDateTimeGetterNode
    extends JSBuiltinNode {
        public final TemporalPlainDateTimePrototype property;

        public JSTemporalPlainDateTimeGetterNode(JSContext context, JSBuiltin builtin, TemporalPlainDateTimePrototype property) {
            super(context, builtin);
            this.property = property;
        }

        @Specialization
        protected Object dateTimeGetter(JSTemporalPlainDateTimeObject temporalDT, @Cached TruffleString.EqualNode equalNode, @Cached InlinedConditionProfile isoCalendarProfile) {
            TruffleString calendar = temporalDT.getCalendar();
            boolean isoCalendar = isoCalendarProfile.profile(this, Strings.equals(equalNode, TemporalConstants.ISO8601, calendar));
            Calendar cal = null;
            if (!isoCalendar) {
                cal = IntlUtil.getCalendar(calendar, temporalDT.getYear(), temporalDT.getMonth(), temporalDT.getDay());
            }
            switch (this.property.ordinal()) {
                case 1: {
                    return isoCalendar ? Undefined.instance : IntlUtil.getEra(cal);
                }
                case 2: {
                    return isoCalendar ? Undefined.instance : IntlUtil.getEraYear(cal);
                }
                case 16: {
                    return temporalDT.getHour();
                }
                case 17: {
                    return temporalDT.getMinute();
                }
                case 18: {
                    return temporalDT.getSecond();
                }
                case 19: {
                    return temporalDT.getMillisecond();
                }
                case 20: {
                    return temporalDT.getMicrosecond();
                }
                case 21: {
                    return temporalDT.getNanosecond();
                }
                case 3: {
                    return isoCalendar ? temporalDT.getYear() : IntlUtil.getCalendarField(cal, 19);
                }
                case 4: {
                    return isoCalendar ? temporalDT.getMonth() : IntlUtil.getCalendarField(cal, 23) + 1;
                }
                case 6: {
                    return isoCalendar ? temporalDT.getDay() : IntlUtil.getCalendarField(cal, 5);
                }
                case 8: {
                    return isoCalendar ? TemporalUtil.toISODayOfWeek(temporalDT.getYear(), temporalDT.getMonth(), temporalDT.getDay()) : (long)IntlUtil.getCalendarField(cal, 7);
                }
                case 7: {
                    return isoCalendar ? TemporalUtil.toISODayOfYear(temporalDT.getYear(), temporalDT.getMonth(), temporalDT.getDay()) : IntlUtil.getCalendarField(cal, 6);
                }
                case 5: {
                    return isoCalendar ? TemporalUtil.buildISOMonthCode(temporalDT.getMonth()) : Strings.fromJavaString(IntlUtil.getTemporalMonthCode(cal));
                }
                case 9: {
                    return isoCalendar ? Long.valueOf(TemporalUtil.weekOfToISOWeekOfYear(temporalDT.getYear(), temporalDT.getMonth(), temporalDT.getDay())) : Undefined.instance;
                }
                case 10: {
                    return isoCalendar ? Long.valueOf(TemporalUtil.yearOfToISOWeekOfYear(temporalDT.getYear(), temporalDT.getMonth(), temporalDT.getDay())) : Undefined.instance;
                }
                case 11: {
                    return isoCalendar ? 7 : IntlUtil.getCalendarFieldMax(cal, 7);
                }
                case 12: {
                    return isoCalendar ? TemporalUtil.isoDaysInMonth(temporalDT.getYear(), temporalDT.getMonth()) : IntlUtil.getCalendarFieldMax(cal, 5);
                }
                case 13: {
                    return isoCalendar ? TemporalUtil.isoDaysInYear(temporalDT.getYear()) : IntlUtil.getCalendarFieldMax(cal, 6);
                }
                case 14: {
                    return isoCalendar ? 12 : IntlUtil.getCalendarFieldMax(cal, 23) + 1;
                }
                case 15: {
                    return isoCalendar ? JSDate.isLeapYear(temporalDT.getYear()) : IntlUtil.isLeapYear(cal);
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalPlainDateTime(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainDateTimeAddSubNode
    extends JSTemporalBuiltinOperation {
        private final int sign;

        protected JSTemporalPlainDateTimeAddSubNode(JSContext context, JSBuiltin builtin, int sign) {
            super(context, builtin);
            this.sign = sign;
        }

        @Specialization
        final JSTemporalPlainDateTimeObject addDurationToOrSubtractDurationFromPlainDateTime(JSTemporalPlainDateTimeObject dateTime, Object temporalDurationLike, Object options, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached TemporalGetOptionNode getOptionNode, @Cached TemporalAddDateTimeNode addDateTime, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalDurationObject duration = toTemporalDurationNode.execute(temporalDurationLike);
            TemporalUtil.rejectDurationSign(duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds());
            JSDynamicObject resolvedOptions = this.getOptionsObject(options, this, errorBranch, optionUndefined);
            TemporalUtil.Overflow overflow = TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
            TruffleString calendar = dateTime.getCalendar();
            BigInt norm = TemporalUtil.normalizeTimeDuration((double)this.sign * duration.getHours(), (double)this.sign * duration.getMinutes(), (double)this.sign * duration.getSeconds(), (double)this.sign * duration.getMilliseconds(), (double)this.sign * duration.getMicroseconds(), (double)this.sign * duration.getNanoseconds());
            JSTemporalDateTimeRecord result = addDateTime.execute(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getMillisecond(), dateTime.getMicrosecond(), dateTime.getNanosecond(), calendar, (double)this.sign * duration.getYears(), (double)this.sign * duration.getMonths(), (double)this.sign * duration.getWeeks(), (double)this.sign * duration.getDays(), norm, overflow);
            return JSTemporalPlainDateTime.create(this.getContext(), this.getRealm(), result.getYear(), result.getMonth(), result.getDay(), result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond(), dateTime.getCalendar(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainDateTime(thisObj)"})
        static JSTemporalPlainDateTimeObject invalidReceiver(Object thisObj, Object temporalDurationLike, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateTimeExpected();
        }
    }

    @ImportStatic(value={TemporalConstants.class})
    public static abstract class JSTemporalPlainDateTimeWith
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateTimeWith(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        final JSTemporalPlainDateTimeObject with(JSTemporalPlainDateTimeObject dateTime, Object temporalDateTimeLike, Object options, @Bind Node node, @Cached IsPartialTemporalObjectNode isPartialTemporalObjectNode, @Cached TemporalGetOptionNode getOptionNode, @Cached(value="create(getContext(), HOUR)") CreateDataPropertyNode createHourDataPropertyNode, @Cached(value="create(getContext(), MINUTE)") CreateDataPropertyNode createMinuteDataPropertyNode, @Cached(value="create(getContext(), SECOND)") CreateDataPropertyNode createSecondDataPropertyNode, @Cached(value="create(getContext(), MILLISECOND)") CreateDataPropertyNode createMillisecondDataPropertyNode, @Cached(value="create(getContext(), MICROSECOND)") CreateDataPropertyNode createMicrosecondDataPropertyNode, @Cached(value="create(getContext(), NANOSECOND)") CreateDataPropertyNode createNanosecondDataPropertyNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            if (!isPartialTemporalObjectNode.execute(temporalDateTimeLike)) {
                errorBranch.enter(node);
                throw TemporalErrors.createTypeErrorPartialTemporalObjectExpected();
            }
            JSContext ctx = this.getContext();
            TruffleString calendar = dateTime.getCalendar();
            JSDynamicObject fields = TemporalUtil.isoDateToFields(ctx, calendar, dateTime.isoDate(), TemporalUtil.FieldsType.DATE);
            createHourDataPropertyNode.executeVoid(fields, dateTime.getHour());
            createMinuteDataPropertyNode.executeVoid(fields, dateTime.getMinute());
            createSecondDataPropertyNode.executeVoid(fields, dateTime.getSecond());
            createMillisecondDataPropertyNode.executeVoid(fields, dateTime.getMillisecond());
            createMicrosecondDataPropertyNode.executeVoid(fields, dateTime.getMicrosecond());
            createNanosecondDataPropertyNode.executeVoid(fields, dateTime.getNanosecond());
            JSObject partialDateTime = TemporalUtil.prepareCalendarFields(ctx, calendar, temporalDateTimeLike, TemporalUtil.listDMMCY, TemporalUtil.listTimeUnits, null);
            fields = TemporalUtil.calendarMergeFields(ctx, calendar, fields, partialDateTime);
            JSDynamicObject resolvedOptions = this.getOptionsObject(options, node, errorBranch, optionUndefined);
            TemporalUtil.Overflow overflow = TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
            JSTemporalDateTimeRecord result = TemporalUtil.interpretTemporalDateTimeFields(calendar, fields, overflow, dateFromFieldsNode);
            assert (TemporalUtil.isValidISODate(result.getYear(), result.getMonth(), result.getDay()));
            assert (TemporalUtil.isValidTime(result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond()));
            return JSTemporalPlainDateTime.create(ctx, this.getRealm(), result.getYear(), result.getMonth(), result.getDay(), result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond(), calendar, node, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainDateTime(thisObj)"})
        static JSTemporalPlainDateTimeObject invalidReceiver(Object thisObj, Object temporalDateTimeLike, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainDateTimeWithPlainTimeNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateTimeWithPlainTimeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        final JSTemporalPlainDateTimeObject withPlainTime(JSTemporalPlainDateTimeObject temporalDateTime, Object plainTimeLike, @Cached ToTemporalTimeNode toTemporalTime, @Cached InlinedBranchProfile errorBranch) {
            if (plainTimeLike == Undefined.instance) {
                return JSTemporalPlainDateTime.create(this.getContext(), this.getRealm(), temporalDateTime.getYear(), temporalDateTime.getMonth(), temporalDateTime.getDay(), 0, 0, 0, 0, 0, 0, temporalDateTime.getCalendar(), this, errorBranch);
            }
            JSTemporalPlainTimeObject plainTime = toTemporalTime.execute(plainTimeLike, Undefined.instance);
            return JSTemporalPlainDateTime.create(this.getContext(), this.getRealm(), temporalDateTime.getYear(), temporalDateTime.getMonth(), temporalDateTime.getDay(), plainTime.getHour(), plainTime.getMinute(), plainTime.getSecond(), plainTime.getMillisecond(), plainTime.getMicrosecond(), plainTime.getNanosecond(), temporalDateTime.getCalendar(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainDateTime(thisObj)"})
        static JSTemporalPlainDateTimeObject invalidReceiver(Object thisObj, Object plainTimeLike) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainDateTimeWithCalendarNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateTimeWithCalendarNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        final JSTemporalPlainDateTimeObject withCalendar(JSTemporalPlainDateTimeObject temporalDateTime, Object calendarLike, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier, @Cached InlinedBranchProfile errorBranch) {
            TruffleString calendar = toCalendarIdentifier.executeString(calendarLike);
            return JSTemporalPlainDateTime.create(this.getContext(), this.getRealm(), temporalDateTime.getYear(), temporalDateTime.getMonth(), temporalDateTime.getDay(), temporalDateTime.getHour(), temporalDateTime.getMinute(), temporalDateTime.getSecond(), temporalDateTime.getMillisecond(), temporalDateTime.getMicrosecond(), temporalDateTime.getNanosecond(), calendar, this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainDateTime(thisObj)"})
        static JSTemporalPlainDateTimeObject invalidReceiver(Object thisObj, Object calendarParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainDateTimeUntilSinceNode
    extends JSTemporalBuiltinOperation {
        private final int sign;

        protected JSTemporalPlainDateTimeUntilSinceNode(JSContext context, JSBuiltin builtin, int sign) {
            super(context, builtin);
            this.sign = sign;
        }

        @Specialization
        protected JSTemporalDurationObject differenceTemporalPlainDateTime(JSTemporalPlainDateTimeObject dateTime, Object otherObj, Object options, @Bind Node node, @Cached ToTemporalDateTimeNode toTemporalDateTime, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier, @Cached DifferencePlainDateTimeWithRoundingNode differencePlainDateTimeWithRounding, @Cached GetDifferenceSettingsNode getDifferenceSettings, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalPlainDateTimeObject other = toTemporalDateTime.execute(otherObj, Undefined.instance);
            if (!TemporalUtil.calendarEquals(dateTime.getCalendar(), other.getCalendar(), toCalendarIdentifier)) {
                errorBranch.enter(node);
                throw TemporalErrors.createRangeErrorIdenticalCalendarExpected();
            }
            JSContext ctx = this.getContext();
            JSRealm realm = this.getRealm();
            JSDynamicObject resolvedOptions = this.getOptionsObject(options, node, errorBranch, optionUndefined);
            GetDifferenceSettingsNode.GetDifferenceSettingsResult settings = getDifferenceSettings.execute(this.sign, resolvedOptions, TemporalUtil.unitMappingDateTimeOrAuto, TemporalUtil.unitMappingDateTime, TemporalUtil.Unit.NANOSECOND, TemporalUtil.Unit.DAY);
            if (dateTime.getYear() == other.getYear() && dateTime.getMonth() == other.getMonth() && dateTime.getDay() == other.getDay() && dateTime.getHour() == other.getHour() && dateTime.getMinute() == other.getMinute() && dateTime.getSecond() == other.getSecond() && dateTime.getMillisecond() == other.getMillisecond() && dateTime.getMicrosecond() == other.getMicrosecond() && dateTime.getNanosecond() == other.getNanosecond()) {
                return JSTemporalDuration.createTemporalDuration(ctx, realm, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch);
            }
            JSTemporalPlainDateObject plainDate = JSTemporalPlainDate.create(ctx, realm, dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), dateTime.getCalendar(), node, errorBranch);
            TemporalDurationWithTotalRecord resultRecord = differencePlainDateTimeWithRounding.execute(plainDate, dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getMillisecond(), dateTime.getMicrosecond(), dateTime.getNanosecond(), other.getYear(), other.getMonth(), other.getDay(), other.getHour(), other.getMinute(), other.getSecond(), other.getMillisecond(), other.getMicrosecond(), other.getNanosecond(), other.getCalendar(), settings.largestUnit(), settings.roundingIncrement(), settings.smallestUnit(), settings.roundingMode());
            JSTemporalDurationRecord result = resultRecord.duration();
            return JSTemporalDuration.createTemporalDuration(ctx, realm, (double)this.sign * result.getYears(), (double)this.sign * result.getMonths(), (double)this.sign * result.getWeeks(), (double)this.sign * result.getDays(), (double)this.sign * result.getHours(), (double)this.sign * result.getMinutes(), (double)this.sign * result.getSeconds(), (double)this.sign * result.getMilliseconds(), (double)this.sign * result.getMicroseconds(), (double)this.sign * result.getNanoseconds(), node, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainDateTime(thisObj)"})
        static JSTemporalDurationObject invalidReceiver(Object thisObj, Object otherObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainDateTimeRoundNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateTimeRoundNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        final JSTemporalPlainDateTimeObject round(JSTemporalPlainDateTimeObject dt, Object roundToParam, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached GetTemporalUnitNode getSmallestUnit, @Cached GetRoundingIncrementOptionNode getRoundingIncrementOption, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            boolean inclusive;
            int maximum;
            JSDynamicObject roundTo;
            if (roundToParam == Undefined.instance) {
                throw TemporalErrors.createTypeErrorOptionsUndefined();
            }
            if (Strings.isTString(roundToParam)) {
                roundTo = JSOrdinary.createWithNullPrototype(this.getContext());
                JSRuntime.createDataPropertyOrThrow(roundTo, TemporalConstants.SMALLEST_UNIT, roundToParam);
            } else {
                roundTo = this.getOptionsObject(roundToParam, this, errorBranch, optionUndefined);
            }
            int roundingIncrement = getRoundingIncrementOption.execute(roundTo);
            TemporalUtil.RoundingMode roundingMode = JSTemporalPlainDateTimeRoundNode.toTemporalRoundingMode(roundTo, TemporalConstants.HALF_EXPAND, equalNode, getOptionNode);
            TemporalUtil.Unit smallestUnit = getSmallestUnit.execute(roundTo, TemporalConstants.SMALLEST_UNIT, TemporalUtil.unitMappingTimeOrDay, TemporalUtil.Unit.REQUIRED);
            if (TemporalUtil.Unit.DAY == smallestUnit) {
                maximum = 1;
                inclusive = true;
            } else {
                maximum = TemporalUtil.maximumTemporalDurationRoundingIncrement(smallestUnit);
                inclusive = false;
            }
            TemporalUtil.validateTemporalRoundingIncrement(roundingIncrement, maximum, inclusive, this, errorBranch);
            if (smallestUnit == TemporalUtil.Unit.NANOSECOND && roundingIncrement == 1) {
                return JSTemporalPlainDateTime.create(this.getContext(), this.getRealm(), dt.getYear(), dt.getMonth(), dt.getDay(), dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getMillisecond(), dt.getMicrosecond(), dt.getNanosecond(), dt.getCalendar(), this, errorBranch);
            }
            JSTemporalDurationRecord result = TemporalUtil.roundISODateTime(dt.getYear(), dt.getMonth(), dt.getDay(), dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getMillisecond(), dt.getMicrosecond(), dt.getNanosecond(), roundingIncrement, smallestUnit, roundingMode);
            return JSTemporalPlainDateTime.create(this.getContext(), this.getRealm(), TemporalUtil.dtoi(result.getYears()), TemporalUtil.dtoi(result.getMonths()), TemporalUtil.dtoi(result.getDays()), TemporalUtil.dtoi(result.getHours()), TemporalUtil.dtoi(result.getMinutes()), TemporalUtil.dtoi(result.getSeconds()), TemporalUtil.dtoi(result.getMilliseconds()), TemporalUtil.dtoi(result.getMicroseconds()), TemporalUtil.dtoi(result.getNanoseconds()), dt.getCalendar(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainDateTime(thisObj)"})
        static JSTemporalPlainDateTimeObject invalidReceiver(Object thisObj, Object roundToParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainDateTimeEquals
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateTimeEquals(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean equalsOtherObj(JSTemporalPlainDateTimeObject thisDateTime, JSTemporalPlainDateTimeObject otherDateTime, @Cached.Shared @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier) {
            return JSTemporalPlainDateTimeEquals.equalsIntl(thisDateTime, otherDateTime, toCalendarIdentifier);
        }

        @Specialization(guards={"!isJSTemporalPlainDateTime(other)"})
        protected boolean equalsGeneric(JSTemporalPlainDateTimeObject thisDateTime, Object other, @Cached ToTemporalDateTimeNode toTemporalDateTime, @Cached.Shared @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier) {
            JSTemporalPlainDateTimeObject otherDateTime = toTemporalDateTime.execute(other, Undefined.instance);
            return JSTemporalPlainDateTimeEquals.equalsIntl(thisDateTime, otherDateTime, toCalendarIdentifier);
        }

        private static boolean equalsIntl(JSTemporalPlainDateTimeObject one, JSTemporalPlainDateTimeObject two, ToTemporalCalendarIdentifierNode toCalendarIdentifier) {
            int result = TemporalUtil.compareISODateTime(one.getYear(), one.getMonth(), one.getDay(), one.getHour(), one.getMinute(), one.getSecond(), one.getMillisecond(), one.getMicrosecond(), one.getNanosecond(), two.getYear(), two.getMonth(), two.getDay(), two.getHour(), two.getMinute(), two.getSecond(), two.getMillisecond(), two.getMicrosecond(), two.getNanosecond());
            if (result != 0) {
                return false;
            }
            return TemporalUtil.calendarEquals(one.getCalendar(), two.getCalendar(), toCalendarIdentifier);
        }

        @Specialization(guards={"!isJSTemporalPlainDateTime(thisObj)"})
        static boolean invalidReceiver(Object thisObj, Object otherObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainDateTimeToPlainTimeNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateTimeToPlainTimeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        final JSTemporalPlainTimeObject toPlainTime(JSTemporalPlainDateTimeObject dt, @Cached InlinedBranchProfile errorBranch) {
            return JSTemporalPlainTime.create(this.getContext(), this.getRealm(), dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getMillisecond(), dt.getMicrosecond(), dt.getNanosecond(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainDateTime(thisObj)"})
        static JSTemporalPlainTimeObject invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainDateTimeToPlainDateNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateTimeToPlainDateNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        final JSTemporalPlainDateObject toPlainDate(JSTemporalPlainDateTimeObject dt, @Cached InlinedBranchProfile errorBranch) {
            return JSTemporalPlainDate.create(this.getContext(), this.getRealm(), dt.getYear(), dt.getMonth(), dt.getDay(), dt.getCalendar(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainDateTime(thisObj)"})
        static JSTemporalPlainDateObject invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainDateTimeToZonedDateTimeNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateTimeToZonedDateTimeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        final JSTemporalZonedDateTimeObject toZonedDateTime(JSTemporalPlainDateTimeObject dateTime, Object temporalTimeZoneLike, Object optionsParam, @Cached ToTemporalTimeZoneIdentifierNode toTimeZoneIdentifier, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            TruffleString timeZone = toTimeZoneIdentifier.execute(temporalTimeZoneLike);
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TemporalUtil.Disambiguation disambiguation = TemporalUtil.toTemporalDisambiguation(options, getOptionNode, equalNode);
            BigInt epochNs = TemporalUtil.getEpochNanosecondsFor(this.getContext(), this.getRealm(), timeZone, dateTime, disambiguation);
            return JSTemporalZonedDateTime.create(this.getContext(), this.getRealm(), epochNs, timeZone, dateTime.getCalendar());
        }

        @Specialization(guards={"!isJSTemporalPlainDateTime(thisObj)"})
        static JSTemporalZonedDateTimeObject invalidReceiver(Object thisObj, Object temporalTimeZoneLike, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainDateTimeToString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateTimeToString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toString(JSTemporalPlainDateTimeObject dt, Object optionsParam, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached ToFractionalSecondDigitsNode toFractionalSecondDigitsNode, @Cached GetTemporalUnitNode getSmallestUnit, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TemporalUtil.ShowCalendar showCalendar = TemporalUtil.toShowCalendarOption(options, getOptionNode, equalNode);
            int digits = toFractionalSecondDigitsNode.execute(options);
            TemporalUtil.RoundingMode roundingMode = JSTemporalPlainDateTimeToString.toTemporalRoundingMode(options, TemporalConstants.TRUNC, equalNode, getOptionNode);
            TemporalUtil.Unit smallestUnit = getSmallestUnit.execute(options, TemporalConstants.SMALLEST_UNIT, TemporalUtil.unitMappingTime, TemporalUtil.Unit.EMPTY);
            if (smallestUnit == TemporalUtil.Unit.HOUR) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorSmallestUnitOutOfRange();
            }
            JSTemporalPrecisionRecord precision = TemporalUtil.toSecondsStringPrecisionRecord(smallestUnit, digits);
            JSTemporalDurationRecord result = TemporalUtil.roundISODateTime(dt.getYear(), dt.getMonth(), dt.getDay(), dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getMillisecond(), dt.getMicrosecond(), dt.getNanosecond(), precision.getIncrement(), precision.getUnit(), roundingMode);
            if (!TemporalUtil.isoDateTimeWithinLimits((int)result.getYears(), (int)result.getMonths(), (int)result.getDays(), (int)result.getHours(), (int)result.getMinutes(), (int)result.getSeconds(), (int)result.getMilliseconds(), (int)result.getMicroseconds(), (int)result.getNanoseconds())) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorDateTimeOutsideRange();
            }
            return JSTemporalPlainDateTime.temporalDateTimeToString(TemporalUtil.dtoi(result.getYears()), TemporalUtil.dtoi(result.getMonths()), TemporalUtil.dtoi(result.getDays()), TemporalUtil.dtoi(result.getHours()), TemporalUtil.dtoi(result.getMinutes()), TemporalUtil.dtoi(result.getSeconds()), TemporalUtil.dtoi(result.getMilliseconds()), TemporalUtil.dtoi(result.getMicroseconds()), TemporalUtil.dtoi(result.getNanoseconds()), dt.getCalendar(), precision.getPrecision(), showCalendar);
        }

        @Specialization(guards={"!isJSTemporalPlainDateTime(thisObj)"})
        static TruffleString invalidReceiver(Object thisObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateTimeExpected();
        }
    }

    public static abstract class JSTemporalPlainDateTimeToLocaleString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateTimeToLocaleString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        static TruffleString toLocaleString(JSTemporalPlainDateTimeObject dt) {
            return JSTemporalPlainDateTime.temporalDateTimeToString(dt.getYear(), dt.getMonth(), dt.getDay(), dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getMillisecond(), dt.getMicrosecond(), dt.getNanosecond(), dt.getCalendar(), TemporalConstants.AUTO, TemporalUtil.ShowCalendar.AUTO);
        }

        @Specialization(guards={"!isJSTemporalPlainDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateTimeExpected();
        }
    }
}

