/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.json;

import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleStringBuilder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.json.JSONData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.json.JSONStringifyStringNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JSGuards;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SafeInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSBigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSBigIntObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSBoolean;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSBooleanObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNumberObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSRawJSONObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSStringObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.StringBuilderProfile;

public abstract class JSONStringifyStringNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertyGetNode getToJSONProperty;
    @Node.Child
    private JSFunctionCallNode callToJSONFunction;
    @Node.Child
    private TruffleStringBuilder.ToStringNode builderToStringNode = TruffleStringBuilder.ToStringNode.create();
    private final StringBuilderProfile stringBuilderProfile;

    protected JSONStringifyStringNode(JSContext context) {
        this.stringBuilderProfile = StringBuilderProfile.create(context.getStringLengthLimit());
    }

    public abstract Object execute(Object var1, Object var2, JSObject var3);

    @NeverDefault
    public static JSONStringifyStringNode create(JSContext context) {
        return JSONStringifyStringNodeGen.create(context);
    }

    @Specialization
    public Object jsonStrMain(Object jsonData, TruffleString keyStr, JSObject holder) {
        try {
            assert (jsonData instanceof JSONData);
            JSONData data = (JSONData)jsonData;
            Object value = this.getPreparedJSONPropertyValue(data, keyStr, holder);
            if (!JSONStringifyStringNode.isStringifyable(value)) {
                return Undefined.instance;
            }
            TruffleStringBuilderUTF16 sb = this.stringBuilderProfile.newStringBuilder();
            this.serializeJSONPropertyValue(sb, data, value);
            return this.builderToString(sb);
        }
        catch (StackOverflowError ex) {
            JSONStringifyStringNode.throwStackError();
            return null;
        }
    }

    private static boolean isStringifyable(Object value) {
        return value != Undefined.instance;
    }

    @CompilerDirectives.TruffleBoundary
    private void serializeJSONPropertyValue(TruffleStringBuilderUTF16 builder, JSONData data, Object value) {
        assert (JSONStringifyStringNode.isStringifyable(value));
        if (value == Null.instance) {
            this.append(builder, Null.NAME);
        } else if (value instanceof Boolean) {
            this.appendBoolean(builder, (Boolean)value);
        } else if (value instanceof TruffleString) {
            TruffleString str = (TruffleString)value;
            this.jsonQuote(builder, str);
        } else if (JSRuntime.isNumber(value)) {
            this.appendNumber(builder, value);
        } else if (JSObject.isJSObject(value)) {
            JSObject valueObj = (JSObject)value;
            assert (!JSRuntime.isCallableIsJSObject(valueObj));
            if (valueObj instanceof JSRawJSONObject) {
                JSRawJSONObject rawJSONObject = (JSRawJSONObject)valueObj;
                this.append(builder, rawJSONObject.getRawJSON());
            } else if (JSRuntime.isArray(valueObj)) {
                this.serializeJSONArray(builder, data, valueObj);
            } else {
                this.serializeJSONObject(builder, data, valueObj);
            }
        } else {
            if (JSRuntime.isBigInt(value)) {
                throw Errors.createTypeError("Do not know how to serialize a BigInt");
            }
            if (value instanceof TruffleObject || value instanceof Long) {
                this.serializeForeignObject(builder, data, value);
            } else {
                throw JSONStringifyStringNode.unsupportedType(value);
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static RuntimeException unsupportedType(Object value) {
        assert (false) : "JSON.stringify: should never reach here, unknown type: " + String.valueOf(value) + " " + String.valueOf(value.getClass());
        return Errors.createTypeError("Do not know how to serialize a value of type " + (value == null ? "null" : value.getClass().getTypeName()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void serializeForeignObject(TruffleStringBuilderUTF16 sb, JSONData data, Object obj) {
        assert (JSGuards.isForeignObjectOrNumber(obj));
        InteropLibrary interop = InteropLibrary.getFactory().getUncached(obj);
        if (interop.isNull(obj)) {
            this.append(sb, Null.NAME);
            return;
        }
        try {
            if (interop.isBoolean(obj)) {
                this.appendBoolean(sb, interop.asBoolean(obj));
                return;
            } else if (interop.isString(obj)) {
                this.jsonQuote(sb, interop.asTruffleString(obj));
                return;
            } else if (interop.isNumber(obj)) {
                if (interop.fitsInInt(obj)) {
                    this.appendNumber(sb, interop.asInt(obj));
                    return;
                } else {
                    if (!interop.fitsInDouble(obj)) throw Errors.createTypeError("Do not know how to serialize a BigInt");
                    this.appendNumber(sb, interop.asDouble(obj));
                }
                return;
            } else if (interop.hasArrayElements(obj)) {
                this.serializeJSONArray(sb, data, obj);
                return;
            } else {
                this.serializeJSONObject(sb, data, obj);
            }
            return;
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorUnboxException(obj, e, this);
        }
    }

    private void appendBoolean(TruffleStringBuilderUTF16 builder, boolean value) {
        this.append(builder, value ? JSBoolean.TRUE_NAME : JSBoolean.FALSE_NAME);
    }

    private void appendNumber(TruffleStringBuilderUTF16 builder, Object number) {
        assert (number instanceof Number);
        if (number instanceof Integer) {
            this.append(builder, (Integer)number);
        } else if (number instanceof SafeInteger) {
            this.append(builder, ((SafeInteger)number).longValue());
        } else {
            double d = number instanceof Double ? (Double)number : JSRuntime.doubleValue((Number)number);
            TruffleString str = Double.isNaN(d) || Double.isInfinite(d) ? Null.NAME : JSRuntime.doubleToString(d);
            this.append(builder, str);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private Object getPreparedJSONPropertyValue(JSONData data, TruffleString keyStr, Object holder) {
        Object value = JSObject.isJSObject(holder) ? JSObject.get((JSDynamicObject)((JSObject)holder), keyStr) : JSONStringifyStringNode.truffleRead(holder, keyStr);
        return this.prepareJSONPropertyValue(data, keyStr, holder, value);
    }

    @CompilerDirectives.TruffleBoundary
    private Object getPreparedJSONPropertyValueFromJSArray(JSONData data, int key, JSObject holder) {
        Object value = JSObject.get((JSDynamicObject)holder, key);
        return this.prepareJSONPropertyValue(data, Strings.fromInt(key), holder, value);
    }

    @CompilerDirectives.TruffleBoundary
    private Object getPreparedJSONPropertyValueFromForeignArray(JSONData data, int key, Object holder) {
        assert (JSGuards.isForeignObject(holder));
        Object value = JSONStringifyStringNode.truffleRead(holder, key);
        return this.prepareJSONPropertyValue(data, Strings.fromInt(key), holder, value);
    }

    private Object prepareJSONPropertyValue(JSONData data, Object key, Object holder, Object valueArg) {
        Object value = valueArg;
        boolean tryToJSON = false;
        if (JSRuntime.isObject(value) || JSRuntime.isBigInt(value)) {
            tryToJSON = true;
        } else if (JSRuntime.isForeignObject(value)) {
            InteropLibrary interop = InteropLibrary.getUncached(value);
            boolean bl = tryToJSON = interop.hasMembers(value) && !interop.isNull(value) && !JSInteropUtil.isBoxedPrimitive(value, interop);
        }
        if (tryToJSON) {
            value = this.tryToJSONMethod(key, value);
        }
        if (data.getReplacerFnObj() != null) {
            value = JSRuntime.call(data.getReplacerFnObj(), holder, new Object[]{key, value});
        }
        if (JSObject.isJSObject(value)) {
            return JSONStringifyStringNode.prepareJSObject((JSObject)value);
        }
        if (value instanceof Symbol) {
            return Undefined.instance;
        }
        if (JSRuntime.isCallableForeign(value)) {
            return Undefined.instance;
        }
        return value;
    }

    private static Object prepareJSObject(JSObject valueObj) {
        if (valueObj instanceof JSNumberObject) {
            JSNumberObject numberObj = (JSNumberObject)valueObj;
            return JSRuntime.toNumber(numberObj);
        }
        if (valueObj instanceof JSBigIntObject) {
            JSBigIntObject bigIntObj = (JSBigIntObject)valueObj;
            return JSBigInt.valueOf(bigIntObj);
        }
        if (valueObj instanceof JSStringObject) {
            JSStringObject stringObj = (JSStringObject)valueObj;
            return JSRuntime.toString(stringObj);
        }
        if (valueObj instanceof JSBooleanObject) {
            JSBooleanObject booleanObj = (JSBooleanObject)valueObj;
            return JSBoolean.valueOf(booleanObj);
        }
        if (JSRuntime.isCallableIsJSObject(valueObj)) {
            return Undefined.instance;
        }
        return valueObj;
    }

    private Object tryToJSONMethod(Object key, Object value) {
        Object toJSON;
        assert (JSRuntime.isPropertyKey(key));
        if (this.getToJSONProperty == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getToJSONProperty = this.insert(PropertyGetNode.create(Strings.TO_JSON, this.getJSContext()));
        }
        if (JSRuntime.isCallable(toJSON = this.getToJSONProperty.getValue(value))) {
            return this.callToJSONMethod(key, value, toJSON);
        }
        return value;
    }

    private Object callToJSONMethod(Object key, Object value, Object toJSON) {
        if (this.callToJSONFunction == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callToJSONFunction = this.insert(JSFunctionCallNode.createCall());
        }
        return this.callToJSONFunction.executeCall(JSArguments.createOneArg(value, toJSON, key));
    }

    @CompilerDirectives.TruffleBoundary
    private TruffleStringBuilder serializeJSONObject(TruffleStringBuilderUTF16 sb, JSONData data, Object value) {
        assert (!JSRuntime.isNullish(value)) : value;
        JSONStringifyStringNode.checkCycle(data, value);
        data.pushStack(value);
        JSONStringifyStringNode.checkStackDepth(data);
        int stepback = data.getIndent();
        int indent = data.getIndent() + 1;
        data.setIndent(indent);
        this.concatStart(sb, '{');
        int lengthBefore = StringBuilderProfile.length(sb);
        if (data.getPropertyList() == null) {
            if (JSObject.isJSObject(value)) {
                this.serializeJSONObjectProperties(sb, data, value, indent, JSObject.enumerableOwnNames((JSObject)value));
            } else {
                this.serializeForeignObjectProperties(sb, data, value, indent);
            }
        } else {
            this.serializeJSONObjectProperties(sb, data, value, indent, data.getPropertyList());
        }
        this.concatEnd(sb, data, stepback, '}', lengthBefore != StringBuilderProfile.length(sb));
        data.popStack();
        data.setIndent(stepback);
        return sb;
    }

    private TruffleStringBuilder serializeJSONObjectProperties(TruffleStringBuilderUTF16 sb, JSONData data, Object value, int indent, List<? extends Object> keys) {
        boolean isFirst = true;
        for (Object object : keys) {
            TruffleString name = (TruffleString)object;
            Object strPPrepared = this.getPreparedJSONPropertyValue(data, name, value);
            if (!JSONStringifyStringNode.isStringifyable(strPPrepared)) continue;
            if (isFirst) {
                this.concatFirstStep(sb, data);
                isFirst = false;
            } else {
                this.appendSeparator(sb, data, indent);
            }
            this.jsonQuote(sb, name);
            this.appendColon(sb, data);
            this.serializeJSONPropertyValue(sb, data, strPPrepared);
        }
        return sb;
    }

    private void appendColon(TruffleStringBuilderUTF16 sb, JSONData data) {
        this.append(sb, ':');
        if (Strings.length(data.getGap()) > 0) {
            this.append(sb, ' ');
        }
    }

    private void serializeForeignObjectProperties(TruffleStringBuilderUTF16 sb, JSONData data, Object obj, int indent) {
        try {
            InteropLibrary objInterop = InteropLibrary.getFactory().getUncached(obj);
            if (!objInterop.hasMembers(obj)) {
                return;
            }
            Object keysObj = objInterop.getMembers(obj);
            InteropLibrary keysInterop = InteropLibrary.getFactory().getUncached(keysObj);
            long size = keysInterop.getArraySize(keysObj);
            boolean isFirst = true;
            for (long i = 0L; i < size; ++i) {
                Object memberValue;
                Object strPPrepared;
                Object key = keysInterop.readArrayElement(keysObj, i);
                TruffleString stringKey = Strings.interopAsTruffleString(key);
                if (!objInterop.isMemberReadable(obj, Strings.toJavaString(stringKey)) || !JSONStringifyStringNode.isStringifyable(strPPrepared = this.prepareJSONPropertyValue(data, stringKey, obj, memberValue = JSONStringifyStringNode.truffleRead(obj, stringKey)))) continue;
                if (isFirst) {
                    this.concatFirstStep(sb, data);
                    isFirst = false;
                } else {
                    this.appendSeparator(sb, data, indent);
                }
                this.jsonQuote(sb, stringKey);
                this.appendColon(sb, data);
                this.serializeJSONPropertyValue(sb, data, strPPrepared);
            }
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(obj, e, "SerializeJSONObject", this);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private TruffleStringBuilder serializeJSONArray(TruffleStringBuilderUTF16 sb, JSONData data, Object value) {
        long length;
        Object lenObject;
        assert (JSRuntime.isArray(value)) : value;
        JSONStringifyStringNode.checkCycle(data, value);
        data.pushStack(value);
        JSONStringifyStringNode.checkStackDepth(data);
        int stepback = data.getIndent();
        int indent = data.getIndent() + 1;
        data.setIndent(indent);
        boolean isForeign = false;
        boolean isArray = false;
        if (JSObject.isJSObject(value)) {
            lenObject = JSObject.get((JSDynamicObject)((JSObject)value), JSArray.LENGTH);
            if (JSArray.isJSArray(value)) {
                isArray = true;
            }
        } else {
            lenObject = this.truffleGetSize(value);
            isForeign = true;
        }
        if ((length = JSRuntime.toLength(lenObject)) > (long)this.stringBuilderProfile.getStringLengthLimit()) {
            throw Errors.createRangeErrorInvalidStringLength();
        }
        int len = (int)length;
        this.concatStart(sb, '[');
        for (int index = 0; index < len; ++index) {
            if (index == 0) {
                this.concatFirstStep(sb, data);
            } else {
                this.appendSeparator(sb, data, indent);
            }
            Object strPPrepared = isArray ? this.getPreparedJSONPropertyValueFromJSArray(data, index, (JSObject)value) : (isForeign ? this.getPreparedJSONPropertyValueFromForeignArray(data, index, value) : this.getPreparedJSONPropertyValue(data, Strings.fromInt(index), value));
            if (JSONStringifyStringNode.isStringifyable(strPPrepared)) {
                this.serializeJSONPropertyValue(sb, data, strPPrepared);
                continue;
            }
            this.append(sb, Null.NAME);
        }
        this.concatEnd(sb, data, stepback, ']', len > 0);
        data.popStack();
        data.setIndent(stepback);
        return sb;
    }

    private static void checkStackDepth(JSONData data) {
        if (data.stackTooDeep()) {
            JSONStringifyStringNode.throwStackError();
        }
    }

    private static void throwStackError() {
        throw Errors.createRangeError("cannot stringify objects nested that deep");
    }

    private void concatStart(TruffleStringBuilderUTF16 builder, char c) {
        this.append(builder, c);
    }

    private void concatFirstStep(TruffleStringBuilderUTF16 sb, JSONData data) {
        if (Strings.length(data.getGap()) > 0) {
            this.append(sb, '\n');
            for (int i = 0; i < data.getIndent(); ++i) {
                this.append(sb, data.getGap());
            }
        }
    }

    private void concatEnd(TruffleStringBuilderUTF16 sb, JSONData data, int stepback, char close, boolean hasContent) {
        if (Strings.length(data.getGap()) > 0 && hasContent) {
            this.append(sb, '\n');
            for (int i = 0; i < stepback; ++i) {
                this.append(sb, data.getGap());
            }
        }
        this.append(sb, close);
    }

    @CompilerDirectives.TruffleBoundary
    private void appendSeparator(TruffleStringBuilderUTF16 sb, JSONData data, int indent) {
        if (Strings.length(data.getGap()) <= 0) {
            this.append(sb, ',');
        } else {
            this.append(sb, Strings.COMMA_NEWLINE);
            for (int i = 0; i < indent; ++i) {
                this.append(sb, data.getGap());
            }
        }
    }

    private static void checkCycle(JSONData data, Object value) {
        if (data.stack.contains(value)) {
            throw Errors.createTypeError("Converting circular structure to JSON");
        }
    }

    private TruffleStringBuilder jsonQuote(TruffleStringBuilderUTF16 builder, TruffleString valueStr) {
        return JSONStringifyStringNode.jsonQuote(this.stringBuilderProfile, builder, valueStr, TruffleString.ReadCharUTF16Node.getUncached(), TruffleStringBuilder.AppendCharUTF16Node.getUncached(), TruffleStringBuilder.AppendStringNode.getUncached(), TruffleStringBuilder.AppendSubstringByteIndexNode.getUncached());
    }

    public static TruffleStringBuilder jsonQuote(StringBuilderProfile stringBuilderProfile, TruffleStringBuilderUTF16 sb, TruffleString valueStr, TruffleString.ReadCharUTF16Node readCharNode, TruffleStringBuilder.AppendCharUTF16Node appendCharNode, TruffleStringBuilder.AppendStringNode appendStringNode, TruffleStringBuilder.AppendSubstringByteIndexNode appendSubstringNode) {
        int pos;
        stringBuilderProfile.append(appendCharNode, sb, '\"');
        int length = Strings.length(valueStr);
        if (valueStr.getCodeRangeImpreciseUncached(TruffleString.Encoding.UTF_16).isSubsetOf(TruffleString.CodeRange.BMP)) {
            char ch;
            for (pos = 0; pos < length && (ch = Strings.charAt(readCharNode, valueStr, pos)) >= ' ' && ch != '\"' && ch != '\\'; ++pos) {
                assert (!Character.isSurrogate(ch));
            }
            if (pos == length) {
                stringBuilderProfile.append(appendStringNode, sb, valueStr);
            } else if (pos > 0) {
                stringBuilderProfile.appendLen(appendSubstringNode, sb, valueStr, 0, pos);
            }
        }
        if (pos < length) {
            JSONStringifyStringNode.jsonQuoteWithEscape(stringBuilderProfile, sb, valueStr, pos, readCharNode, appendCharNode, appendStringNode);
        }
        stringBuilderProfile.append(appendCharNode, sb, '\"');
        return sb;
    }

    private static void jsonQuoteWithEscape(StringBuilderProfile stringBuilderProfile, TruffleStringBuilderUTF16 sb, TruffleString valueStr, int startPos, TruffleString.ReadCharUTF16Node readCharNode, TruffleStringBuilder.AppendCharUTF16Node appendCharNode, TruffleStringBuilder.AppendStringNode appendStringNode) {
        int length = Strings.length(valueStr);
        for (int i = startPos; i < length; ++i) {
            char ch = Strings.charAt(readCharNode, valueStr, i);
            if (ch < ' ') {
                if (ch == '\b') {
                    stringBuilderProfile.append(appendStringNode, sb, Strings.BACKSLASH_B);
                    continue;
                }
                if (ch == '\f') {
                    stringBuilderProfile.append(appendStringNode, sb, Strings.BACKSLASH_F);
                    continue;
                }
                if (ch == '\n') {
                    stringBuilderProfile.append(appendStringNode, sb, Strings.BACKSLASH_N);
                    continue;
                }
                if (ch == '\r') {
                    stringBuilderProfile.append(appendStringNode, sb, Strings.BACKSLASH_R);
                    continue;
                }
                if (ch == '\t') {
                    stringBuilderProfile.append(appendStringNode, sb, Strings.BACKSLASH_T);
                    continue;
                }
                JSONStringifyStringNode.jsonQuoteUnicode(stringBuilderProfile, sb, ch, appendCharNode, appendStringNode);
                continue;
            }
            if (ch == '\\') {
                stringBuilderProfile.append(appendStringNode, sb, Strings.BACKSLASH_BACKSLASH);
                continue;
            }
            if (ch == '\"') {
                stringBuilderProfile.append(appendStringNode, sb, Strings.BACKSLASH_DOUBLE_QUOTE);
                continue;
            }
            if (Character.isSurrogate(ch)) {
                if (Character.isHighSurrogate(ch)) {
                    char nextCh;
                    if (i + 1 < length && Character.isLowSurrogate(nextCh = Strings.charAt(readCharNode, valueStr, i + 1))) {
                        stringBuilderProfile.append(appendCharNode, sb, ch);
                        stringBuilderProfile.append(appendCharNode, sb, nextCh);
                        ++i;
                        continue;
                    }
                } else assert (Character.isLowSurrogate(ch));
                JSONStringifyStringNode.jsonQuoteSurrogate(stringBuilderProfile, sb, ch, appendCharNode, appendStringNode);
                continue;
            }
            stringBuilderProfile.append(appendCharNode, sb, ch);
        }
    }

    private static void jsonQuoteUnicode(StringBuilderProfile stringBuilderProfile, TruffleStringBuilderUTF16 sb, char c, TruffleStringBuilder.AppendCharUTF16Node appendCharNode, TruffleStringBuilder.AppendStringNode appendStringNode) {
        stringBuilderProfile.append(appendStringNode, sb, Strings.BACKSLASH_U00);
        stringBuilderProfile.append(appendCharNode, sb, Character.forDigit(c >> 4 & 0xF, 16));
        stringBuilderProfile.append(appendCharNode, sb, Character.forDigit(c & 0xF, 16));
    }

    private static void jsonQuoteSurrogate(StringBuilderProfile stringBuilderProfile, TruffleStringBuilderUTF16 sb, char c, TruffleStringBuilder.AppendCharUTF16Node appendCharNode, TruffleStringBuilder.AppendStringNode appendStringNode) {
        stringBuilderProfile.append(appendStringNode, sb, Strings.BACKSLASH_UD);
        stringBuilderProfile.append(appendCharNode, sb, Character.forDigit(c >> 8 & 0xF, 16));
        stringBuilderProfile.append(appendCharNode, sb, Character.forDigit(c >> 4 & 0xF, 16));
        stringBuilderProfile.append(appendCharNode, sb, Character.forDigit(c & 0xF, 16));
    }

    private Object truffleGetSize(Object obj) {
        return JSInteropUtil.getArraySize(obj, InteropLibrary.getUncached(), this);
    }

    private static Object truffleRead(Object obj, TruffleString keyStr) {
        return JSInteropUtil.readMemberOrDefault(obj, keyStr, Undefined.instance);
    }

    private static Object truffleRead(Object obj, int index) {
        return JSInteropUtil.readArrayElementOrDefault(obj, index, Undefined.instance);
    }

    private void append(TruffleStringBuilderUTF16 sb, TruffleString s) {
        this.stringBuilderProfile.append(TruffleStringBuilder.AppendStringNode.getUncached(), sb, s);
    }

    private void append(TruffleStringBuilderUTF16 sb, char value) {
        this.stringBuilderProfile.append(TruffleStringBuilder.AppendCharUTF16Node.getUncached(), sb, value);
    }

    private void append(TruffleStringBuilderUTF16 sb, int value) {
        this.stringBuilderProfile.append(TruffleStringBuilder.AppendIntNumberNode.getUncached(), sb, value);
    }

    private void append(TruffleStringBuilderUTF16 sb, long value) {
        this.stringBuilderProfile.append(TruffleStringBuilder.AppendLongNumberNode.getUncached(), sb, value);
    }

    private TruffleString builderToString(TruffleStringBuilderUTF16 sb) {
        return StringBuilderProfile.toString(this.builderToStringNode, sb);
    }
}

