/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.intl;

import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.intl.ListFormatPrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSStringListFromIterableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSListFormat;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSListFormatObject;

public final class ListFormatPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<ListFormatPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new ListFormatPrototypeBuiltins();

    protected ListFormatPrototypeBuiltins() {
        super(JSListFormat.PROTOTYPE_NAME, ListFormatPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ListFormatPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return ListFormatPrototypeBuiltinsFactory.JSListFormatResolvedOptionsNodeGen.create(context, builtin, ListFormatPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: {
                return ListFormatPrototypeBuiltinsFactory.JSListFormatFormatNodeGen.create(context, builtin, ListFormatPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return ListFormatPrototypeBuiltinsFactory.JSListFormatFormatToPartsNodeGen.create(context, builtin, ListFormatPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum ListFormatPrototype implements BuiltinEnum<ListFormatPrototype>
    {
        resolvedOptions(0),
        format(1),
        formatToParts(1);

        private final int length;

        private ListFormatPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class JSListFormatResolvedOptionsNode
    extends JSBuiltinNode {
        public JSListFormatResolvedOptionsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doResolvedOptions(JSListFormatObject listFormat) {
            return JSListFormat.resolvedOptions(this.getContext(), this.getRealm(), listFormat);
        }

        @Fallback
        public Object throwTypeError(Object bummer) {
            throw Errors.createTypeErrorTypeXExpected(JSListFormat.CLASS_NAME);
        }
    }

    public static abstract class JSListFormatFormatNode
    extends JSBuiltinNode {
        public JSListFormatFormatNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public TruffleString doFormat(JSListFormatObject listFormat, Object value, @Cached(value="create(getContext())") JSStringListFromIterableNode strListFromIterableNode) {
            List<String> list = strListFromIterableNode.executeIterable(value);
            return JSListFormat.format(listFormat, list);
        }

        @Fallback
        public Object throwTypeError(Object bummer, Object value) {
            throw Errors.createTypeErrorTypeXExpected(JSListFormat.CLASS_NAME);
        }
    }

    public static abstract class JSListFormatFormatToPartsNode
    extends JSBuiltinNode {
        public JSListFormatFormatToPartsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doFormatToParts(JSListFormatObject listFormat, Object value, @Cached(value="create(getContext())") JSStringListFromIterableNode strListFromIterableNode) {
            List<String> list = strListFromIterableNode.executeIterable(value);
            return JSListFormat.formatToParts(this.getContext(), this.getRealm(), listFormat, list);
        }

        @Fallback
        public Object throwTypeError(Object bummer, Object value) {
            throw Errors.createTypeErrorTypeXExpected(JSListFormat.CLASS_NAME);
        }
    }
}

