/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.intl;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.intl.DurationFormatPrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalDurationRecordNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSDurationFormat;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSDurationFormatObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;

public final class DurationFormatPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<DurationFormatPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new DurationFormatPrototypeBuiltins();

    protected DurationFormatPrototypeBuiltins() {
        super(JSDurationFormat.PROTOTYPE_NAME, DurationFormatPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, DurationFormatPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return DurationFormatPrototypeBuiltinsFactory.JSDurationFormatResolvedOptionsNodeGen.create(context, builtin, DurationFormatPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: {
                return DurationFormatPrototypeBuiltinsFactory.JSDurationFormatFormatNodeGen.create(context, builtin, DurationFormatPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return DurationFormatPrototypeBuiltinsFactory.JSDurationFormatFormatToPartsNodeGen.create(context, builtin, DurationFormatPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum DurationFormatPrototype implements BuiltinEnum<DurationFormatPrototype>
    {
        resolvedOptions(0),
        format(1),
        formatToParts(1);

        private final int length;

        private DurationFormatPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class JSDurationFormatResolvedOptionsNode
    extends JSBuiltinNode {
        public JSDurationFormatResolvedOptionsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object resolvedOptions(JSDurationFormatObject durationFormat) {
            return JSDurationFormat.resolvedOptions(this.getContext(), this.getRealm(), durationFormat);
        }

        @Fallback
        public Object throwTypeError(Object bummer) {
            throw Errors.createTypeErrorTypeXExpected(JSDurationFormat.CLASS_NAME);
        }
    }

    public static abstract class JSDurationFormatFormatNode
    extends JSBuiltinNode {
        public JSDurationFormatFormatNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public TruffleString format(JSDurationFormatObject durationFormat, Object duration, @Cached ToTemporalDurationRecordNode toTemporalDurationRecord, @Cached TruffleString.FromJavaStringNode fromJavaString) {
            JSTemporalDurationRecord record = toTemporalDurationRecord.execute(duration);
            String result = JSDurationFormat.format(durationFormat.getInternalState(), record);
            return Strings.fromJavaString(fromJavaString, result);
        }

        @Fallback
        public TruffleString throwTypeError(Object bummer, Object value) {
            throw Errors.createTypeErrorTypeXExpected(JSDurationFormat.CLASS_NAME);
        }
    }

    public static abstract class JSDurationFormatFormatToPartsNode
    extends JSBuiltinNode {
        public JSDurationFormatFormatToPartsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object formatToParts(JSDurationFormatObject durationFormat, Object duration, @Cached ToTemporalDurationRecordNode toTemporalDurationRecord) {
            JSTemporalDurationRecord record = toTemporalDurationRecord.execute(duration);
            return JSDurationFormat.formatToParts(this.getContext(), this.getRealm(), durationFormat.getInternalState(), record);
        }

        @Fallback
        public Object throwTypeError(Object bummer, Object duration) {
            throw Errors.createTypeErrorTypeXExpected(JSDurationFormat.CLASS_NAME);
        }
    }
}

