/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.helper;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateUncached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;

@ImportStatic(value={JSConfig.class})
@GenerateUncached
public abstract class JSCollectionsNormalizeNode
extends JavaScriptBaseNode {
    public abstract Object execute(Object var1);

    @NeverDefault
    public static JSCollectionsNormalizeNode create() {
        return JSCollectionsNormalizeNodeGen.create();
    }

    @Specialization
    static int doInt(int value) {
        return value;
    }

    @Specialization
    static Object doDouble(double value) {
        return JSSet.normalizeDouble(value);
    }

    @Specialization
    static TruffleString doString(TruffleString value) {
        return value;
    }

    @Specialization
    static boolean doBoolean(boolean value) {
        return value;
    }

    @Specialization
    static Object doDynamicObject(JSDynamicObject object) {
        return object;
    }

    @Specialization
    static Symbol doSymbol(Symbol value) {
        return value;
    }

    @Specialization
    static BigInt doBigInt(BigInt value) {
        return value;
    }

    @Specialization
    static Object doLong(long value) {
        if (JSRuntime.longFitsInDouble(value)) {
            return JSCollectionsNormalizeNode.doDouble(value);
        }
        return BigInt.valueOf(value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isForeignObject(value)"}, limit="InteropLibraryLimit")
    final Object doForeignObject(Object value, @CachedLibrary(value="value") InteropLibrary interop) {
        if (interop.isNull(value)) {
            return Null.instance;
        }
        try {
            if (interop.isBoolean(value)) {
                return JSCollectionsNormalizeNode.doBoolean(interop.asBoolean(value));
            }
            if (interop.isString(value)) {
                return JSCollectionsNormalizeNode.doString(interop.asTruffleString(value));
            }
            if (interop.isNumber(value)) {
                if (interop.fitsInInt(value)) {
                    return JSCollectionsNormalizeNode.doInt(interop.asInt(value));
                }
                if (interop.fitsInDouble(value)) {
                    return JSCollectionsNormalizeNode.doDouble(interop.asDouble(value));
                }
                if (interop.fitsInLong(value)) {
                    return JSCollectionsNormalizeNode.doLong(interop.asLong(value));
                }
                if (interop.fitsInBigInteger(value)) {
                    return JSCollectionsNormalizeNode.doBigInt(BigInt.fromBigInteger(interop.asBigInteger(value)));
                }
                assert (value instanceof TruffleObject);
                return value;
            }
            return value;
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorUnboxException(value, e, this);
        }
    }
}

