/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.WorkerPrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSWorker;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSWorkerObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicSet;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.Equivalence;

public final class WorkerPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<WorkerPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new WorkerPrototypeBuiltins();

    protected WorkerPrototypeBuiltins() {
        super(JSWorker.PROTOTYPE_NAME, WorkerPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, WorkerPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return WorkerPrototypeBuiltinsFactory.WorkerGetMessageNodeGen.create(context, builtin, WorkerPrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 1: {
                return WorkerPrototypeBuiltinsFactory.WorkerPostMessageNodeGen.create(context, builtin, WorkerPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 2: 
            case 3: {
                return WorkerPrototypeBuiltinsFactory.WorkerTerminateNodeGen.create(context, builtin, WorkerPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum WorkerPrototype implements BuiltinEnum<WorkerPrototype>
    {
        getMessage(0),
        postMessage(0),
        terminate(0),
        terminateAndWait(0);

        private final int length;

        private WorkerPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    @ImportStatic(value={JSWorker.class})
    public static abstract class WorkerGetMessageNode
    extends JSBuiltinNode {
        public WorkerGetMessageNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doWorker(JSWorkerObject thisObj) {
            return thisObj.getAgent().getOutMessage(this.getRealm());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isJSWorker(thisObj)"})
        protected Object invalidReceiver(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }

    @ImportStatic(value={JSWorker.class})
    public static abstract class WorkerPostMessageNode
    extends JSBuiltinNode {
        public WorkerPostMessageNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object doWorker(JSWorkerObject thisObj, Object message, Object transfer) {
            EconomicSet<JSArrayBufferObject> transferSet;
            if (transfer == Undefined.instance) {
                transferSet = null;
            } else if (transfer instanceof JSArrayObject) {
                JSArrayObject array = (JSArrayObject)transfer;
                long length = JSAbstractArray.arrayGetLength(array);
                if (length >= Integer.MAX_VALUE) {
                    throw Errors.createRangeErrorInvalidArrayLength(this);
                }
                int lengthInt = (int)length;
                transferSet = EconomicSet.create(Equivalence.IDENTITY, lengthInt);
                for (int i = 0; i < lengthInt; ++i) {
                    Object transferable = JSObject.get((JSDynamicObject)array, i);
                    if (transferable instanceof JSArrayBufferObject) {
                        JSArrayBufferObject arrayBuffer = (JSArrayBufferObject)transferable;
                        if (transferSet.add(arrayBuffer)) continue;
                        throw Errors.createError("ArrayBuffer occurs in the transfer array more than once");
                    }
                    throw Errors.createError("Transfer array elements must be an ArrayBuffer");
                }
            } else {
                throw Errors.createError("Transfer list must be an Array or undefined");
            }
            thisObj.getAgent().postInMessage(message, transferSet);
            return Undefined.instance;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isJSWorker(thisObj)"})
        protected Object invalidReceiver(Object thisObj, Object message, Object transfer) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }

    @ImportStatic(value={JSWorker.class})
    public static abstract class WorkerTerminateNode
    extends JSBuiltinNode {
        public WorkerTerminateNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doWorker(JSWorkerObject thisObj) {
            thisObj.getAgent().terminate();
            return Undefined.instance;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isJSWorker(thisObj)"})
        protected Object invalidReceiver(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }
}

