/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import java.util.Map;
import java.util.WeakHashMap;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DynamicObjectLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.WeakMapPrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.helper.CanBeHeldWeaklyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.IsCallableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSWeakMap;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSWeakMapObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.WeakMap;

public final class WeakMapPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<WeakMapPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new WeakMapPrototypeBuiltins();

    protected WeakMapPrototypeBuiltins() {
        super(JSWeakMap.PROTOTYPE_NAME, WeakMapPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, WeakMapPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return WeakMapPrototypeBuiltinsFactory.JSWeakMapDeleteNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 1: {
                return WeakMapPrototypeBuiltinsFactory.JSWeakMapSetNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 2: {
                return WeakMapPrototypeBuiltinsFactory.JSWeakMapGetNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 3: {
                return WeakMapPrototypeBuiltinsFactory.JSWeakMapHasNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 4: {
                return WeakMapPrototypeBuiltinsFactory.WeakMapGetOrInsertNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 5: {
                return WeakMapPrototypeBuiltinsFactory.WeakMapGetOrInsertComputedNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    protected static RuntimeException typeErrorKeyIsNotValid() {
        throw Errors.createTypeError("Invalid value used as weak map key");
    }

    protected static RuntimeException typeErrorWeakMapExpected() {
        throw Errors.createTypeError("WeakMap expected");
    }

    protected static Object getInvertedMap(JSObject key, DynamicObjectLibrary library) {
        return library.getOrDefault(key, WeakMap.INVERTED_WEAK_MAP_KEY, null);
    }

    protected static WeakHashMap<WeakMap, Object> castWeakHashMap(Object map) {
        return CompilerDirectives.castExact(map, WeakHashMap.class);
    }

    public static enum WeakMapPrototype implements BuiltinEnum<WeakMapPrototype>
    {
        delete(1),
        set(2),
        get(1),
        has(1),
        getOrInsert(2),
        getOrInsertComputed(2);

        private final int length;

        private WeakMapPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            return switch (this.ordinal()) {
                case 4, 5 -> 17;
                default -> BuiltinEnum.super.getECMAScriptVersion();
            };
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSWeakMapDeleteNode
    extends JSBuiltinNode {
        public JSWeakMapDeleteNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean deleteJSObject(JSWeakMapObject thisObj, JSObject key, @CachedLibrary(limit="PropertyCacheLimit") DynamicObjectLibrary invertedGetter, @Cached @Cached.Shared InlinedConditionProfile hasInvertedProfile) {
            WeakMap map = (WeakMap)thisObj.getWeakHashMap();
            Object inverted = WeakMapPrototypeBuiltins.getInvertedMap(key, invertedGetter);
            if (hasInvertedProfile.profile(this, inverted != null)) {
                WeakHashMap<WeakMap, Object> invertedMap = WeakMapPrototypeBuiltins.castWeakHashMap(inverted);
                return Boundaries.mapRemove(invertedMap, map) != null;
            }
            return false;
        }

        @Specialization(guards={"canBeHeldWeakly.execute(this, key)"})
        protected boolean deleteSymbol(JSWeakMapObject thisObj, Symbol key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly, @Cached @Cached.Shared InlinedConditionProfile hasInvertedProfile) {
            WeakMap map = (WeakMap)thisObj.getWeakHashMap();
            Map<WeakMap, Object> invertedMap = key.getInvertedMap();
            if (hasInvertedProfile.profile(this, invertedMap != null)) {
                return Boundaries.mapRemove(invertedMap, map) != null;
            }
            return false;
        }

        @Specialization(guards={"!canBeHeldWeakly.execute(this, key)"})
        protected static boolean deleteInvalidKey(JSWeakMapObject thisObj, Object key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            return false;
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static boolean notWeakMap(Object thisObj, Object key) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }
    }

    public static abstract class JSWeakMapSetNode
    extends JSBuiltinNode {
        public JSWeakMapSetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object weakMap(JSWeakMapObject thisObj, Object key, Object value, @Cached WeakMapSetHelperNode setNode) {
            return setNode.execute(thisObj, key, value);
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static Object notWeakMap(Object thisObj, Object key, Object value) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }
    }

    public static abstract class JSWeakMapGetNode
    extends JSBuiltinNode {
        public JSWeakMapGetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object weakMap(JSWeakMapObject thisObj, Object key, @Cached WeakMapGetHelperNode getNode) {
            return JSRuntime.nullToUndefined(getNode.execute(thisObj, key));
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static Object notWeakMap(Object thisObj, Object key) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSWeakMapHasNode
    extends JSBuiltinNode {
        public JSWeakMapHasNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean hasJSObject(JSWeakMapObject thisObj, JSObject key, @CachedLibrary(limit="PropertyCacheLimit") DynamicObjectLibrary invertedGetter, @Cached @Cached.Shared InlinedConditionProfile hasInvertedProfile) {
            WeakMap map = (WeakMap)thisObj.getWeakHashMap();
            Object inverted = WeakMapPrototypeBuiltins.getInvertedMap(key, invertedGetter);
            if (hasInvertedProfile.profile(this, inverted != null)) {
                WeakHashMap<WeakMap, Object> invertedMap = WeakMapPrototypeBuiltins.castWeakHashMap(inverted);
                return JSWeakMapHasNode.mapHas(invertedMap, map);
            }
            return false;
        }

        @Specialization(guards={"canBeHeldWeakly.execute(this, key)"})
        protected boolean hasSymbol(JSWeakMapObject thisObj, Symbol key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly, @Cached @Cached.Shared InlinedConditionProfile hasInvertedProfile) {
            WeakMap map = (WeakMap)thisObj.getWeakHashMap();
            Map<WeakMap, Object> invertedMap = key.getInvertedMap();
            if (hasInvertedProfile.profile(this, invertedMap != null)) {
                return Boundaries.mapContainsKey(invertedMap, map);
            }
            return false;
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static boolean mapHas(WeakHashMap<WeakMap, Object> invertedMap, WeakMap map) {
            return invertedMap.containsKey(map);
        }

        @Specialization(guards={"!canBeHeldWeakly.execute(this, key)"})
        protected static boolean hasInvalidKey(JSWeakMapObject thisObj, Object key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            return false;
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static boolean notWeakMap(Object thisObj, Object key) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }
    }

    public static abstract class WeakMapGetOrInsertNode
    extends JSBuiltinNode {
        public WeakMapGetOrInsertNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object weakMap(JSWeakMapObject thisObj, Object key, Object value, @Cached WeakMapGetHelperNode getNode, @Cached WeakMapSetHelperNode setNode) {
            Object current = getNode.execute(thisObj, key);
            if (current == null) {
                setNode.execute(thisObj, key, value);
                return value;
            }
            return current;
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static Object notWeakMap(Object thisObj, Object key, Object value) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }
    }

    public static abstract class WeakMapGetOrInsertComputedNode
    extends JSBuiltinNode {
        public WeakMapGetOrInsertComputedNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object weakMap(JSWeakMapObject thisObj, Object key, Object callbackfn, @Cached IsCallableNode isCallable, @Cached WeakMapGetHelperNode getNode, @Cached(value="createCall()") JSFunctionCallNode callNode, @Cached WeakMapSetHelperNode setNode, @Cached InlinedBranchProfile errorBranch) {
            if (!isCallable.executeBoolean(callbackfn)) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorCallableExpected();
            }
            Object current = getNode.execute(thisObj, key);
            if (current == null) {
                Object value = callNode.executeCall(JSArguments.createOneArg(Undefined.instance, callbackfn, key));
                setNode.execute(thisObj, key, value);
                return value;
            }
            return current;
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static Object notWeakMap(Object thisObj, Object key, Object callbackfn) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class WeakMapSetHelperNode
    extends JavaScriptBaseNode {
        public abstract Object execute(JSWeakMapObject var1, Object var2, Object var3);

        @Specialization
        protected Object setJSObject(JSWeakMapObject thisObj, JSObject key, Object value, @CachedLibrary(limit="PropertyCacheLimit") DynamicObjectLibrary invertedGetter, @CachedLibrary(limit="PropertyCacheLimit") DynamicObjectLibrary invertedSetter, @Cached @Cached.Shared InlinedConditionProfile hasInvertedProfile) {
            WeakMap map = (WeakMap)thisObj.getWeakHashMap();
            Object inverted = WeakMapPrototypeBuiltins.getInvertedMap(key, invertedGetter);
            if (hasInvertedProfile.profile(this, inverted != null)) {
                WeakHashMap<WeakMap, Object> invertedMap = WeakMapPrototypeBuiltins.castWeakHashMap(inverted);
                WeakMapSetHelperNode.mapPut(invertedMap, map, value);
            } else {
                Map<WeakMap, Object> newInvertedMap = map.newInvertedMapWithEntry(key, value);
                invertedSetter.put(key, WeakMap.INVERTED_WEAK_MAP_KEY, newInvertedMap);
            }
            return thisObj;
        }

        @Specialization(guards={"canBeHeldWeakly.execute(this, key)"})
        protected Object setSymbol(JSWeakMapObject thisObj, Symbol key, Object value, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly, @Cached @Cached.Shared InlinedConditionProfile hasInvertedProfile) {
            WeakMap map = (WeakMap)thisObj.getWeakHashMap();
            Map<WeakMap, Object> invertedMap = key.getInvertedMap();
            if (hasInvertedProfile.profile(this, invertedMap != null)) {
                Boundaries.mapPut(invertedMap, map, value);
            } else {
                Map<WeakMap, Object> newInvertedMap = map.newInvertedMapWithEntry(key, value);
                key.setInvertedMap(newInvertedMap);
            }
            return thisObj;
        }

        @Specialization(guards={"!canBeHeldWeakly.execute(this, key)"})
        protected static Object setInvalidKey(JSWeakMapObject thisObj, Object key, Object value, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            throw WeakMapPrototypeBuiltins.typeErrorKeyIsNotValid();
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static Object mapPut(WeakHashMap<WeakMap, Object> invertedMap, WeakMap map, Object value) {
            return invertedMap.put(map, value);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class WeakMapGetHelperNode
    extends JavaScriptBaseNode {
        public abstract Object execute(JSWeakMapObject var1, Object var2);

        @Specialization
        protected Object getJSObject(JSWeakMapObject thisObj, JSObject key, @CachedLibrary(limit="PropertyCacheLimit") DynamicObjectLibrary invertedGetter, @Cached @Cached.Shared InlinedConditionProfile hasInvertedProfile) {
            WeakMap map = (WeakMap)thisObj.getWeakHashMap();
            Object inverted = WeakMapPrototypeBuiltins.getInvertedMap(key, invertedGetter);
            if (hasInvertedProfile.profile(this, inverted != null)) {
                WeakHashMap<WeakMap, Object> invertedMap = WeakMapPrototypeBuiltins.castWeakHashMap(inverted);
                return WeakMapGetHelperNode.mapGet(invertedMap, map);
            }
            return null;
        }

        @Specialization(guards={"canBeHeldWeakly.execute(this, key)"})
        protected Object getSymbol(JSWeakMapObject thisObj, Symbol key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly, @Cached @Cached.Shared InlinedConditionProfile hasInvertedProfile) {
            WeakMap map = (WeakMap)thisObj.getWeakHashMap();
            Map<WeakMap, Object> invertedMap = key.getInvertedMap();
            if (hasInvertedProfile.profile(this, invertedMap != null)) {
                return Boundaries.mapGet(invertedMap, map);
            }
            return null;
        }

        @Specialization(guards={"!canBeHeldWeakly.execute(this, key)"})
        protected static Object getInvalidKey(JSWeakMapObject thisObj, Object key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            return null;
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static Object mapGet(WeakHashMap<WeakMap, Object> invertedMap, WeakMap map) {
            return invertedMap.get(map);
        }
    }
}

