/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.Uint8ArrayBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.TypedArrayLengthNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetBooleanOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetOptionsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public final class Uint8ArrayBuiltins {
    public static final JSBuiltinsContainer PROTOTYPE_BUILTINS = JSBuiltinsContainer.fromEnum(JSArrayBufferView.UINT8ARRAY_PROTOTYPE_NAME, Uint8ArrayPrototype.class);
    public static final JSBuiltinsContainer CONSTRUCTOR_BUILTINS = JSBuiltinsContainer.fromEnum(JSArrayBufferView.UINT8ARRAY_CONSTRUCTOR_NAME, Uint8ArrayConstructor.class);

    private Uint8ArrayBuiltins() {
    }

    public static enum Uint8ArrayPrototype implements BuiltinEnum<Uint8ArrayPrototype>
    {
        toBase64(0),
        toHex(0),
        setFromBase64(1),
        setFromHex(1);

        private final int functionLength;

        private Uint8ArrayPrototype(int length) {
            this.functionLength = length;
        }

        @Override
        public int getLength() {
            return this.functionLength;
        }

        @Override
        public int getECMAScriptVersion() {
            return 17;
        }

        @Override
        public Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget) {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> Uint8ArrayBuiltinsFactory.ToBase64NodeGen.create(context, builtin, this.args().withThis().fixedArgs(1).createArgumentNodes(context));
                case 1 -> Uint8ArrayBuiltinsFactory.ToHexNodeGen.create(context, builtin, this.args().withThis().createArgumentNodes(context));
                case 2 -> Uint8ArrayBuiltinsFactory.SetFromBase64NodeGen.create(context, builtin, this.args().withThis().fixedArgs(2).createArgumentNodes(context));
                case 3 -> Uint8ArrayBuiltinsFactory.SetFromHexNodeGen.create(context, builtin, this.args().withThis().fixedArgs(1).createArgumentNodes(context));
            };
        }
    }

    public static enum Uint8ArrayConstructor implements BuiltinEnum<Uint8ArrayConstructor>
    {
        fromBase64(1),
        fromHex(1);

        private final int functionLength;

        private Uint8ArrayConstructor(int length) {
            this.functionLength = length;
        }

        @Override
        public int getLength() {
            return this.functionLength;
        }

        @Override
        public int getECMAScriptVersion() {
            return 17;
        }

        @Override
        public Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget) {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> Uint8ArrayBuiltinsFactory.Uint8ArrayFromBase64NodeGen.create(context, builtin, this.args().fixedArgs(2).createArgumentNodes(context));
                case 1 -> Uint8ArrayBuiltinsFactory.Uint8ArrayFromHexNodeGen.create(context, builtin, this.args().fixedArgs(1).createArgumentNodes(context));
            };
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class ToHexNode
    extends Uint8ArrayBaseNode {
        protected ToHexNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        private static byte hexDigit(int digit) {
            assert ((digit & 0xF) == digit);
            return (byte)(digit >= 10 ? 87 + digit : 48 + digit);
        }

        @Specialization(guards={"isUint8Array(thisObj)"})
        protected final TruffleString doUint8Array(JSTypedArrayObject thisObj, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            byte[] buffer = this.getUint8ArrayBytes(thisObj, interop);
            if (buffer.length > 0x3FFFFFFB) {
                this.errorBranch.enter();
                throw Errors.createRangeErrorInvalidArrayLength(this);
            }
            byte[] hex = new byte[buffer.length * 2];
            for (int i = 0; i < buffer.length; ++i) {
                byte b = buffer[i];
                hex[i * 2] = ToHexNode.hexDigit(b >>> 4 & 0xF);
                hex[i * 2 + 1] = ToHexNode.hexDigit(b & 0xF);
            }
            return switchEncodingNode.execute(fromByteArrayNode.execute(hex, TruffleString.Encoding.US_ASCII, false), TruffleString.Encoding.UTF_16);
        }

        @Fallback
        protected static Object doNotUint8Array(Object thisObj) {
            throw Errors.createTypeErrorUint8ArrayExpected();
        }
    }

    @ImportStatic(value={Boolean.class, Strings.class, JSConfig.class})
    public static abstract class ToBase64Node
    extends Uint8ArrayBaseNode {
        protected ToBase64Node(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isUint8Array(thisObj)"})
        protected final TruffleString doUint8Array(JSTypedArrayObject thisObj, Object options, @Cached(parameters={"getContext()"}) GetOptionsObjectNode getOptionsObjectNode, @Cached(parameters={"ALPHABET", "getContext()"}) PropertyGetNode getAlphabetNode, @Cached(parameters={"getContext()", "OMIT_PADDING", "FALSE"}) GetBooleanOptionNode getOmitPaddingOptionNode, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached TruffleString.EqualNode equalNode, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            Object opts = getOptionsObjectNode.execute(options);
            TruffleString alphabet = this.getStringOption(opts, Strings.ALPHABET, ALPHABET_VALUES, BASE64, getAlphabetNode, equalNode);
            boolean base64url = Strings.equals(equalNode, alphabet, BASE64URL);
            boolean omitPadding = getOmitPaddingOptionNode.executeValue(opts);
            byte[] bytes = this.getUint8ArrayBytes(thisObj, interop);
            String result = ToBase64Node.base64EncodeToString(bytes, base64url, omitPadding);
            return Strings.fromJavaString(fromJavaStringNode, result);
        }

        @CompilerDirectives.TruffleBoundary
        private static String base64EncodeToString(byte[] bytes, boolean base64url, boolean omitPadding) {
            Base64.Encoder encoder;
            Base64.Encoder encoder2 = encoder = base64url ? Base64.getUrlEncoder() : Base64.getEncoder();
            if (omitPadding) {
                encoder = encoder.withoutPadding();
            }
            return encoder.encodeToString(bytes);
        }

        @Fallback
        protected static Object doNotUint8Array(Object thisObj, Object options) {
            throw Errors.createTypeErrorUint8ArrayExpected();
        }
    }

    public static abstract class Uint8ArrayFromHexNode
    extends Uint8ArrayBaseNode {
        protected Uint8ArrayFromHexNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final JSObject doString(TruffleString string, @Cached(parameters={"getContext()", "true"}) ArrayPrototypeBuiltins.ArraySpeciesConstructorNode constructTypedArrayNode, @Cached TruffleString.ReadCharUTF16Node charAtNode) {
            Uint8ArrayBaseNode.EncodeResult result = this.fromHex(string, Integer.MAX_VALUE, charAtNode);
            if (result.error() != null) {
                throw result.error();
            }
            int resultLength = result.written();
            JSTypedArrayObject uint8Array = constructTypedArrayNode.typedArrayCreate((Object)this.getRealm().getArrayBufferViewConstructor(TypedArrayFactory.Uint8Array), resultLength);
            this.setUint8ArrayBytes(uint8Array, result.bytes(), resultLength);
            return uint8Array;
        }

        @Fallback
        protected static Object doNotString(Object string) {
            throw Errors.createTypeErrorNotAString(string);
        }
    }

    public static abstract class SetFromHexNode
    extends SetFromBaseNode {
        protected SetFromHexNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isUint8Array(into)"})
        protected final JSObject doUint8Array(JSTypedArrayObject into, TruffleString string, @Cached TruffleString.ReadCharUTF16Node charAtNode) {
            int byteLength = this.getByteLengthOrThrow(into);
            Uint8ArrayBaseNode.EncodeResult result = this.fromHex(string, byteLength, charAtNode);
            assert (!into.getArrayBuffer().isDetached());
            assert (result.written() <= byteLength);
            this.setUint8ArrayBytes(into, result.bytes(), result.written());
            if (result.error() != null) {
                throw result.error();
            }
            return this.createResultObject(result.read(), result.written());
        }

        @Specialization(guards={"isUint8Array(into)", "!isString(string)"})
        protected static Object doNotString(JSTypedArrayObject into, Object string) {
            throw Errors.createTypeErrorNotAString(string);
        }

        @Fallback
        protected static Object doNotUint8Array(Object thisObj, Object string) {
            throw Errors.createTypeErrorUint8ArrayExpected();
        }
    }

    @ImportStatic(value={Strings.class})
    public static abstract class Uint8ArrayFromBase64Node
    extends Uint8ArrayBaseNode {
        protected Uint8ArrayFromBase64Node(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final JSObject doString(TruffleString string, Object options, @Cached(parameters={"getContext()"}) GetOptionsObjectNode getOptionsObjectNode, @Cached(parameters={"ALPHABET", "getContext()"}) PropertyGetNode getAlphabetNode, @Cached(parameters={"LAST_CHUNK_HANDLING", "getContext()"}) PropertyGetNode getLastChunkHandlingNode, @Cached(parameters={"getContext()", "true"}) ArrayPrototypeBuiltins.ArraySpeciesConstructorNode constructTypedArrayNode, @Cached TruffleString.ReadCharUTF16Node charAtNode, @Cached TruffleString.EqualNode equalNode) {
            TruffleString lastChunkHandling;
            Object opts = getOptionsObjectNode.execute(options);
            TruffleString alphabet = this.getStringOption(opts, Strings.ALPHABET, ALPHABET_VALUES, BASE64, getAlphabetNode, equalNode);
            boolean base64url = Strings.equals(equalNode, alphabet, BASE64URL);
            Uint8ArrayBaseNode.EncodeResult result = this.fromBase64(string, base64url, Integer.MAX_VALUE, lastChunkHandling = this.getStringOption(opts, Strings.LAST_CHUNK_HANDLING, LAST_CHUNK_HANDLING_VALUES, LOOSE, getLastChunkHandlingNode, equalNode), charAtNode);
            if (result.error() != null) {
                throw result.error();
            }
            int resultLength = result.written();
            JSTypedArrayObject uint8Array = constructTypedArrayNode.typedArrayCreate((Object)this.getRealm().getArrayBufferViewConstructor(TypedArrayFactory.Uint8Array), resultLength);
            this.setUint8ArrayBytes(uint8Array, result.bytes(), resultLength);
            return uint8Array;
        }

        @Fallback
        protected static Object doNotString(Object string, Object options) {
            throw Errors.createTypeErrorNotAString(string);
        }
    }

    @ImportStatic(value={Strings.class})
    public static abstract class SetFromBase64Node
    extends SetFromBaseNode {
        protected SetFromBase64Node(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isUint8Array(into)"})
        protected final JSObject doUint8Array(JSTypedArrayObject into, TruffleString string, Object options, @Cached(parameters={"getContext()"}) GetOptionsObjectNode getOptionsObjectNode, @Cached(parameters={"ALPHABET", "getContext()"}) PropertyGetNode getAlphabetNode, @Cached(parameters={"LAST_CHUNK_HANDLING", "getContext()"}) PropertyGetNode getLastChunkHandlingNode, @Cached TruffleString.ReadCharUTF16Node charAtNode, @Cached TruffleString.EqualNode equalNode) {
            Object opts = getOptionsObjectNode.execute(options);
            TruffleString alphabet = this.getStringOption(opts, Strings.ALPHABET, ALPHABET_VALUES, BASE64, getAlphabetNode, equalNode);
            boolean base64url = Strings.equals(equalNode, alphabet, BASE64URL);
            TruffleString lastChunkHandling = this.getStringOption(opts, Strings.LAST_CHUNK_HANDLING, LAST_CHUNK_HANDLING_VALUES, LOOSE, getLastChunkHandlingNode, equalNode);
            int byteLength = this.getByteLengthOrThrow(into);
            Uint8ArrayBaseNode.EncodeResult result = this.fromBase64(string, base64url, byteLength, lastChunkHandling, charAtNode);
            assert (!into.getArrayBuffer().isDetached());
            assert (result.written() <= byteLength);
            this.setUint8ArrayBytes(into, result.bytes(), result.written());
            if (result.error() != null) {
                throw result.error();
            }
            return this.createResultObject(result.read(), result.written());
        }

        @Specialization(guards={"isUint8Array(into)", "!isString(string)"})
        protected static Object doNotString(JSTypedArrayObject into, Object string, Object options) {
            throw Errors.createTypeErrorNotAString(string);
        }

        @Fallback
        protected static Object doNotUint8Array(Object thisObj, Object string, Object options) {
            throw Errors.createTypeErrorUint8ArrayExpected();
        }
    }

    public static abstract class SetFromBaseNode
    extends Uint8ArrayBaseNode {
        @Node.Child
        private CreateDataPropertyNode createReadDataPropertyNode;
        @Node.Child
        private CreateDataPropertyNode createWrittenDataPropertyNode;
        @Node.Child
        private InteropLibrary interopLibrary;

        protected SetFromBaseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.createReadDataPropertyNode = CreateDataPropertyNode.create(context, Strings.READ);
            this.createWrittenDataPropertyNode = CreateDataPropertyNode.create(context, Strings.WRITTEN);
        }

        protected final JSObject createResultObject(int readLength, int writtenLength) {
            JSRealm realm = this.getRealm();
            JSObject result = JSOrdinary.create(this.getContext(), realm);
            this.createReadDataPropertyNode.executeVoid(result, readLength);
            this.createWrittenDataPropertyNode.executeVoid(result, writtenLength);
            return result;
        }

        @Override
        protected void setUint8ArrayBytes(JSTypedArrayObject into, byte[] bytes, int resultLength) {
            if (into.getArrayBuffer() instanceof JSArrayBufferObject.Interop) {
                this.setUint8ArrayBytesInterop(into, bytes, resultLength);
            } else {
                super.setUint8ArrayBytes(into, bytes, resultLength);
            }
        }

        private void setUint8ArrayBytesInterop(JSTypedArrayObject into, byte[] bytes, int resultLength) {
            if (this.interopLibrary == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.interopLibrary = this.insert(InteropLibrary.getFactory().createDispatched(5));
            }
            JSInteropUtil.writeBuffer(into.getArrayBuffer(), into.getByteOffset(), bytes, 0, resultLength, this.interopLibrary);
            SetFromBaseNode.reportLoopCount((Node)this, resultLength);
        }
    }

    public static abstract class Uint8ArrayBaseNode
    extends JSBuiltinNode {
        protected static final TruffleString BASE64;
        protected static final TruffleString BASE64URL;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        protected static final TruffleString[] ALPHABET_VALUES;
        protected static final TruffleString LOOSE;
        protected static final TruffleString STRICT;
        protected static final TruffleString STOP_BEFORE_PARTIAL;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        protected static final TruffleString[] LAST_CHUNK_HANDLING_VALUES;
        @Node.Child
        private TypedArrayLengthNode typedArrayLengthNode = TypedArrayLengthNode.create();
        protected final BranchProfile errorBranch = BranchProfile.create();
        private static final String BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        private static final int LOOKUP_TABLE_SIZE = 256;
        private static final byte[] FROM_BASE64_TABLE;
        private static final String HEX_ALPHABET = "0123456789abcdefABCDEF";
        private static final byte[] FROM_HEX_TABLE;

        protected Uint8ArrayBaseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected static boolean isUint8Array(JSTypedArrayObject typedArray) {
            return typedArray.getArrayType().getFactory() == TypedArrayFactory.Uint8Array;
        }

        protected final int getByteLengthOrThrow(JSTypedArrayObject view) {
            if (JSArrayBufferView.isOutOfBounds(view, this.getContext())) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorOutOfBoundsTypedArray();
            }
            return this.typedArrayLengthNode.execute(null, view, this.getContext());
        }

        protected final byte[] getUint8ArrayBytes(JSTypedArrayObject ta, InteropLibrary interop) {
            int byteLength = this.getByteLengthOrThrow(ta);
            byte[] buffer = new byte[byteLength];
            JSInteropUtil.copyFromBuffer(ta.getArrayBuffer(), ta.getByteOffset(), buffer, 0, byteLength, interop);
            Uint8ArrayBaseNode.reportLoopCount((Node)this, byteLength);
            return buffer;
        }

        protected void setUint8ArrayBytes(JSTypedArrayObject into, byte[] bytes, int resultLength) {
            ByteBuffer rawBuffer;
            JSArrayBufferObject arrayBuffer = into.getArrayBuffer();
            if (arrayBuffer instanceof JSArrayBufferObject.Heap) {
                JSArrayBufferObject.Heap heapBuffer = (JSArrayBufferObject.Heap)arrayBuffer;
                rawBuffer = Boundaries.byteBufferWrap(heapBuffer.getByteArray());
            } else {
                rawBuffer = ((JSArrayBufferObject.DirectBase)arrayBuffer).getByteBuffer();
            }
            Boundaries.byteBufferPutArray(rawBuffer, into.getByteOffset(), bytes, 0, resultLength);
            Uint8ArrayBaseNode.reportLoopCount((Node)this, resultLength);
        }

        private int decodeBase64Chunk(byte[] chunk, int chunkLength, byte[] bytes, int bytesBegin, boolean throwOnExtraBits) {
            int resultLength = switch (chunkLength) {
                case 2 -> {
                    chunk[2] = 65;
                    chunk[3] = 65;
                    yield 1;
                }
                case 3 -> {
                    chunk[3] = 65;
                    yield 2;
                }
                default -> {
                    if (!$assertionsDisabled && chunkLength != 4) {
                        throw new AssertionError(chunkLength);
                    }
                    yield 3;
                }
            };
            byte sx0 = FROM_BASE64_TABLE[Byte.toUnsignedInt(chunk[0])];
            byte sx1 = FROM_BASE64_TABLE[Byte.toUnsignedInt(chunk[1])];
            byte sx2 = FROM_BASE64_TABLE[Byte.toUnsignedInt(chunk[2])];
            byte sx3 = FROM_BASE64_TABLE[Byte.toUnsignedInt(chunk[3])];
            assert (sx0 >= 0 && sx1 >= 0 && sx2 >= 0 && sx3 >= 0) : "unexpected character";
            int triplet = sx0 << 18 | sx1 << 12 | sx2 << 6 | sx3;
            byte b0 = (byte)(triplet >>> 16);
            byte b1 = (byte)(triplet >>> 8);
            byte b2 = (byte)triplet;
            if (throwOnExtraBits && (chunkLength == 2 && b1 != 0 || chunkLength == 3 && b2 != 0)) {
                throw this.syntaxError("extra bits");
            }
            bytes[bytesBegin] = b0;
            if (chunkLength > 2) {
                bytes[bytesBegin + 1] = b1;
            }
            if (chunkLength > 3) {
                bytes[bytesBegin + 2] = b2;
            }
            return resultLength;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final EncodeResult fromBase64(TruffleString string, boolean base64url, int maxLength, TruffleString lastChunkHandling, TruffleString.ReadCharUTF16Node charAtNode) {
            assert (lastChunkHandling == LOOSE || lastChunkHandling == STRICT || lastChunkHandling == STOP_BEFORE_PARTIAL);
            boolean throwOnExtraBits = lastChunkHandling == STRICT;
            int chunkLength = 0;
            int index = 0;
            int length = Strings.length(string);
            int read = 0;
            int written = 0;
            byte[] bytes = new byte[Math.min(maxLength, Uint8ArrayBaseNode.estimateDecodedByteLengthFromBase64(string, length, charAtNode))];
            JSException error = null;
            try {
                if (maxLength == 0) return new EncodeResult(read, written, bytes, error);
                byte[] chunk = new byte[4];
                while (true) {
                    if ((index = Uint8ArrayBaseNode.skipAsciiWhitespace(string, index, length, charAtNode)) == length) {
                        if (chunkLength > 0) {
                            assert (chunkLength < 4);
                            if (lastChunkHandling == STOP_BEFORE_PARTIAL) return new EncodeResult(read, written, bytes, error);
                            if (chunkLength == 1) {
                                throw this.syntaxError("unexpected incomplete chunk: only one character");
                            }
                            if (lastChunkHandling == LOOSE) {
                                written += this.decodeBase64Chunk(chunk, chunkLength, bytes, written, false);
                            } else {
                                if ($assertionsDisabled || lastChunkHandling == STRICT) throw this.syntaxError("missing padding");
                                throw new AssertionError(lastChunkHandling);
                            }
                        }
                        read = length;
                        return new EncodeResult(read, written, bytes, error);
                    }
                    int ch = Strings.charAt(charAtNode, string, index);
                    ++index;
                    if (ch == 61) {
                        if (chunkLength < 2) {
                            throw this.syntaxError("padding is too early");
                        }
                        index = Uint8ArrayBaseNode.skipAsciiWhitespace(string, index, length, charAtNode);
                        if (chunkLength == 2) {
                            if (index == length) {
                                if (lastChunkHandling == STOP_BEFORE_PARTIAL) return new EncodeResult(read, written, bytes, error);
                                throw this.syntaxError("malformed padding: only one '='");
                            }
                            ch = Strings.charAt(charAtNode, string, index);
                            if (ch == 61) {
                                index = Uint8ArrayBaseNode.skipAsciiWhitespace(string, index + 1, length, charAtNode);
                            }
                        }
                        if (index < length) {
                            throw this.syntaxError("unexpected character after padding");
                        }
                        written += this.decodeBase64Chunk(chunk, chunkLength, bytes, written, throwOnExtraBits);
                        read = length;
                        return new EncodeResult(read, written, bytes, error);
                    }
                    if (base64url) {
                        if (ch == 43 || ch == 47) {
                            throw this.syntaxError("unexpected character");
                        }
                        if (ch == 45) {
                            ch = 43;
                        } else if (ch == 95) {
                            ch = 47;
                        }
                    }
                    if (ch > FROM_BASE64_TABLE.length || FROM_BASE64_TABLE[ch] < 0) {
                        throw this.syntaxError("unexpected character");
                    }
                    int remaining = maxLength - written;
                    if (remaining == 1 && chunkLength == 2 || remaining == 2 && chunkLength == 3) return new EncodeResult(read, written, bytes, error);
                    chunk[chunkLength++] = (byte)ch;
                    if (chunkLength != 4) continue;
                    written += this.decodeBase64Chunk(chunk, chunkLength, bytes, written, false);
                    chunkLength = 0;
                    read = index;
                    if (written == maxLength) return new EncodeResult(read, written, bytes, error);
                }
            }
            catch (JSException e) {
                error = e;
            }
            return new EncodeResult(read, written, bytes, error);
        }

        protected static int estimateDecodedByteLengthFromBase64(TruffleString src, int len, TruffleString.ReadCharUTF16Node charAtNode) {
            if (len < 2) {
                return 0;
            }
            int decodedLength = 3 * (len / 4);
            if (len % 4 == 0) {
                if (Strings.charAt(charAtNode, src, len - 1) == '=') {
                    --decodedLength;
                    if (Strings.charAt(charAtNode, src, len - 2) == '=') {
                        --decodedLength;
                    }
                }
            } else {
                decodedLength += len % 4 - 1;
            }
            return decodedLength;
        }

        private static int skipAsciiWhitespace(TruffleString string, int start, int len, TruffleString.ReadCharUTF16Node charAtNode) {
            char ch;
            int idx;
            assert (len == Strings.length(string));
            for (idx = start; idx < len && JSRuntime.isAsciiWhitespace(ch = Strings.charAt(charAtNode, string, idx)); ++idx) {
            }
            return idx;
        }

        protected final EncodeResult fromHex(TruffleString string, int maxLength, TruffleString.ReadCharUTF16Node charAtNode) {
            int read;
            int length = Strings.length(string);
            if (length % 2 != 0) {
                throw this.syntaxError("string length not modulo 2");
            }
            byte[] bytes = new byte[Math.min(maxLength, length / 2)];
            int written = 0;
            JSException error = null;
            try {
                if (maxLength != 0) {
                    for (read = 0; read < length && written < maxLength; read += 2) {
                        byte b1;
                        byte b0;
                        char c0 = Strings.charAt(charAtNode, string, read);
                        char c1 = Strings.charAt(charAtNode, string, read + 1);
                        if (c0 > FROM_HEX_TABLE.length || c1 > FROM_HEX_TABLE.length || (b0 = FROM_HEX_TABLE[c0]) < 0 || (b1 = FROM_HEX_TABLE[c1]) < 0) {
                            throw this.syntaxError("unexpected character");
                        }
                        bytes[written++] = (byte)(b0 << 4 | b1);
                    }
                }
            }
            catch (JSException e) {
                error = e;
            }
            return new EncodeResult(read, written, bytes, error);
        }

        protected final JSException syntaxError(String message) {
            this.errorBranch.enter();
            throw Errors.createSyntaxError(message);
        }

        protected final TruffleString getStringOption(Object opts, TruffleString key, TruffleString[] allowedValues, TruffleString defaultValue, PropertyGetNode getOptionValueNode, TruffleString.EqualNode equalNode) {
            CompilerAsserts.partialEvaluationConstant(allowedValues);
            Object value = getOptionValueNode.getValue(opts);
            if (value == Undefined.instance) {
                return defaultValue;
            }
            if (value instanceof TruffleString) {
                TruffleString string = (TruffleString)value;
                for (TruffleString choice : allowedValues) {
                    if (!Strings.equals(equalNode, choice, string)) continue;
                    return choice;
                }
                this.errorBranch.enter();
                throw Uint8ArrayBaseNode.createTypeErrorUnsupportedOptionValue(key, allowedValues);
            }
            this.errorBranch.enter();
            throw Errors.createTypeErrorNotAString(value);
        }

        @CompilerDirectives.TruffleBoundary
        private static JSException createTypeErrorUnsupportedOptionValue(TruffleString name, TruffleString[] allowedValues) {
            return Errors.createTypeError("Expected " + String.valueOf(name) + " option value to be one of " + Arrays.toString(allowedValues));
        }

        static {
            int i;
            BASE64 = Strings.constant("base64");
            BASE64URL = Strings.constant("base64url");
            ALPHABET_VALUES = new TruffleString[]{BASE64, BASE64URL};
            LOOSE = Strings.constant("loose");
            STRICT = Strings.constant("strict");
            STOP_BEFORE_PARTIAL = Strings.constant("stop-before-partial");
            LAST_CHUNK_HANDLING_VALUES = new TruffleString[]{LOOSE, STRICT, STOP_BEFORE_PARTIAL};
            byte[] fromBase64Table = new byte[256];
            Arrays.fill(fromBase64Table, (byte)-1);
            for (i = 0; i < BASE64_ALPHABET.length(); ++i) {
                fromBase64Table[BASE64_ALPHABET.charAt((int)i)] = (byte)i;
            }
            FROM_BASE64_TABLE = fromBase64Table;
            byte[] fromHexTable = new byte[256];
            Arrays.fill(fromHexTable, (byte)-1);
            for (i = 0; i < HEX_ALPHABET.length(); ++i) {
                fromHexTable[HEX_ALPHABET.charAt((int)i)] = (byte)JSRuntime.valueInHex(HEX_ALPHABET.charAt(i));
            }
            FROM_HEX_TABLE = fromHexTable;
        }

        @CompilerDirectives.ValueType
        protected record EncodeResult(int read, int written, byte[] bytes, JSException error) {
        }
    }
}

