/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import java.util.Arrays;
import java.util.Map;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.HiddenKey;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleStringBuilder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleStringIterator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.StringFunctionBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertySetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.ReadElementNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToStringNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToUInt16Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.IsCallableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSFrameUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JavaScriptRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.SimpleArrayList;

public final class StringFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<StringFunction> {
    public static final JSBuiltinsContainer BUILTINS = new StringFunctionBuiltins();

    protected StringFunctionBuiltins() {
        super(JSString.CLASS_NAME, StringFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, StringFunction builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return StringFunctionBuiltinsFactory.JSFromCharCodeNodeGen.create(context, builtin, StringFunctionBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case 1: {
                return StringFunctionBuiltinsFactory.JSFromCodePointNodeGen.create(context, builtin, StringFunctionBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case 2: {
                return StringFunctionBuiltinsFactory.StringRawNodeGen.create(context, builtin, StringFunctionBuiltins.args().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case 3: {
                return StringFunctionBuiltinsFactory.StringDedentNodeGen.create(context, builtin, StringFunctionBuiltins.args().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum StringFunction implements BuiltinEnum<StringFunction>
    {
        fromCharCode(1),
        fromCodePoint(1),
        raw(1),
        dedent(1);

        private final int length;

        private StringFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            return switch (this.ordinal()) {
                case 1 -> 6;
                case 3 -> 17;
                default -> BuiltinEnum.super.getECMAScriptVersion();
            };
        }
    }

    public static abstract class JSFromCharCodeNode
    extends JSBuiltinNode {
        public JSFromCharCodeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"args.length == 0"})
        protected Object fromCharCode(Object[] args) {
            return Strings.EMPTY_STRING;
        }

        @Specialization(guards={"args.length == 1"})
        protected Object fromCharCodeOneArg(Object[] args, @Cached.Shared @Cached JSToUInt16Node toUint16, @Cached TruffleString.FromCodePointNode fromCodePointNode) {
            return Strings.fromCodePoint(fromCodePointNode, toUint16.executeChar(args[0]));
        }

        @Specialization(guards={"args.length >= 2"})
        protected Object fromCharCodeTwoOrMore(Object[] args, @Cached.Shared @Cached JSToUInt16Node toUint16, @Cached TruffleString.FromCharArrayUTF16Node fromCharArrayNode) {
            char[] chars = new char[args.length];
            for (int i = 0; i < args.length; ++i) {
                chars[i] = toUint16.executeChar(args[i]);
            }
            return Strings.fromCharArray(fromCharArrayNode, chars);
        }
    }

    public static abstract class JSFromCodePointNode
    extends JSBuiltinNode {
        public JSFromCodePointNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object fromCodePoint(Object[] args, @Cached JSToNumberNode toNumberNode, @Cached TruffleString.FromCodePointNode fromCodePointNode, @Cached TruffleString.ConcatNode concatNode) {
            TruffleString st = Strings.EMPTY_STRING;
            for (Object arg : args) {
                Number value = toNumberNode.executeNumber(arg);
                double valueDouble = JSRuntime.doubleValue(value);
                int valueInt = JSRuntime.intValue(value);
                if (JSRuntime.isNegativeZero(valueDouble)) {
                    valueInt = 0;
                } else if (!JSRuntime.doubleIsRepresentableAsInt(valueDouble) || valueInt < 0 || 0x10FFFF < valueInt) {
                    JSFromCodePointNode.throwRangeError(value);
                }
                st = Strings.concat(concatNode, st, Strings.fromCodePoint(fromCodePointNode, valueInt));
            }
            return st;
        }

        @CompilerDirectives.TruffleBoundary
        private static void throwRangeError(Number value) {
            throw Errors.createRangeError("Invalid code point " + String.valueOf(value));
        }
    }

    public static abstract class StringRawNode
    extends JSBuiltinNode {
        @Node.Child
        private JSToObjectNode templateToObjectNode = JSToObjectNode.create();
        @Node.Child
        private JSToObjectNode rawToObjectNode = JSToObjectNode.create();
        @Node.Child
        private PropertyGetNode getRawNode;
        @Node.Child
        private JSGetLengthNode getRawLengthNode;
        @Node.Child
        private JSToStringNode segToStringNode;
        @Node.Child
        private JSToStringNode subToStringNode;
        @Node.Child
        private ReadElementNode readRawElementNode;
        @Node.Child
        private TruffleStringBuilder.AppendStringNode appendStringNode;
        @Node.Child
        private TruffleStringBuilder.ToStringNode builderToStringNode;

        public StringRawNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getRawNode = PropertyGetNode.create(Strings.RAW, false, context);
            this.getRawLengthNode = JSGetLengthNode.create(context);
            this.segToStringNode = JSToStringNode.create();
            this.subToStringNode = JSToStringNode.create();
            this.readRawElementNode = ReadElementNode.create(context);
            this.appendStringNode = TruffleStringBuilder.AppendStringNode.create();
            this.builderToStringNode = TruffleStringBuilder.ToStringNode.create();
        }

        @Specialization
        protected Object raw(Object template, Object[] substitutions, @Cached InlinedConditionProfile emptyProf) {
            int numberOfSubstitutions = substitutions.length;
            Object cooked = this.templateToObjectNode.execute(template);
            Object raw = this.rawToObjectNode.execute(this.getRawNode.getValue(cooked));
            int literalSegments = this.getRawLength(raw);
            if (emptyProf.profile(this, literalSegments <= 0)) {
                return Strings.EMPTY_STRING;
            }
            TruffleStringBuilderUTF16 result = Strings.builderCreate();
            int i = 0;
            while (true) {
                Object rawElement = this.readRawElementNode.executeWithTargetAndIndex(raw, i);
                TruffleString nextSeg = this.segToStringNode.executeString(rawElement);
                this.appendChecked(result, nextSeg);
                if (i + 1 == literalSegments) break;
                if (i < numberOfSubstitutions) {
                    TruffleString nextSub = this.subToStringNode.executeString(substitutions[i]);
                    this.appendChecked(result, nextSub);
                }
                ++i;
            }
            return Strings.builderToString(this.builderToStringNode, result);
        }

        private int getRawLength(Object raw) {
            long length = this.getRawLengthNode.executeLong(raw);
            try {
                return Math.toIntExact(length);
            }
            catch (ArithmeticException e) {
                return 0;
            }
        }

        private void appendChecked(TruffleStringBuilderUTF16 result, TruffleString str) {
            if (Strings.builderLength(result) + Strings.length(str) > this.getContext().getStringLengthLimit()) {
                CompilerDirectives.transferToInterpreter();
                throw Errors.createRangeErrorInvalidStringLength();
            }
            Strings.builderAppend(this.appendStringNode, result, str);
        }
    }

    @ImportStatic(value={StringDedentNode.class})
    public static abstract class StringDedentNode
    extends JSBuiltinNode {
        static final HiddenKey TAG_KEY = new HiddenKey("TagKey");

        public StringDedentNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isObject.executeBoolean(callback)", "isCallable.executeBoolean(callback)"})
        protected Object dedentCallback(Object callback, Object[] substitutions, @Cached @Cached.Shared IsCallableNode isCallable, @Cached @Cached.Shared IsObjectNode isObject, @Cached(value="createSetHidden(TAG_KEY, getContext())") PropertySetNode setArgs) {
            JSFunctionData functionData = this.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.DedentCallback, c -> StringDedentNode.callbackBody(c));
            JSFunctionObject function = JSFunction.create(this.getRealm(), functionData);
            setArgs.setValue(function, callback);
            return function;
        }

        private static JSFunctionData callbackBody(JSContext context) {
            class CallbackBody
            extends JavaScriptRootNode {
                @Node.Child
                private DedentTemplateStringsArrayNode dedentTemplateStringsArray;
                @Node.Child
                private PropertyGetNode getTag;
                @Node.Child
                private JSFunctionCallNode callResolve;
                @Node.Child
                private IsObjectNode isObject;
                final /* synthetic */ JSContext val$context;

                CallbackBody(JSContext jSContext) {
                    this.val$context = jSContext;
                    this.dedentTemplateStringsArray = StringFunctionBuiltinsFactory.DedentTemplateStringsArrayNodeGen.create(this.val$context);
                    this.getTag = PropertyGetNode.createGetHidden(TAG_KEY, this.val$context);
                    this.callResolve = JSFunctionCallNode.createCall();
                    this.isObject = IsObjectNode.create();
                }

                @Override
                public Object execute(VirtualFrame frame) {
                    JSFunctionObject functionObject = JSFrameUtil.getFunctionObject(frame);
                    Object tag = this.getTag.getValue(functionObject);
                    Object r = JSFrameUtil.getThisObj(frame);
                    Object[] args = JSFrameUtil.getArgumentsArray(frame);
                    if (args.length < 1) {
                        throw Errors.createTypeError("Expected at least one argument");
                    }
                    Object template = args[0];
                    if (!this.isObject.executeBoolean(template)) {
                        throw Errors.createTypeErrorNotAnObject(template);
                    }
                    JSArrayObject dedentedArray = this.dedentTemplateStringsArray.execute(template, this.val$context);
                    Object[] callbackArgs = Arrays.copyOf(args, args.length);
                    callbackArgs[0] = dedentedArray;
                    return this.callResolve.executeCall(JSArguments.create(r, tag, callbackArgs));
                }
            }
            return JSFunctionData.createCallOnly(context, new CallbackBody(context).getCallTarget(), 2, Strings.EMPTY_STRING);
        }

        @Specialization(guards={"isObject.executeBoolean(template)", "!isCallable.executeBoolean(template)"})
        protected static Object dedentTemplate(Object template, Object[] substitutions, @Bind Node self, @Bind(value="getContext()") JSContext context, @Cached @Cached.Shared IsCallableNode isCallable, @Cached @Cached.Shared IsObjectNode isObject, @Cached(value="create(getContext())") DedentTemplateStringsArrayNode dedentTemplateStringsArray, @Cached(value="create(getContext())") ReadElementNode readElementNode, @Cached JSToStringNode segToStringNode, @Cached JSToStringNode subToStringNode, @Cached InlinedBranchProfile errorBranch, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode builderToStringNode) {
            int stringLengthLimit = context.getStringLengthLimit();
            JSArrayObject dedentedArray = dedentTemplateStringsArray.execute(template, context);
            int substitutionCount = substitutions.length;
            long literalCount = JSArray.arrayGetLength(dedentedArray);
            if (literalCount <= 0L) {
                return Strings.EMPTY_STRING;
            }
            TruffleStringBuilderUTF16 result = Strings.builderCreate();
            int i = 0;
            while ((long)i < literalCount) {
                TruffleString nextSeg = segToStringNode.executeString(readElementNode.executeWithTargetAndIndex((Object)dedentedArray, i));
                StringDedentNode.appendChecked(result, nextSeg, stringLengthLimit, self, errorBranch, appendStringNode);
                if ((long)(i + 1) == literalCount) break;
                if (i < substitutionCount) {
                    TruffleString nextSub = subToStringNode.executeString(substitutions[i]);
                    StringDedentNode.appendChecked(result, nextSub, stringLengthLimit, self, errorBranch, appendStringNode);
                }
                ++i;
            }
            return Strings.builderToString(builderToStringNode, result);
        }

        private static void appendChecked(TruffleStringBuilderUTF16 result, TruffleString str, int stringLengthLimit, Node self, InlinedBranchProfile errorBranch, TruffleStringBuilder.AppendStringNode appendStringNode) {
            if (Strings.builderLength(result) + Strings.length(str) > stringLengthLimit) {
                errorBranch.enter(self);
                throw Errors.createRangeErrorInvalidStringLength();
            }
            Strings.builderAppend(appendStringNode, result, str);
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        @Fallback
        protected static Object notAnObject(Object template, Object substitutions) {
            throw Errors.createTypeErrorNotAnObject(template);
        }
    }

    public static abstract class DedentTemplateStringsArrayNode
    extends JavaScriptBaseNode {
        @Node.Child
        private PropertyGetNode getRawNode;
        @Node.Child
        private JSGetLengthNode getLengthNode;
        @Node.Child
        private ReadElementNode readRawElementNode;
        @Node.Child
        private TruffleStringBuilder.AppendStringNode appendStringNode;
        @Node.Child
        private TruffleStringBuilder.AppendSubstringByteIndexNode appendSubstringNode;
        @Node.Child
        private TruffleStringBuilder.AppendCharUTF16Node appendCharNode;
        @Node.Child
        private TruffleStringBuilder.AppendCodePointNode appendCodePointNode;
        @Node.Child
        private TruffleStringBuilder.ToStringNode builderToStringNode;
        @Node.Child
        private TruffleString.ReadCharUTF16Node readCharNode;
        @Node.Child
        private TruffleString.SubstringByteIndexNode substringNode;
        @Node.Child
        private TruffleStringIterator.NextNode iteratorNextNode;
        @Node.Child
        private TruffleStringIterator.PreviousNode iteratorPreviousNode;

        DedentTemplateStringsArrayNode(JSContext context) {
            this.getLengthNode = JSGetLengthNode.create(context);
            this.getRawNode = PropertyGetNode.create(Strings.RAW, context);
            this.readRawElementNode = ReadElementNode.create(context);
            this.appendStringNode = TruffleStringBuilder.AppendStringNode.create();
            this.appendSubstringNode = TruffleStringBuilder.AppendSubstringByteIndexNode.create();
            this.appendCharNode = TruffleStringBuilder.AppendCharUTF16Node.create();
            this.appendCodePointNode = TruffleStringBuilder.AppendCodePointNode.create();
            this.builderToStringNode = TruffleStringBuilder.ToStringNode.create();
            this.readCharNode = TruffleString.ReadCharUTF16Node.create();
            this.substringNode = TruffleString.SubstringByteIndexNode.create();
            this.iteratorNextNode = TruffleStringIterator.NextNode.create();
            this.iteratorPreviousNode = TruffleStringIterator.PreviousNode.create();
        }

        protected abstract JSArrayObject execute(Object var1, JSContext var2);

        @Specialization
        protected final JSArrayObject dedentTemplateStringsArray(Object template, JSContext context, @Cached JSToObjectNode rawToObjectNode, @Cached InlinedConditionProfile emptyProf, @Cached InlinedBranchProfile errorBranch, @Cached InlinedBranchProfile growBranch, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIterator, @Cached JSCollectionsNormalizeNode collectionsNormalize) {
            Object rawInput = collectionsNormalize.execute(this.getRawNode.getValue(template));
            JSRealm realm = this.getRealm();
            Map<Object, JSArrayObject> dedentMap = realm.getDedentMap();
            JSArrayObject cached = Boundaries.mapGet(dedentMap, rawInput);
            if (cached != null) {
                return cached;
            }
            Object[] dedentedList = this.dedentStringsArray(rawInput, context, rawToObjectNode, emptyProf, errorBranch, growBranch);
            JSArrayObject rawArr = JSArray.createConstant(context, realm, dedentedList);
            JSArrayObject cookedArr = JSArray.createConstant(context, realm, this.cookStrings((TruffleString[])dedentedList, createCodePointIterator, errorBranch));
            JSRuntime.definePropertyOrThrow(cookedArr, Strings.RAW, PropertyDescriptor.createData(rawArr, false, false, false));
            rawArr.setIntegrityLevel(true, true);
            cookedArr.setIntegrityLevel(true, true);
            Boundaries.mapPut(dedentMap, rawInput, cookedArr);
            return cookedArr;
        }

        private TruffleString[] dedentStringsArray(Object template, JSContext context, JSToObjectNode rawToObjectNode, InlinedConditionProfile emptyProf, InlinedBranchProfile errorBranch, InlinedBranchProfile growBranch) {
            Object templateObj = rawToObjectNode.execute(template);
            int literalSegments = this.getLength(templateObj);
            if (emptyProf.profile(this, literalSegments <= 0)) {
                errorBranch.enter(this);
                throw Errors.createTypeError("Template raw array must contain at least 1 string");
            }
            SegmentRecord[][] blocks = this.splitTemplateIntoBlockLines(templateObj, literalSegments, context.getStringLengthLimit(), errorBranch, growBranch);
            this.emptyWhiteSpaceLines(blocks);
            this.removeOpeningAndClosingLines(blocks, errorBranch);
            TruffleString indent = this.determineCommonLeadingIndentation(blocks);
            int indentLength = Strings.length(indent);
            TruffleString[] dedented = new TruffleString[blocks.length];
            for (int j = 0; j < blocks.length; ++j) {
                SegmentRecord[] lines = blocks[j];
                TruffleStringBuilderUTF16 partialResult = Strings.builderCreate();
                for (int i = 0; i < lines.length; ++i) {
                    SegmentRecord line = lines[i];
                    int currentIndentation = i == 0 || Strings.isEmpty(line.substr) ? 0 : indentLength;
                    Strings.builderAppendLen(this.appendSubstringNode, partialResult, line.substr, currentIndentation, Strings.length(line.substr) - currentIndentation);
                    Strings.builderAppend(this.appendStringNode, partialResult, line.newline);
                }
                dedented[j] = Strings.builderToString(this.builderToStringNode, partialResult);
            }
            return dedented;
        }

        private SegmentRecord[][] splitTemplateIntoBlockLines(Object raw, int len, int stringLengthLimit, InlinedBranchProfile errorBranch, InlinedBranchProfile growBranch) {
            SegmentRecord[][] blocks = new SegmentRecord[len][];
            int totalLength = 0;
            for (int k = 0; k < len; ++k) {
                int n;
                Object rawElement = this.readRawElementNode.executeWithTargetAndIndex(raw, k);
                if (!(rawElement instanceof TruffleString)) {
                    throw Errors.createTypeError("Template raw array may only contain strings");
                }
                TruffleString nextSeg = (TruffleString)rawElement;
                int segLength = Strings.length(nextSeg);
                if ((totalLength += segLength) > stringLengthLimit) {
                    errorBranch.enter(this);
                    throw Errors.createRangeErrorInvalidStringLength();
                }
                int start = 0;
                SimpleArrayList<SegmentRecord> lines = new SimpleArrayList<SegmentRecord>(segLength + 1);
                for (int i = 0; i < segLength; i += n) {
                    char c = Strings.charAt(this.readCharNode, nextSeg, i);
                    int n2 = n = c == '\r' && i + 1 < segLength && Strings.charAt(this.readCharNode, nextSeg, i + 1) == '\n' ? 2 : 1;
                    if (!JSRuntime.isLineTerminator(c)) continue;
                    TruffleString substr = Strings.lazySubstring(this.substringNode, nextSeg, start, i - start);
                    TruffleString newline = Strings.lazySubstring(this.substringNode, nextSeg, i, n);
                    lines.add(new SegmentRecord(substr, newline, false), this, growBranch);
                    start = i + n;
                }
                TruffleString tail = Strings.lazySubstring(this.substringNode, nextSeg, start, segLength - start);
                boolean lineEndsWithSubstitution = k + 1 < len;
                lines.add(new SegmentRecord(tail, Strings.EMPTY_STRING, lineEndsWithSubstitution), this, growBranch);
                blocks[k] = lines.toArray(new SegmentRecord[lines.size()]);
            }
            return blocks;
        }

        private void emptyWhiteSpaceLines(SegmentRecord[][] blocks) {
            for (SegmentRecord[] lines : blocks) {
                for (int i = 1; i < lines.length; ++i) {
                    SegmentRecord line = lines[i];
                    if (line.lineEndsWithSubstitution || !this.isAllWhitespace(line.substr)) continue;
                    line.substr = Strings.EMPTY_STRING;
                }
            }
        }

        private boolean isAllWhitespace(TruffleString str) {
            int len = Strings.length(str);
            for (int i = 0; i < len; ++i) {
                if (JSRuntime.isWhiteSpaceOrLineTerminator(Strings.charAt(this.readCharNode, str, i))) continue;
                return false;
            }
            return true;
        }

        private void removeOpeningAndClosingLines(SegmentRecord[][] blocks, InlinedBranchProfile errorBranch) {
            SegmentRecord[] firstBlock = blocks[0];
            int lineCount = firstBlock.length;
            assert (lineCount != 0);
            if (lineCount == 1) {
                errorBranch.enter(this);
                throw Errors.createTypeError("The opening line must contain a trailing newline.");
            }
            SegmentRecord openingLine = firstBlock[0];
            if (!Strings.isEmpty(openingLine.substr)) {
                errorBranch.enter(this);
                throw Errors.createTypeError("The opening line must be empty.");
            }
            openingLine.newline = Strings.EMPTY_STRING;
            SegmentRecord[] lastBlock = blocks[blocks.length - 1];
            lineCount = lastBlock.length;
            if (lineCount == 1) {
                errorBranch.enter(this);
                throw Errors.createTypeError("The closing line must be preceded by a newline.");
            }
            SegmentRecord closingLine = lastBlock[lineCount - 1];
            if (!Strings.isEmpty(closingLine.substr)) {
                errorBranch.enter(this);
                throw Errors.createTypeError("The closing line must be empty.");
            }
            SegmentRecord preceding = lastBlock[lineCount - 2];
            closingLine.substr = Strings.EMPTY_STRING;
            preceding.newline = Strings.EMPTY_STRING;
        }

        private TruffleString determineCommonLeadingIndentation(SegmentRecord[][] blocks) {
            TruffleString common = null;
            for (SegmentRecord[] lines : blocks) {
                for (int i = 1; i < lines.length; ++i) {
                    SegmentRecord line = lines[i];
                    if (!line.lineEndsWithSubstitution && Strings.isEmpty(line.substr)) continue;
                    TruffleString leading = this.leadingWhiteSpaceSubstring(line.substr);
                    common = common == null ? leading : this.longestMatchingLeadingSubstring(common, leading);
                }
            }
            assert (common != null);
            return common;
        }

        private TruffleString leadingWhiteSpaceSubstring(TruffleString str) {
            int length = Strings.length(str);
            for (int i = 0; i < length; ++i) {
                if (JSRuntime.isWhiteSpaceExcludingLineTerminator(Strings.charAt(this.readCharNode, str, i))) continue;
                return Strings.lazySubstring(this.substringNode, str, 0, i);
            }
            return str;
        }

        private TruffleString longestMatchingLeadingSubstring(TruffleString strA, TruffleString strB) {
            int len = Math.min(Strings.length(strA), Strings.length(strB));
            for (int i = 0; i < len; ++i) {
                if (Strings.charAt(this.readCharNode, strA, i) == Strings.charAt(this.readCharNode, strB, i)) continue;
                return Strings.lazySubstring(this.substringNode, strA, 0, i);
            }
            return Strings.lazySubstring(this.substringNode, strA, 0, len);
        }

        private Object[] cookStrings(TruffleString[] raw, TruffleString.CreateCodePointIteratorNode createCodePointIterator, InlinedBranchProfile errorBranch) {
            Object[] cooked = new Object[raw.length];
            for (int i = 0; i < raw.length; ++i) {
                TruffleString str = raw[i];
                TruffleStringIterator iterator = createCodePointIterator.execute(str, TruffleString.Encoding.UTF_16);
                cooked[i] = this.parseText(iterator, errorBranch);
            }
            return cooked;
        }

        private Object parseText(TruffleStringIterator iterator, InlinedBranchProfile errorBranch) {
            TruffleStringBuilderUTF16 partialResult = Strings.builderCreate();
            block17: while (iterator.hasNext()) {
                int ch = this.iteratorNextNode.execute(iterator, TruffleString.Encoding.UTF_16);
                if (ch == 92) {
                    if (!iterator.hasNext()) {
                        return Undefined.instance;
                    }
                    int next = this.iteratorNextNode.execute(iterator, TruffleString.Encoding.UTF_16);
                    switch (next) {
                        case 48: {
                            if (JSRuntime.isAsciiDigit(this.peekNext(iterator))) {
                                return Undefined.instance;
                            }
                            this.appendCharNode.execute(partialResult, '\u0000');
                            break;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            return Undefined.instance;
                        }
                        case 110: {
                            this.appendCharNode.execute(partialResult, '\n');
                            break;
                        }
                        case 116: {
                            this.appendCharNode.execute(partialResult, '\t');
                            break;
                        }
                        case 98: {
                            this.appendCharNode.execute(partialResult, '\b');
                            break;
                        }
                        case 102: {
                            this.appendCharNode.execute(partialResult, '\f');
                            break;
                        }
                        case 114: {
                            this.appendCharNode.execute(partialResult, '\r');
                            break;
                        }
                        case 39: {
                            this.appendCharNode.execute(partialResult, '\'');
                            break;
                        }
                        case 34: {
                            this.appendCharNode.execute(partialResult, '\"');
                            break;
                        }
                        case 92: {
                            this.appendCharNode.execute(partialResult, '\\');
                            break;
                        }
                        case 13: {
                            if (this.iteratorNextNode.execute(iterator, TruffleString.Encoding.UTF_16) == 10) continue block17;
                            this.iteratorPreviousNode.execute(iterator, TruffleString.Encoding.UTF_16);
                            break;
                        }
                        case 10: 
                        case 8232: 
                        case 8233: {
                            break;
                        }
                        case 120: {
                            int asciiCh = this.hexSequence(iterator, 2, errorBranch);
                            this.appendCharNode.execute(partialResult, (char)asciiCh);
                            break;
                        }
                        case 117: {
                            int unicodeChar = this.unicodeEscapeSequence(iterator, errorBranch);
                            if (unicodeChar < 0) {
                                this.appendStringNode.execute(partialResult, Strings.BACKSLASH_U);
                                break;
                            }
                            if (unicodeChar <= 65535 && Character.isSurrogate((char)unicodeChar)) {
                                this.appendCharNode.execute(partialResult, (char)unicodeChar);
                                break;
                            }
                            this.appendCodePointNode.execute(partialResult, unicodeChar);
                            break;
                        }
                        case 118: {
                            this.appendCharNode.execute(partialResult, '\u000b');
                            break;
                        }
                        default: {
                            if (next <= 65535 && Character.isSurrogate((char)next)) {
                                this.appendCharNode.execute(partialResult, (char)next);
                                break;
                            }
                            this.appendCodePointNode.execute(partialResult, next);
                            break;
                        }
                    }
                    continue;
                }
                if (ch <= 65535 && Character.isSurrogate((char)ch)) {
                    this.appendCharNode.execute(partialResult, (char)ch);
                    continue;
                }
                this.appendCodePointNode.execute(partialResult, ch);
            }
            return Strings.builderToString(this.builderToStringNode, partialResult);
        }

        private int peekNext(TruffleStringIterator iterator) {
            int ch = this.iteratorNextNode.execute(iterator, TruffleString.Encoding.UTF_16);
            this.iteratorPreviousNode.execute(iterator, TruffleString.Encoding.UTF_16);
            return ch;
        }

        private int unicodeEscapeSequence(TruffleStringIterator iterator, InlinedBranchProfile errorBranch) {
            int ch = this.peekNext(iterator);
            if (ch == 123) {
                return this.varlenHexSequence(iterator, errorBranch);
            }
            return this.hexSequence(iterator, 4, errorBranch);
        }

        private int varlenHexSequence(TruffleStringIterator iterator, InlinedBranchProfile errorBranch) {
            int ch = this.iteratorNextNode.execute(iterator, TruffleString.Encoding.UTF_16);
            assert (ch == 123);
            int value = 0;
            boolean firstIteration = true;
            while (iterator.hasNext()) {
                ch = this.iteratorNextNode.execute(iterator, TruffleString.Encoding.UTF_16);
                if (ch == 125) {
                    if (!firstIteration) break;
                    errorBranch.enter(this);
                    throw Errors.createSyntaxError("Invalid Unicode escape sequence");
                }
                int digit = DedentTemplateStringsArrayNode.convertDigit(ch, 16);
                if (digit == -1) {
                    errorBranch.enter(this);
                    throw Errors.createSyntaxError("Invalid Unicode escape sequence");
                }
                if ((value = digit | value << 4) > 0x10FFFF) {
                    errorBranch.enter(this);
                    throw Errors.createSyntaxError("Invalid Unicode escape sequence");
                }
                firstIteration = false;
            }
            return value;
        }

        private int hexSequence(TruffleStringIterator iterator, int length, InlinedBranchProfile errorBranch) {
            int i;
            int value = 0;
            for (i = 0; i < length && iterator.hasNext(); ++i) {
                int ch = this.iteratorNextNode.execute(iterator, TruffleString.Encoding.UTF_16);
                int digit = DedentTemplateStringsArrayNode.convertDigit(ch, 16);
                if (digit == -1) {
                    errorBranch.enter(this);
                    throw Errors.createSyntaxError("Invalid hex digit");
                }
                value = digit | value << 4;
            }
            if (i != length) {
                errorBranch.enter(this);
                throw Errors.createSyntaxError("Invalid hex length");
            }
            return value;
        }

        protected static int convertDigit(int ch, int base) {
            int digit;
            if (48 <= ch && ch <= 57) {
                digit = ch - 48;
            } else if (65 <= ch && ch <= 90) {
                digit = ch - 65 + 10;
            } else if (97 <= ch && ch <= 122) {
                digit = ch - 97 + 10;
            } else {
                return -1;
            }
            return digit < base ? digit : -1;
        }

        private int getLength(Object raw) {
            long length = this.getLengthNode.executeLong(raw);
            try {
                return Math.toIntExact(length);
            }
            catch (ArithmeticException e) {
                return 0;
            }
        }

        private static final class SegmentRecord {
            TruffleString substr;
            TruffleString newline;
            boolean lineEndsWithSubstitution;

            SegmentRecord(TruffleString substr, TruffleString newline, boolean lineEndsWithSubstitution) {
                this.substr = substr;
                this.newline = newline;
                this.lineEndsWithSubstitution = lineEndsWithSubstitution;
            }
        }
    }
}

