/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import java.nio.ByteBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.ConstructorBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSConstructTypedArrayNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GetIteratorFromMethodNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GetMethodNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GetPrototypeFromConstructorNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IterableToListNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.ReadElementNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.WriteElementNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToIndexNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop.ImportValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.TypedArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAbstractBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.SimpleArrayList;

@ImportStatic(value={JSArrayBuffer.class, JSRuntime.class, JSConfig.class, Strings.class})
public abstract class JSConstructTypedArrayNode
extends JSBuiltinNode {
    @Node.Child
    private JSToIndexNode toIndexNode;
    @Node.Child
    private GetPrototypeFromConstructorNode getPrototypeFromConstructorViewNode;
    @Node.Child
    private IntegerIndexedObjectCreateNode integerIndexObjectCreateNode;
    private final TypedArrayFactory factory;

    protected JSConstructTypedArrayNode(JSContext context, JSBuiltin builtin, TypedArrayFactory factory) {
        super(context, builtin);
        this.factory = factory;
    }

    private long toIndex(Object target) {
        if (this.toIndexNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toIndexNode = this.insert(JSToIndexNode.create());
        }
        return this.toIndexNode.executeLong(target);
    }

    private JSDynamicObject getPrototypeFromConstructorView(JSDynamicObject newTarget) {
        if (this.getPrototypeFromConstructorViewNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getPrototypeFromConstructorViewNode = this.insert(GetPrototypeFromConstructorNode.create(this.getContext(), null, realm -> realm.getArrayBufferViewPrototype(this.factory)));
        }
        return this.getPrototypeFromConstructorViewNode.executeWithConstructor(newTarget);
    }

    private JSDynamicObject integerIndexedObjectCreate(JSArrayBufferObject arrayBuffer, TypedArray typedArray, int offset, int length, JSDynamicObject proto) {
        if (this.integerIndexObjectCreateNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.integerIndexObjectCreateNode = this.insert(JSConstructTypedArrayNodeGen.IntegerIndexedObjectCreateNodeGen.create(this.getContext(), this.factory));
        }
        return this.integerIndexObjectCreateNode.execute(arrayBuffer, typedArray, offset, length, proto);
    }

    private void checkDetachedBuffer(JSArrayBufferObject buffer, InlinedBranchProfile errorBranch) {
        if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(buffer)) {
            errorBranch.enter(this);
            throw Errors.createTypeErrorDetachedBuffer();
        }
    }

    @Specialization(guards={"!isUndefined(newTarget)"})
    protected JSDynamicObject doArrayBuffer(JSDynamicObject newTarget, JSArrayBufferObject.Heap arrayBuffer, Object byteOffset0, Object length0, @Cached @Cached.Shared InlinedBranchProfile errorBranch, @Cached @Cached.Shared InlinedConditionProfile lengthIsUndefined) {
        return this.doArrayBufferImpl(arrayBuffer, byteOffset0, length0, newTarget, (byte)0, this, errorBranch, lengthIsUndefined, null);
    }

    @Specialization(guards={"!isUndefined(newTarget)"})
    protected JSDynamicObject doDirectArrayBuffer(JSDynamicObject newTarget, JSArrayBufferObject.Direct arrayBuffer, Object byteOffset0, Object length0, @Cached @Cached.Shared InlinedBranchProfile errorBranch, @Cached @Cached.Shared InlinedConditionProfile lengthIsUndefined) {
        return this.doArrayBufferImpl(arrayBuffer, byteOffset0, length0, newTarget, (byte)1, this, errorBranch, lengthIsUndefined, null);
    }

    private JSDynamicObject doArrayBufferImpl(JSArrayBufferObject arrayBuffer, Object byteOffset0, Object length0, JSDynamicObject newTarget, byte bufferType, Node node, InlinedBranchProfile errorBranch, InlinedConditionProfile lengthIsUndefinedProfile, InteropLibrary interop) {
        JSDynamicObject proto = this.getPrototypeFromConstructorView(newTarget);
        int elementSize = this.factory.getBytesPerElement();
        long byteOffset = this.toIndex(byteOffset0);
        this.rangeCheckIsMultipleOfElementSize(byteOffset % (long)elementSize == 0L, "start offset", this.factory.getName(), elementSize, errorBranch);
        long length = 0L;
        if (!lengthIsUndefinedProfile.profile(node, length0 == Undefined.instance)) {
            length = this.toIndex(length0);
            assert (length >= 0L);
        }
        if (bufferType != 2) {
            this.checkDetachedBuffer(arrayBuffer, errorBranch);
        }
        assert (interop != null == arrayBuffer instanceof JSArrayBufferObject.Interop);
        long bufferByteLength = interop == null ? (long)arrayBuffer.getByteLength() : (long)((JSArrayBufferObject.Interop)arrayBuffer).getByteLength(interop);
        if (lengthIsUndefinedProfile.profile(node, length0 == Undefined.instance)) {
            if (arrayBuffer.isFixedLength()) {
                this.rangeCheckIsMultipleOfElementSize(bufferByteLength % (long)elementSize == 0L, "buffer.byteLength", this.factory.getName(), elementSize, errorBranch);
                length = (bufferByteLength - byteOffset) / (long)elementSize;
                this.rangeCheck(length >= 0L, "length < 0", errorBranch);
            } else {
                this.rangeCheck(byteOffset <= bufferByteLength, "byteOffset > bufferByteLength", errorBranch);
                length = -1L;
            }
        } else {
            this.checkLengthLimit(length, elementSize, errorBranch);
            int byteLength = JSConstructTypedArrayNode.toByteLength((int)length, elementSize);
            if (byteOffset + (long)byteLength > bufferByteLength) {
                errorBranch.enter(this);
                throw this.throwInappropriateLengthError(length);
            }
        }
        assert (byteOffset <= Integer.MAX_VALUE && length <= Integer.MAX_VALUE);
        TypedArray typedArray = this.factory.createArrayType(bufferType, byteOffset != 0L, length != -1L);
        return this.createTypedArray(arrayBuffer, typedArray, (int)byteOffset, (int)length, proto);
    }

    @Specialization(guards={"!isUndefined(newTarget)"})
    protected JSDynamicObject doSharedArrayBuffer(JSDynamicObject newTarget, JSArrayBufferObject.Shared arrayBuffer, Object byteOffset0, Object length0, @Cached @Cached.Shared InlinedBranchProfile errorBranch, @Cached @Cached.Shared InlinedConditionProfile lengthIsUndefined) {
        return this.doArrayBufferImpl(arrayBuffer, byteOffset0, length0, newTarget, (byte)2, this, errorBranch, lengthIsUndefined, null);
    }

    @Specialization(guards={"!isUndefined(newTarget)"})
    protected JSDynamicObject doInteropArrayBuffer(JSDynamicObject newTarget, JSArrayBufferObject.Interop arrayBuffer, Object byteOffset0, Object length0, @Cached @Cached.Shared InlinedBranchProfile errorBranch, @Cached @Cached.Shared InlinedConditionProfile lengthIsUndefined, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary bufferInterop) {
        return this.doArrayBufferImpl(arrayBuffer, byteOffset0, length0, newTarget, (byte)-1, this, errorBranch, lengthIsUndefined, bufferInterop);
    }

    @Specialization(guards={"!isUndefined(newTarget)"})
    protected JSDynamicObject doTypedArray(JSDynamicObject newTarget, JSTypedArrayObject arrayBufferView, Object byteOffset0, Object length0, @Cached @Cached.Shared InlinedBranchProfile errorBranch, @Cached @Cached.Exclusive InlinedConditionProfile bulkCopyProfile) {
        boolean sourceTypeIsBig;
        JSDynamicObject proto = this.getPrototypeFromConstructorView(newTarget);
        if (JSArrayBufferView.isOutOfBounds(arrayBufferView, this.getContext())) {
            errorBranch.enter(this);
            throw Errors.createTypeErrorOutOfBoundsTypedArray();
        }
        TypedArray sourceType = arrayBufferView.getArrayType();
        long length = sourceType.length(arrayBufferView);
        JSArrayBufferObject arrayBuffer = this.createTypedArrayBuffer(length, errorBranch);
        boolean elementTypeIsBig = this.factory.isBigInt();
        if (elementTypeIsBig != (sourceTypeIsBig = sourceType instanceof TypedArray.TypedBigIntArray)) {
            throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
        }
        TypedArray typedArray = this.factory.createArrayType(this.getContext().isOptionDirectByteBuffer() ? (byte)1 : 0, false, true);
        JSDynamicObject result = this.createTypedArray(arrayBuffer, typedArray, 0, (int)length, proto);
        assert (typedArray == JSArrayBufferView.typedArrayGetArrayType(result));
        if (bulkCopyProfile.profile(this, !sourceType.isInterop() && sourceType.getElementType() == typedArray.getElementType())) {
            JSArrayBufferObject srcData = arrayBufferView.getArrayBuffer();
            int sourceByteOffset = arrayBufferView.getByteOffset();
            int elementSize = sourceType.bytesPerElement();
            int sourceByteLength = (int)length * elementSize;
            if (sourceType.isDirect() && typedArray.isDirect()) {
                ByteBuffer sourceBuffer = JSArrayBuffer.getDirectByteBuffer(srcData);
                ByteBuffer targetBuffer = JSArrayBuffer.getDirectByteBuffer(arrayBuffer);
                Boundaries.byteBufferPutSlice(targetBuffer, 0, sourceBuffer, sourceByteOffset, sourceByteOffset + sourceByteLength);
                return result;
            }
            if (!sourceType.isDirect() && !typedArray.isDirect()) {
                byte[] sourceArray = JSArrayBuffer.getByteArray(srcData);
                byte[] targetArray = JSArrayBuffer.getByteArray(arrayBuffer);
                System.arraycopy(sourceArray, sourceByteOffset, targetArray, 0, sourceByteLength);
                return result;
            }
        }
        for (long i = 0L; i < length; ++i) {
            Object element = sourceType.getElement(arrayBufferView, i);
            typedArray.setElement(result, i, element, false);
        }
        return result;
    }

    @Specialization(guards={"!isUndefined(newTarget)", "isUndefined(arg0)"})
    protected JSDynamicObject doEmpty(JSDynamicObject newTarget, JSDynamicObject arg0, Object byteOffset0, Object length0, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
        return this.createTypedArrayWithLength(0L, newTarget, errorBranch);
    }

    @Specialization(guards={"!isUndefined(newTarget)", "length >= 0"})
    protected JSDynamicObject doIntLength(JSDynamicObject newTarget, int length, Object byteOffset0, Object length0, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
        return this.createTypedArrayWithLength(length, newTarget, errorBranch);
    }

    @Specialization(guards={"!isUndefined(newTarget)", "!isJSObject(arg0)", "!isForeignObject(arg0)"}, replaces={"doIntLength"})
    protected JSDynamicObject doLength(JSDynamicObject newTarget, Object arg0, Object byteOffset0, Object length0, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
        return this.createTypedArrayWithLength(this.toIndex(arg0), newTarget, errorBranch);
    }

    @Specialization(guards={"!isUndefined(newTarget)", "!isJSAbstractBuffer(object)", "!isJSArrayBufferView(object)"})
    protected JSDynamicObject doObject(JSDynamicObject newTarget, JSObject object, Object byteOffset0, Object length0, @Bind Node node, @Cached(value="createGetIteratorMethod()") GetMethodNode getIteratorMethodNode, @Cached @Cached.Exclusive InlinedConditionProfile isIterableProfile, @Cached(value="createWriteOwn()") @Cached.Shared WriteElementNode writeOwnNode, @Cached GetIteratorFromMethodNode getIteratorFromMethodNode, @Cached IterableToListNode iterableToListNode, @Cached @Cached.Shared InlinedBranchProfile errorBranch, @Cached(value="createGetLength()") JSGetLengthNode getLengthNode, @Cached(value="create(getContext())") ReadElementNode readNode) {
        assert (JSRuntime.isObject(object) && !JSArrayBufferView.isJSArrayBufferView(object) && !JSAbstractBuffer.isJSAbstractBuffer(object));
        JSDynamicObject proto = this.getPrototypeFromConstructorView(newTarget);
        assert (JSRuntime.isObject(proto));
        Object usingIterator = getIteratorMethodNode.executeWithTarget(object);
        if (isIterableProfile.profile(node, usingIterator != Undefined.instance)) {
            SimpleArrayList<Object> values = iterableToListNode.execute(getIteratorFromMethodNode.execute(node, object, usingIterator));
            int len = values.size();
            JSArrayBufferObject arrayBuffer = this.createTypedArrayBuffer(len, errorBranch);
            TypedArray typedArray = this.factory.createArrayType(this.getContext().isOptionDirectByteBuffer() ? (byte)1 : 0, false, true);
            JSDynamicObject obj = this.integerIndexedObjectCreate(arrayBuffer, typedArray, 0, len, proto);
            for (int k = 0; k < len; ++k) {
                Object kValue = values.get(k);
                writeOwnNode.executeWithTargetAndIndexAndValue((Object)obj, k, kValue);
            }
            JSConstructTypedArrayNode.reportLoopCount((Node)this, len);
            return obj;
        }
        long len = getLengthNode.executeLong(object);
        JSArrayBufferObject arrayBuffer = this.createTypedArrayBuffer(len, errorBranch);
        assert (len <= Integer.MAX_VALUE);
        TypedArray typedArray = this.factory.createArrayType(this.getContext().isOptionDirectByteBuffer() ? (byte)1 : 0, false, true);
        JSDynamicObject obj = this.integerIndexedObjectCreate(arrayBuffer, typedArray, 0, (int)len, proto);
        int k = 0;
        while ((long)k < len) {
            Object kValue = readNode.executeWithTargetAndIndex((Object)object, k);
            writeOwnNode.executeWithTargetAndIndexAndValue((Object)obj, k, kValue);
            ++k;
        }
        JSConstructTypedArrayNode.reportLoopCount((Node)this, len);
        return obj;
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"!isUndefined(newTarget)", "isForeignObject(object)"}, limit="InteropLibraryLimit")
    protected JSDynamicObject doForeignObject(JSDynamicObject newTarget, Object object, Object byteOffset0, Object length0, @Bind Node node, @CachedLibrary(value="object") InteropLibrary interop, @Cached(value="createWriteOwn()") @Cached.Shared WriteElementNode writeOwnNode, @Cached ImportValueNode importValue, @Cached @Cached.Shared InlinedBranchProfile errorBranch, @Cached @Cached.Shared InlinedConditionProfile lengthIsUndefined) {
        long length;
        if (interop.hasBufferElements(object)) {
            int bufferSize = ConstructorBuiltins.ConstructArrayBufferNode.getBufferSizeSafe(object, interop, this, errorBranch);
            JSArrayBufferObject.Interop arrayBuffer = JSArrayBuffer.createInteropArrayBuffer(this.getContext(), this.getRealm(), object);
            this.checkLengthLimit(bufferSize, 1, errorBranch);
            return this.doArrayBufferImpl(arrayBuffer, byteOffset0, length0, newTarget, (byte)-1, node, errorBranch, lengthIsUndefined, interop);
        }
        boolean fromArray = interop.hasArrayElements(object);
        if (fromArray) {
            length = this.toIndex(JSInteropUtil.getArraySize(object, interop, this));
        } else if (interop.fitsInInt(object)) {
            try {
                length = this.toIndex(interop.asInt(object));
            }
            catch (UnsupportedMessageException e) {
                length = 0L;
            }
        } else {
            length = 0L;
        }
        JSDynamicObject obj = this.createTypedArrayWithLength(length, newTarget, errorBranch);
        if (fromArray) {
            assert (length <= Integer.MAX_VALUE);
            int k = 0;
            while ((long)k < length) {
                Object kValue = JSInteropUtil.readArrayElementOrDefault(object, k, 0, interop, importValue);
                writeOwnNode.executeWithTargetAndIndexAndValue((Object)obj, k, kValue);
                ++k;
            }
            JSConstructTypedArrayNode.reportLoopCount((Node)this, length);
        }
        return obj;
    }

    @NeverDefault
    GetMethodNode createGetIteratorMethod() {
        return GetMethodNode.create(this.getContext(), Symbol.SYMBOL_ITERATOR);
    }

    @NeverDefault
    WriteElementNode createWriteOwn() {
        return WriteElementNode.create(this.getContext(), true, true);
    }

    @NeverDefault
    JSGetLengthNode createGetLength() {
        return JSGetLengthNode.create(this.getContext());
    }

    @Specialization(guards={"isUndefined(newTarget)"})
    protected JSDynamicObject doUndefinedNewTarget(Object newTarget, Object arg0, Object byteOffset0, Object length0) {
        throw Errors.createTypeError("newTarget is not a function");
    }

    private JSArrayBufferObject createTypedArrayBuffer(long length, InlinedBranchProfile errorBranch) {
        assert (length >= 0L);
        int elementSize = this.factory.getBytesPerElement();
        this.checkLengthLimit(length, elementSize, errorBranch);
        int byteLength = JSConstructTypedArrayNode.toByteLength((int)length, elementSize);
        assert (length <= Integer.MAX_VALUE && byteLength >= 0 && byteLength <= Integer.MAX_VALUE);
        JSRealm realm = this.getRealm();
        if (this.getContext().isOptionDirectByteBuffer()) {
            return JSArrayBuffer.createDirectArrayBuffer(this.getContext(), realm, byteLength);
        }
        return JSArrayBuffer.createArrayBuffer(this.getContext(), realm, byteLength);
    }

    private JSDynamicObject createTypedArrayWithLength(long length, JSDynamicObject newTarget, InlinedBranchProfile errorBranch) {
        JSDynamicObject proto = this.getPrototypeFromConstructorView(newTarget);
        JSArrayBufferObject arrayBuffer = this.createTypedArrayBuffer(length, errorBranch);
        TypedArray typedArray = this.factory.createArrayType(this.getContext().isOptionDirectByteBuffer() ? (byte)1 : 0, false, true);
        return this.createTypedArray(arrayBuffer, typedArray, 0, (int)length, proto);
    }

    private JSDynamicObject createTypedArray(JSArrayBufferObject arrayBuffer, TypedArray typedArray, int offset, int length, JSDynamicObject proto) {
        assert (JSRuntime.isObject(proto));
        return this.integerIndexedObjectCreate(arrayBuffer, typedArray, offset, length, proto);
    }

    private int checkLengthLimit(long length, int elementSize, InlinedBranchProfile errorBranch) {
        if (length > (long)(this.getContext().getLanguageOptions().maxTypedArrayLength() / elementSize)) {
            errorBranch.enter(this);
            throw this.throwInappropriateLengthError(length);
        }
        return (int)length;
    }

    private static int toByteLength(int length, int elementSize) {
        int byteLength = length * elementSize;
        assert (byteLength >= 0 && byteLength / elementSize == length);
        return byteLength;
    }

    @CompilerDirectives.TruffleBoundary
    private RuntimeException throwInappropriateLengthError(long length) {
        if (this.getContext().isOptionNashornCompatibilityMode()) {
            throw Errors.createRangeError("inappropriate array buffer length: " + length);
        }
        throw Errors.createRangeError("Invalid typed array length: " + length);
    }

    private boolean rangeCheck(boolean condition, String message, InlinedBranchProfile errorBranch) {
        if (!condition) {
            errorBranch.enter(this);
            throw Errors.createRangeError(message);
        }
        return condition;
    }

    private boolean rangeCheckIsMultipleOfElementSize(boolean condition, String what, TruffleString name, int bytesPerElement, InlinedBranchProfile errorBranch) {
        if (!condition) {
            errorBranch.enter(this);
            throw JSConstructTypedArrayNode.createRangeErrorNotMultipleOfElementSize(what, name, bytesPerElement);
        }
        return condition;
    }

    @CompilerDirectives.TruffleBoundary
    private static RuntimeException createRangeErrorNotMultipleOfElementSize(String what, TruffleString name, int bytesPerElement) {
        return Errors.createRangeError(String.format("%s of %s should be a multiple of %d", what, name, bytesPerElement));
    }

    static abstract class IntegerIndexedObjectCreateNode
    extends JavaScriptBaseNode {
        final JSContext context;
        final TypedArrayFactory factory;

        IntegerIndexedObjectCreateNode(JSContext context, TypedArrayFactory factory) {
            this.context = context;
            this.factory = factory;
        }

        abstract JSDynamicObject execute(JSArrayBufferObject var1, TypedArray var2, int var3, int var4, JSDynamicObject var5);

        @Specialization(guards={"isDefaultPrototype(proto)"})
        JSDynamicObject doDefaultProto(JSArrayBufferObject arrayBuffer, TypedArray typedArray, int offset, int length, JSDynamicObject proto) {
            JSObjectFactory objectFactory = this.context.getArrayBufferViewFactory(this.factory);
            return JSArrayBufferView.createArrayBufferView(objectFactory, this.getRealm(), arrayBuffer, typedArray, offset, length);
        }

        @Specialization(guards={"!isDefaultPrototype(proto)", "context.isMultiContext()"})
        JSDynamicObject doMultiContext(JSArrayBufferObject arrayBuffer, TypedArray typedArray, int offset, int length, JSDynamicObject proto) {
            JSObjectFactory objectFactory = this.context.getArrayBufferViewFactory(this.factory);
            return JSArrayBufferView.createArrayBufferViewWithProto(objectFactory, this.getRealm(), arrayBuffer, typedArray, offset, length, proto);
        }

        @Specialization(guards={"!isDefaultPrototype(proto)", "!context.isMultiContext()", "proto == cachedProto"}, limit="1")
        JSDynamicObject doCachedProto(JSArrayBufferObject arrayBuffer, TypedArray typedArray, int offset, int length, JSDynamicObject proto, @Cached(value="proto") JSDynamicObject cachedProto, @Cached(value="makeObjectFactory(cachedProto)") JSObjectFactory objectFactory) {
            return JSArrayBufferView.createArrayBufferView(objectFactory, this.getRealm(), arrayBuffer, typedArray, offset, length);
        }

        @Specialization(guards={"!isDefaultPrototype(proto)", "!context.isMultiContext()"}, replaces={"doCachedProto"})
        JSDynamicObject doUncachedProto(JSArrayBufferObject arrayBuffer, TypedArray typedArray, int offset, int length, JSDynamicObject proto) {
            return JSArrayBufferView.createArrayBufferView(this.makeObjectFactory(proto), this.getRealm(), arrayBuffer, typedArray, offset, length);
        }

        boolean isDefaultPrototype(JSDynamicObject proto) {
            return proto == this.getRealm().getArrayBufferViewPrototype(this.factory);
        }

        @CompilerDirectives.TruffleBoundary
        JSObjectFactory makeObjectFactory(JSDynamicObject prototype) {
            return JSObjectFactory.createBound(this.context, prototype, JSObjectUtil.getProtoChildShape(prototype, JSArrayBufferView.INSTANCE, this.context));
        }
    }
}

