/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.MaterializedFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.GeneratorPrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.InternalCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSGenerator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSGeneratorObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Completion;

public final class GeneratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<GeneratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new GeneratorPrototypeBuiltins();

    protected GeneratorPrototypeBuiltins() {
        super(JSGenerator.PROTOTYPE_NAME, GeneratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, GeneratorPrototype builtinEnum) {
        Completion.Type resumeMethod;
        assert (context.getEcmaScriptVersion() >= 6);
        switch (builtinEnum.ordinal()) {
            case 0: {
                resumeMethod = Completion.Type.Normal;
                break;
            }
            case 1: {
                resumeMethod = Completion.Type.Return;
                break;
            }
            case 2: {
                resumeMethod = Completion.Type.Throw;
                break;
            }
            default: {
                return null;
            }
        }
        return GeneratorPrototypeBuiltinsFactory.GeneratorResumeNodeGen.create(context, builtin, resumeMethod, GeneratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
    }

    public static enum GeneratorPrototype implements BuiltinEnum<GeneratorPrototype>
    {
        next(1),
        return_(1),
        throw_(1);

        private final int length;

        private GeneratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class GeneratorResumeNode
    extends JSBuiltinNode {
        private final Completion.Type resumeType;
        @Node.Child
        private InternalCallNode callNode;

        public GeneratorResumeNode(JSContext context, JSBuiltin builtin, Completion.Type resumeType) {
            super(context, builtin);
            this.resumeType = resumeType;
            this.callNode = InternalCallNode.create();
        }

        @Specialization
        protected Object resume(JSGeneratorObject generator, Object value) {
            CallTarget generatorTarget = generator.getGeneratorTarget();
            MaterializedFrame generatorContext = generator.getGeneratorContext();
            return this.callNode.execute(generatorTarget, JSArguments.createResumeArguments(generatorContext, generator, this.resumeType, value));
        }

        @Fallback
        protected Object resume(Object thisObj, Object value) {
            throw Errors.createTypeErrorGeneratorObjectExpected();
        }
    }
}

