/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.ConstructorBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.DateFunctionBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToStringNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSDate;

public final class DateFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<DateFunction> {
    public static final JSBuiltinsContainer BUILTINS = new DateFunctionBuiltins();

    protected DateFunctionBuiltins() {
        super(JSDate.CLASS_NAME, DateFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, DateFunction builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return DateFunctionBuiltinsFactory.DateParseNodeGen.create(context, builtin, DateFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 1: {
                return DateFunctionBuiltinsFactory.DateNowNodeGen.create(context, builtin, DateFunctionBuiltins.args().createArgumentNodes(context));
            }
            case 2: {
                return DateFunctionBuiltinsFactory.DateUTCNodeGen.create(context, builtin, DateFunctionBuiltins.args().varArgs().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum DateFunction implements BuiltinEnum<DateFunction>
    {
        parse(1),
        now(0),
        UTC(7);

        private final int length;

        private DateFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class DateParseNode
    extends JSBuiltinNode {
        public DateParseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected double parse(Object parseDate, @Cached JSToStringNode toStringNode) {
            TruffleString dateString = toStringNode.executeString(parseDate);
            return ConstructorBuiltins.ConstructDateNode.parseDate(this.getJSContext(), this.getRealm(), dateString);
        }
    }

    public static abstract class DateNowNode
    extends JSBuiltinNode {
        public DateNowNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected double now() {
            return this.getRealm().currentTimeMillis();
        }
    }

    public static abstract class DateUTCNode
    extends JSBuiltinNode {
        public DateUTCNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected double utc(Object[] args, @Cached JSToNumberNode toNumberNode) {
            double[] argsEvaluated = new double[args.length];
            boolean isNaN = false;
            for (int i = 0; i < args.length; ++i) {
                double d = JSRuntime.doubleValue(toNumberNode.executeNumber(args[i]));
                if (Double.isNaN(d)) {
                    isNaN = true;
                }
                argsEvaluated[i] = d;
            }
            if (isNaN) {
                return Double.NaN;
            }
            return JSDate.executeConstructor(argsEvaluated, true);
        }
    }
}

