/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import java.util.EnumSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateCached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateInline;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.DataViewPrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.GetViewByteLengthNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToBigIntNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToDoubleNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToIndexNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.TypedArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSDataView;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSDataViewObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public final class DataViewPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<DataViewPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new DataViewPrototypeBuiltins();

    protected DataViewPrototypeBuiltins() {
        super(JSDataView.PROTOTYPE_NAME, DataViewPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, DataViewPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return DataViewPrototypeBuiltinsFactory.DataViewGetNodeGen.create(context, builtin, DataViewPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return DataViewPrototypeBuiltinsFactory.DataViewSetNodeGen.create(context, builtin, DataViewPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case 22: 
            case 23: 
            case 24: {
                return DataViewPrototypeBuiltinsFactory.DataViewGetterNodeGen.create(context, builtin, builtinEnum, DataViewPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    static void checkViewOutOfBounds(JSContext context, JSDataViewObject dataView, InlinedBranchProfile errorBranch, Node node) {
        JSArrayBufferObject arrayBuffer = dataView.getArrayBuffer();
        if (!context.getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(arrayBuffer)) {
            errorBranch.enter(node);
            throw Errors.createTypeErrorDetachedBuffer();
        }
        if (!context.getArrayBufferNotShrunkAssumption().isValid()) {
            long bufferByteLength = arrayBuffer.getByteLength();
            int byteOffsetStart = dataView.getByteOffset();
            long byteOffsetEnd = dataView.hasAutoLength() ? bufferByteLength : (long)(byteOffsetStart + dataView.getByteLength());
            if ((long)byteOffsetStart > bufferByteLength || byteOffsetEnd > bufferByteLength) {
                errorBranch.enter(node);
                throw Errors.createTypeErrorOutOfBoundsTypedArray();
            }
        }
    }

    public static enum DataViewPrototype implements BuiltinEnum<DataViewPrototype>
    {
        getBigInt64(1),
        getBigUint64(1),
        getFloat16(1),
        getFloat32(1),
        getFloat64(1),
        getInt8(1),
        getInt16(1),
        getInt32(1),
        getUint8(1),
        getUint16(1),
        getUint32(1),
        setBigInt64(2),
        setBigUint64(2),
        setFloat16(2),
        setFloat32(2),
        setFloat64(2),
        setInt8(2),
        setInt16(2),
        setInt32(2),
        setUint8(2),
        setUint16(2),
        setUint32(2),
        buffer(0),
        byteLength(0),
        byteOffset(0);

        private final int length;

        private DataViewPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(buffer, byteLength, byteOffset).contains(this);
        }

        @Override
        public int getECMAScriptVersion() {
            return switch (this.ordinal()) {
                case 2, 13 -> 16;
                default -> BuiltinEnum.super.getECMAScriptVersion();
            };
        }
    }

    public static abstract class DataViewGetNode
    extends DataViewAccessNode {
        public DataViewGetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final Object doDataView(JSDataViewObject dataView, Object byteOffset, Object littleEndian, @Cached JSToIndexNode toIndexNode, @Cached(inline=true) JSToBooleanNode toBooleanNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedExactClassProfile bufferTypeProfile, @Cached GetViewByteLengthNode getViewByteLengthNode, @Cached GetBufferElementNode getBufferElement) {
            long getIndex = toIndexNode.executeLong(byteOffset);
            boolean isLittleEndian = this.factory.getBytesPerElement() == 1 || toBooleanNode.executeBoolean(this, littleEndian);
            JSArrayBufferObject buffer = bufferTypeProfile.profile(this, dataView.getArrayBuffer());
            DataViewPrototypeBuiltins.checkViewOutOfBounds(this.getContext(), dataView, errorBranch, this);
            int bufferIndex = this.getBufferIndex(dataView, getIndex, errorBranch, getViewByteLengthNode);
            return getBufferElement.execute(this, buffer, bufferIndex, isLittleEndian, this.factory);
        }

        @Specialization(guards={"!isJSDataView(thisObj)"})
        protected JSDynamicObject doIncompatibleReceiver(Object thisObj, Object byteOffset, Object littleEndian) {
            throw Errors.createTypeErrorNotADataView();
        }

        @GenerateInline
        @GenerateCached(value=false)
        @ImportStatic(value={JSConfig.class})
        public static abstract class GetBufferElementNode
        extends JavaScriptBaseNode {
            protected abstract Object execute(Node var1, JSArrayBufferObject var2, int var3, boolean var4, TypedArrayFactory var5);

            @Specialization
            static Object doHeapArrayBuffer(JSArrayBufferObject.Heap buffer, int bufferIndex, boolean littleEndian, TypedArrayFactory factory) {
                assert (!JSArrayBuffer.isJSInteropArrayBuffer(buffer) && !JSArrayBuffer.isJSDirectOrSharedArrayBuffer(buffer)) : buffer;
                CompilerAsserts.partialEvaluationConstant(factory);
                TypedArray strategy = factory.createArrayType((byte)0, true, false);
                CompilerAsserts.partialEvaluationConstant(strategy);
                return strategy.getBufferElement(buffer, bufferIndex, littleEndian, null);
            }

            @Specialization
            static Object doDirectOrSharedArrayBuffer(JSArrayBufferObject.DirectBase buffer, int bufferIndex, boolean littleEndian, TypedArrayFactory factory) {
                assert (!JSArrayBuffer.isJSInteropArrayBuffer(buffer) && JSArrayBuffer.isJSDirectOrSharedArrayBuffer(buffer)) : buffer;
                CompilerAsserts.partialEvaluationConstant(factory);
                TypedArray strategy = factory.createArrayType((byte)1, true, false);
                CompilerAsserts.partialEvaluationConstant(strategy);
                return strategy.getBufferElement(buffer, bufferIndex, littleEndian, null);
            }

            @Specialization
            static Object doInteropBuffer(JSArrayBufferObject.Interop buffer, int bufferIndex, boolean littleEndian, TypedArrayFactory factory, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
                assert (JSArrayBuffer.isJSInteropArrayBuffer(buffer) && !JSArrayBuffer.isJSDirectOrSharedArrayBuffer(buffer)) : buffer;
                CompilerAsserts.partialEvaluationConstant(factory);
                TypedArray strategy = factory.createArrayType((byte)-1, true, false);
                CompilerAsserts.partialEvaluationConstant(strategy);
                return strategy.getBufferElement(buffer, bufferIndex, littleEndian, interop);
            }
        }
    }

    public static abstract class DataViewSetNode
    extends DataViewAccessNode {
        @Node.Child
        private JSToBigIntNode toBigIntNode;
        @Node.Child
        private JSToDoubleNode toDoubleNode;
        @Node.Child
        private JSToInt32Node toInt32Node;

        public DataViewSetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            if (this.factory.isBigInt()) {
                this.toBigIntNode = JSToBigIntNode.create();
            } else if (this.factory.isFloat()) {
                this.toDoubleNode = JSToDoubleNode.create();
            } else {
                this.toInt32Node = JSToInt32Node.create();
            }
        }

        @Specialization
        protected Object doDataView(JSDataViewObject dataView, Object byteOffset, Object value, Object littleEndian, @Cached JSToIndexNode toIndexNode, @Cached(inline=true) JSToBooleanNode toBooleanNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedExactClassProfile bufferTypeProfile, @Cached GetViewByteLengthNode getViewByteLengthNode, @Cached SetBufferElementNode setBufferElement) {
            long getIndex = toIndexNode.executeLong(byteOffset);
            Comparable<BigInt> numberValue = switch (this.factory) {
                case TypedArrayFactory.BigInt64Array, TypedArrayFactory.BigUint64Array -> this.toBigIntNode.executeBigInteger(value);
                case TypedArrayFactory.Float64Array, TypedArrayFactory.Float32Array, TypedArrayFactory.Float16Array -> Double.valueOf(this.toDoubleNode.executeDouble(value));
                default -> Integer.valueOf(this.toInt32Node.executeInt(value));
            };
            boolean isLittleEndian = this.factory.getBytesPerElement() == 1 || toBooleanNode.executeBoolean(this, littleEndian);
            JSArrayBufferObject buffer = bufferTypeProfile.profile(this, dataView.getArrayBuffer());
            DataViewPrototypeBuiltins.checkViewOutOfBounds(this.getContext(), dataView, errorBranch, this);
            int bufferIndex = this.getBufferIndex(dataView, getIndex, errorBranch, getViewByteLengthNode);
            setBufferElement.execute(this, buffer, bufferIndex, isLittleEndian, numberValue, this.factory);
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSDataView(thisObj)"})
        protected JSDynamicObject doIncompatibleReceiver(Object thisObj, Object byteOffset, Object value, Object littleEndian) {
            throw Errors.createTypeErrorNotADataView();
        }

        @GenerateInline
        @GenerateCached(value=false)
        @ImportStatic(value={JSConfig.class})
        public static abstract class SetBufferElementNode
        extends JavaScriptBaseNode {
            protected abstract void execute(Node var1, JSArrayBufferObject var2, int var3, boolean var4, Object var5, TypedArrayFactory var6);

            @Specialization
            static void doHeapArrayBuffer(JSArrayBufferObject.Heap buffer, int bufferIndex, boolean littleEndian, Object value, TypedArrayFactory factory) {
                assert (!JSArrayBuffer.isJSInteropArrayBuffer(buffer) && !JSArrayBuffer.isJSDirectOrSharedArrayBuffer(buffer)) : buffer;
                CompilerAsserts.partialEvaluationConstant(factory);
                TypedArray strategy = factory.createArrayType((byte)0, true, false);
                CompilerAsserts.partialEvaluationConstant(strategy);
                strategy.setBufferElement(buffer, bufferIndex, littleEndian, value, null);
            }

            @Specialization
            static void doDirectOrSharedArrayBuffer(JSArrayBufferObject.DirectBase buffer, int bufferIndex, boolean littleEndian, Object value, TypedArrayFactory factory) {
                assert (!JSArrayBuffer.isJSInteropArrayBuffer(buffer) && JSArrayBuffer.isJSDirectOrSharedArrayBuffer(buffer)) : buffer;
                CompilerAsserts.partialEvaluationConstant(factory);
                TypedArray strategy = factory.createArrayType((byte)1, true, false);
                CompilerAsserts.partialEvaluationConstant(strategy);
                strategy.setBufferElement(buffer, bufferIndex, littleEndian, value, null);
            }

            @Specialization
            static void doInteropBuffer(JSArrayBufferObject.Interop buffer, int bufferIndex, boolean littleEndian, Object value, TypedArrayFactory factory, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
                assert (JSArrayBuffer.isJSInteropArrayBuffer(buffer) && !JSArrayBuffer.isJSDirectOrSharedArrayBuffer(buffer)) : buffer;
                CompilerAsserts.partialEvaluationConstant(factory);
                TypedArray strategy = factory.createArrayType((byte)-1, true, false);
                CompilerAsserts.partialEvaluationConstant(strategy);
                strategy.setBufferElement(buffer, bufferIndex, littleEndian, value, interop);
            }
        }
    }

    @ImportStatic(value={JSDataView.class})
    public static abstract class DataViewGetterNode
    extends JSBuiltinNode {
        private final DataViewPrototype getter;

        public DataViewGetterNode(JSContext context, JSBuiltin builtin, DataViewPrototype getter) {
            super(context, builtin);
            this.getter = getter;
        }

        @Specialization
        protected final Object doDataView(JSDataViewObject dataView, @Cached GetViewByteLengthNode getViewByteLengthNode, @Cached InlinedBranchProfile errorBranch) {
            switch (this.getter.ordinal()) {
                case 22: {
                    return dataView.getArrayBuffer();
                }
                case 23: {
                    DataViewPrototypeBuiltins.checkViewOutOfBounds(this.getContext(), dataView, errorBranch, this);
                    return getViewByteLengthNode.execute(dataView, this.getContext());
                }
                case 24: {
                    DataViewPrototypeBuiltins.checkViewOutOfBounds(this.getContext(), dataView, errorBranch, this);
                    return dataView.getByteOffset();
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSDataView(thisObj)"})
        protected Object doIncompatibleReceiver(Object thisObj) {
            throw Errors.createTypeErrorNotADataView();
        }
    }

    @ImportStatic(value={JSDataView.class})
    public static abstract class DataViewAccessNode
    extends JSBuiltinNode {
        protected final TypedArrayFactory factory;

        public DataViewAccessNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.factory = DataViewAccessNode.typedArrayFactoryFromType(Strings.lazySubstring(builtin.getName(), 3));
        }

        private static TypedArrayFactory typedArrayFactoryFromType(TruffleString type) {
            for (TypedArrayFactory factory : TypedArray.factories()) {
                if (!Strings.startsWith(factory.getName(), type)) continue;
                return factory;
            }
            throw new IllegalArgumentException(Strings.toJavaString(type));
        }

        protected final int getBufferIndex(JSDataViewObject dataView, long getIndex, InlinedBranchProfile errorBranch, GetViewByteLengthNode getViewByteLengthNode) {
            int viewLength = getViewByteLengthNode.execute(dataView, this.getContext());
            int elementSize = this.factory.getBytesPerElement();
            if (getIndex + (long)elementSize > (long)viewLength) {
                errorBranch.enter(this);
                throw Errors.createRangeError("index + elementSize > viewLength");
            }
            int viewOffset = dataView.getByteOffset();
            assert (getIndex + (long)viewOffset <= Integer.MAX_VALUE);
            int bufferIndex = (int)(getIndex + (long)viewOffset);
            return bufferIndex;
        }
    }
}

