/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.api;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.GenerateLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.Library;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.LibraryFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSPromise;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSPromiseObject;

@GenerateLibrary
public abstract class PromiseLibrary
extends Library {
    private static final LibraryFactory<PromiseLibrary> FACTORY = LibraryFactory.resolve(PromiseLibrary.class);

    public static LibraryFactory<PromiseLibrary> getFactory() {
        return FACTORY;
    }

    public static PromiseLibrary getUncached() {
        return FACTORY.getUncached();
    }

    public boolean isPromise(Object object) {
        return object instanceof JSPromiseObject;
    }

    public State getState(Object promise) throws UnsupportedMessageException {
        if (promise instanceof JSPromiseObject) {
            JSPromiseObject jsPromise = (JSPromiseObject)promise;
            int state = JSPromise.getPromiseState(jsPromise);
            return switch (state) {
                case 0 -> State.PENDING;
                case 1 -> State.FULFILLED;
                case 2 -> State.REJECTED;
                default -> throw Errors.shouldNotReachHereUnexpectedValue(state);
            };
        }
        throw UnsupportedMessageException.create();
    }

    public void markHandled(Object promise) throws UnsupportedMessageException {
        if (!(promise instanceof JSPromiseObject)) {
            throw UnsupportedMessageException.create();
        }
        JSPromiseObject jsPromise = (JSPromiseObject)promise;
        jsPromise.setIsHandled(true);
    }

    public static enum State {
        PENDING,
        FULFILLED,
        REJECTED;

    }
}

