/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.api;

import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GeneratedBy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.DynamicDispatchLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.Library;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.LibraryExport;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.LibraryFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.Message;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ReflectionLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.DenyReplace;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.ExplodeLoop;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.UnadoptableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.utilities.FinalBitSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.api.ArrayBufferLibrary;

@GeneratedBy(value=ArrayBufferLibrary.class)
final class ArrayBufferLibraryGen
extends LibraryFactory<ArrayBufferLibrary> {
    private static final Class<ArrayBufferLibrary> LIBRARY_CLASS = ArrayBufferLibraryGen.lazyLibraryClass();
    private static final Message IS_ARRAY_BUFFER = new MessageImpl("isArrayBuffer", 0, false, Boolean.TYPE, Object.class);
    private static final Message GET_CONTENTS = new MessageImpl("getContents", 1, false, ByteBuffer.class, Object.class);
    private static final Message GET_BYTE_LENGTH = new MessageImpl("getByteLength", 2, false, Integer.TYPE, Object.class);
    private static final ArrayBufferLibraryGen INSTANCE = new ArrayBufferLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private ArrayBufferLibraryGen() {
        super(LIBRARY_CLASS, List.of(IS_ARRAY_BUFFER, GET_CONTENTS, GET_BYTE_LENGTH));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        return ArrayBufferLibrary.class;
    }

    @Override
    protected MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    protected ArrayBufferLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected ArrayBufferLibrary createDelegate(ArrayBufferLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        ArrayBufferLibrary lib = (ArrayBufferLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.isArrayBuffer(receiver);
            }
            case 1: {
                return lib.getContents(receiver);
            }
            case 2: {
                return lib.getByteLength(receiver);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected ArrayBufferLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected ArrayBufferLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<ArrayBufferLibrary> lazyLibraryClass() {
        try {
            return Class.forName("org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.api.ArrayBufferLibrary", false, ArrayBufferLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, new Default());
        LibraryFactory.register(LIBRARY_CLASS, INSTANCE);
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    private static final class Proxy
    extends ArrayBufferLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isArrayBuffer(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_ARRAY_BUFFER, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public ByteBuffer getContents(Object receiver_) throws UnsupportedMessageException {
            try {
                return (ByteBuffer)this.lib.send(receiver_, GET_CONTENTS, new Object[0]);
            }
            catch (RuntimeException | UnsupportedMessageException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public int getByteLength(Object receiver_) throws UnsupportedMessageException {
            try {
                return (Integer)this.lib.send(receiver_, GET_BYTE_LENGTH, new Object[0]);
            }
            catch (RuntimeException | UnsupportedMessageException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    private static final class Delegate
    extends ArrayBufferLibrary {
        @Node.Child
        private ArrayBufferLibrary delegateLibrary;

        Delegate(ArrayBufferLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isArrayBuffer(Object receiver_) {
            if (ArrayBufferLibraryGen.isDelegated(this.delegateLibrary, 0)) {
                Object delegate = ArrayBufferLibraryGen.readDelegate(this.delegateLibrary, receiver_);
                return ((ArrayBufferLibrary)ArrayBufferLibraryGen.getDelegateLibrary(this.delegateLibrary, delegate)).isArrayBuffer(delegate);
            }
            return this.delegateLibrary.isArrayBuffer(receiver_);
        }

        @Override
        public ByteBuffer getContents(Object receiver_) throws UnsupportedMessageException {
            if (ArrayBufferLibraryGen.isDelegated(this.delegateLibrary, 1)) {
                Object delegate = ArrayBufferLibraryGen.readDelegate(this.delegateLibrary, receiver_);
                return ((ArrayBufferLibrary)ArrayBufferLibraryGen.getDelegateLibrary(this.delegateLibrary, delegate)).getContents(delegate);
            }
            return this.delegateLibrary.getContents(receiver_);
        }

        @Override
        public int getByteLength(Object receiver_) throws UnsupportedMessageException {
            if (ArrayBufferLibraryGen.isDelegated(this.delegateLibrary, 2)) {
                Object delegate = ArrayBufferLibraryGen.readDelegate(this.delegateLibrary, receiver_);
                return ((ArrayBufferLibrary)ArrayBufferLibraryGen.getDelegateLibrary(this.delegateLibrary, delegate)).getByteLength(delegate);
            }
            return this.delegateLibrary.getByteLength(receiver_);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(ArrayBufferLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    private static abstract class CachedDispatch
    extends ArrayBufferLibrary {
        @Node.Child
        ArrayBufferLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(ArrayBufferLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public boolean isArrayBuffer(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayBufferLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isArrayBuffer(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public ByteBuffer getContents(Object receiver_) throws UnsupportedMessageException {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayBufferLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getContents(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int getByteLength(Object receiver_) throws UnsupportedMessageException {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayBufferLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getByteLength(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                ArrayBufferLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = this.insert((ArrayBufferLibrary)INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        ArrayBufferLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = this.insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = this.insert(new CachedDispatchNext((ArrayBufferLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends ArrayBufferLibrary
    implements UnadoptableNode {
        private UncachedDispatch() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isArrayBuffer(Object receiver_) {
            return ((ArrayBufferLibrary)INSTANCE.getUncached(receiver_)).isArrayBuffer(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public ByteBuffer getContents(Object receiver_) throws UnsupportedMessageException {
            return ((ArrayBufferLibrary)INSTANCE.getUncached(receiver_)).getContents(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int getByteLength(Object receiver_) throws UnsupportedMessageException {
            return ((ArrayBufferLibrary)INSTANCE.getUncached(receiver_)).getByteLength(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, parameters);
        }
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    private static final class Default
    extends LibraryExport<ArrayBufferLibrary> {
        private Default() {
            super(ArrayBufferLibrary.class, Object.class, false, false, 0);
        }

        @Override
        protected ArrayBufferLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected ArrayBufferLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=ArrayBufferLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends ArrayBufferLibrary
        implements UnadoptableNode {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayBuffer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isArrayBuffer(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ByteBuffer getContents(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getContents(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int getByteLength(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getByteLength(receiver);
            }
        }

        @GeneratedBy(value=ArrayBufferLibrary.class)
        private static final class Cached
        extends ArrayBufferLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = this.insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public boolean isArrayBuffer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isArrayBuffer(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public ByteBuffer getContents(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getContents(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public int getByteLength(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getByteLength(this.dynamicDispatch_.cast(receiver));
            }
        }
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(ArrayBufferLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    private static final class CachedToUncachedDispatch
    extends ArrayBufferLibrary {
        private CachedToUncachedDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isArrayBuffer(Object receiver_) {
            assert (ArrayBufferLibraryGen.assertAdopted(this));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((ArrayBufferLibrary)INSTANCE.getUncached(receiver_)).isArrayBuffer(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public ByteBuffer getContents(Object receiver_) throws UnsupportedMessageException {
            assert (ArrayBufferLibraryGen.assertAdopted(this));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ByteBuffer byteBuffer = ((ArrayBufferLibrary)INSTANCE.getUncached(receiver_)).getContents(receiver_);
                return byteBuffer;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int getByteLength(Object receiver_) throws UnsupportedMessageException {
            assert (ArrayBufferLibraryGen.assertAdopted(this));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((ArrayBufferLibrary)INSTANCE.getUncached(receiver_)).getByteLength(receiver_);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

